/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.gradle.plugins.target.platform;

import com.liferay.gradle.plugins.target.platform.extensions.TargetPlatformExtension;
import com.liferay.gradle.plugins.target.platform.internal.util.GradleUtil;
import com.liferay.gradle.plugins.target.platform.internal.util.SkipIfExecutingParentTaskSpec;
import com.liferay.gradle.plugins.target.platform.internal.util.TargetPlatformPluginUtil;
import com.liferay.gradle.plugins.target.platform.tasks.ResolveTask;
import groovy.lang.Closure;
import io.spring.gradle.dependencymanagement.DependencyManagementPlugin;
import java.util.Arrays;
import java.util.Set;
import java.util.concurrent.Callable;
import org.gradle.api.Action;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.artifacts.dsl.DependencyHandler;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.FileCollection;
import org.gradle.api.invocation.Gradle;
import org.gradle.api.logging.Logger;
import org.gradle.api.plugins.ExtensionAware;
import org.gradle.api.plugins.JavaPlugin;
import org.gradle.api.plugins.PluginContainer;
import org.gradle.api.specs.Spec;
import org.gradle.api.tasks.TaskContainer;
import org.gradle.api.tasks.bundling.Jar;

public class TargetPlatformPlugin
implements Plugin<Project> {
    public static final String PLUGIN_NAME = "targetPlatform";
    public static final String RESOLVE_TASK_NAME = "resolve";
    public static final String TARGET_PLATFORM_BOMS_CONFIGURATION_NAME = "targetPlatformBoms";
    public static final String TARGET_PLATFORM_BUNDLES_CONFIGURATION_NAME = "targetPlatformBundles";
    public static final String TARGET_PLATFORM_DISTRO_CONFIGURATION_NAME = "targetPlatformDistro";
    public static final String TARGET_PLATFORM_REQUIREMENTS_CONFIGURATION_NAME = "targetPlatformRequirements";
    private static final Iterable<String> _configurationNames = Arrays.asList("compile", "compileClasspath", "compileInclude", "compileOnly", "default", "implementation", "originalModule", "parentThemes", "portalCommonCSS", "runtime", "runtimeClasspath", "runtimeImplementation", "runtimeOnly", "testCompileClasspath", "testCompileOnly", "testIntegration", "testImplementation", "testRuntime", "testRuntimeClasspath", "testRuntimeOnly");
    private static final Spec<Task> _skipIfExecutingParentTaskSpec = new SkipIfExecutingParentTaskSpec();

    public void apply(final Project project) {
        GradleUtil.applyPlugin((Project)project, DependencyManagementPlugin.class);
        final TargetPlatformExtension targetPlatformExtension = (TargetPlatformExtension)GradleUtil.addExtension((ExtensionAware)project, (String)PLUGIN_NAME, TargetPlatformExtension.class);
        final Configuration targetPlatformBomsConfiguration = TargetPlatformPlugin._addConfigurationTargetPlatformBoms(project);
        final Configuration targetPlatformBundlesConfiguration = TargetPlatformPlugin._addConfigurationTargetPlatformBundles(project);
        final Configuration targetPlatformDistroConfiguration = TargetPlatformPlugin._addConfigurationTargetPlatformDistro(project);
        final Configuration targetPlatformRequirementsConfiguration = TargetPlatformPlugin._addConfigurationTargetPlatformRequirements(project);
        this._addTaskResolve(project, (FileCollection)targetPlatformBundlesConfiguration, (FileCollection)targetPlatformDistroConfiguration, (FileCollection)targetPlatformRequirementsConfiguration);
        this._configureTasksResolve(project, targetPlatformExtension);
        PluginContainer pluginContainer = project.getPlugins();
        pluginContainer.withType(JavaPlugin.class, (Action)new Action<JavaPlugin>(){

            public void execute(JavaPlugin javaPlugin) {
                TargetPlatformPlugin.this._addDependenciesBundleAndRequirement(project, "jar", project.getDependencies(), targetPlatformBundlesConfiguration, targetPlatformRequirementsConfiguration);
                TargetPlatformPluginUtil.configureDependencyManagement(project, targetPlatformBomsConfiguration, _configurationNames);
            }
        });
        Gradle gradle = project.getGradle();
        gradle.afterProject((Closure)new Closure<Void>((Object)project){

            public void doCall(Project subproject) {
                Set<Project> subprojects = targetPlatformExtension.getSubprojects();
                if (subprojects.contains(subproject)) {
                    TargetPlatformPlugin.this._configureSubproject(subproject, project.getDependencies(), project.getLogger(), targetPlatformBomsConfiguration, targetPlatformBundlesConfiguration, targetPlatformDistroConfiguration, targetPlatformRequirementsConfiguration, targetPlatformExtension);
                }
            }
        });
    }

    private static Configuration _addConfigurationTargetPlatformBoms(Project project) {
        Configuration configuration = GradleUtil.addConfiguration((Project)project, (String)TARGET_PLATFORM_BOMS_CONFIGURATION_NAME);
        configuration.setDescription("Configures all the BOMs to import as managed dependencies.");
        configuration.setTransitive(false);
        configuration.setVisible(false);
        return configuration;
    }

    private static Configuration _addConfigurationTargetPlatformBundles(Project project) {
        Configuration configuration = GradleUtil.addConfiguration((Project)project, (String)TARGET_PLATFORM_BUNDLES_CONFIGURATION_NAME);
        configuration.setDescription("Configures all the bundles in addition to the distro to resolve against.");
        configuration.setTransitive(false);
        configuration.setVisible(false);
        return configuration;
    }

    private static Configuration _addConfigurationTargetPlatformDistro(Project project) {
        Configuration configuration = GradleUtil.addConfiguration((Project)project, (String)TARGET_PLATFORM_DISTRO_CONFIGURATION_NAME);
        configuration.setDescription("Configures the distro JAR file to use as base for resolving against.");
        configuration.setTransitive(false);
        configuration.setVisible(false);
        return configuration;
    }

    private static Configuration _addConfigurationTargetPlatformRequirements(Project project) {
        Configuration configuration = GradleUtil.addConfiguration((Project)project, (String)TARGET_PLATFORM_REQUIREMENTS_CONFIGURATION_NAME);
        configuration.setDescription("Configures the list of JAR files to use as run requirements for resolving.");
        configuration.setTransitive(false);
        configuration.setVisible(false);
        return configuration;
    }

    private void _addDependenciesBundleAndRequirement(Object object, DependencyHandler dependencyHandler, Configuration targetPlatformBundlesConfiguration, Configuration targetPlatformRequirementsConfiguration) {
        Dependency dependency = dependencyHandler.create(object);
        GradleUtil.addDependency(targetPlatformRequirementsConfiguration, dependency);
        GradleUtil.addDependency(targetPlatformBundlesConfiguration, dependency);
    }

    private void _addDependenciesBundleAndRequirement(Project project, String taskName, DependencyHandler dependencyHandler, Configuration targetPlatformBundlesConfiguration, Configuration targetPlatformRequirementsConfiguration) {
        Task task = GradleUtil.getTask((Project)project, (String)taskName);
        ConfigurableFileCollection fileCollection = project.files(new Object[]{task});
        this._addDependenciesBundleAndRequirement(fileCollection, dependencyHandler, targetPlatformBundlesConfiguration, targetPlatformRequirementsConfiguration);
    }

    private ResolveTask _addTaskResolve(Project project, FileCollection bundles, FileCollection distro, FileCollection requirements) {
        ResolveTask resolveTask = (ResolveTask)GradleUtil.addTask((Project)project, (String)RESOLVE_TASK_NAME, ResolveTask.class);
        resolveTask.onlyIf(_skipIfExecutingParentTaskSpec);
        resolveTask.setBundles(bundles);
        resolveTask.setDistro(distro);
        resolveTask.setDescription("Checks whether a set of OSGi bundles can be found to meet all the requirements of the current project.");
        resolveTask.setGroup("verification");
        resolveTask.setRequirements(requirements);
        return resolveTask;
    }

    private void _configureSubproject(Project subproject, DependencyHandler dependencyHandler, Logger logger, Configuration targetPlatformBomsConfiguration, Configuration targetPlatformBundlesConfiguration, Configuration targetPlatformDistroConfiguration, Configuration targetPlatformRequirementsConfiguration, TargetPlatformExtension targetPlatformExtension) {
        TaskContainer taskContainer = subproject.getTasks();
        Task jarTask = (Task)taskContainer.findByName("jar");
        if (!(jarTask instanceof Jar)) {
            if (logger.isInfoEnabled()) {
                logger.info("Excluding {} because it is not a valid Java project", (Object)subproject);
            }
            return;
        }
        Spec<Project> spec = targetPlatformExtension.getOnlyIf();
        if (!spec.isSatisfiedBy((Object)subproject)) {
            if (logger.isInfoEnabled()) {
                logger.info("Explicitly excluding {}", (Object)subproject);
            }
            return;
        }
        GradleUtil.applyPlugin((Project)subproject, DependencyManagementPlugin.class);
        TargetPlatformPluginUtil.configureDependencyManagement(subproject, targetPlatformBomsConfiguration, _configurationNames);
        spec = targetPlatformExtension.getResolveOnlyIf();
        if (spec.isSatisfiedBy((Object)subproject)) {
            this._addDependenciesBundleAndRequirement(subproject, dependencyHandler, targetPlatformBundlesConfiguration, targetPlatformRequirementsConfiguration);
            ConfigurableFileCollection requirements = subproject.files(new Object[]{jarTask});
            this._addTaskResolve(subproject, (FileCollection)targetPlatformBundlesConfiguration, (FileCollection)targetPlatformDistroConfiguration, (FileCollection)requirements);
            this._configureTasksResolve(subproject, targetPlatformExtension);
        } else if (logger.isInfoEnabled()) {
            logger.info("Explicitly excluding {} from resolution", (Object)subproject);
        }
    }

    private void _configureTaskResolve(ResolveTask resolveTask, final TargetPlatformExtension targetPlatformExtension) {
        resolveTask.setIgnoreFailures(new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                return targetPlatformExtension.isIgnoreResolveFailures();
            }
        });
    }

    private void _configureTasksResolve(Project project, final TargetPlatformExtension targetPlatformExtension) {
        TaskContainer taskContainer = project.getTasks();
        taskContainer.withType(ResolveTask.class, (Action)new Action<ResolveTask>(){

            public void execute(ResolveTask resolveTask) {
                TargetPlatformPlugin.this._configureTaskResolve(resolveTask, targetPlatformExtension);
            }
        });
    }
}

