/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.gradle.plugins.source.formatter;

import com.liferay.gradle.util.GradleUtil;
import com.liferay.gradle.util.tasks.ExecuteJavaTask;
import com.liferay.source.formatter.SourceFormatterArgs;
import java.io.File;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.inject.Inject;
import org.gradle.api.Project;
import org.gradle.api.file.FileCollection;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.util.CollectionUtils;
import org.gradle.workers.WorkerExecutor;

@CacheableTask
public class FormatSourceTask
extends ExecuteJavaTask {
    private FileCollection _classpath;
    private final SourceFormatterArgs _sourceFormatterArgs = new SourceFormatterArgs();

    @Inject
    public FormatSourceTask(WorkerExecutor workerExecutor) {
        super(workerExecutor);
    }

    public File getBaseDir() {
        return GradleUtil.toFile((Project)this.getProject(), (Object)this._sourceFormatterArgs.getBaseDirName());
    }

    public String getBaseDirName() {
        return this._sourceFormatterArgs.getBaseDirName();
    }

    public FileCollection getClasspath() {
        return this._classpath;
    }

    public List<String> getFileExtensions() {
        return this._sourceFormatterArgs.getFileExtensions();
    }

    public List<String> getFileNames() {
        return this._sourceFormatterArgs.getFileNames();
    }

    public FileCollection getFiles() {
        Project project = this.getProject();
        List<String> fileNames = this._sourceFormatterArgs.getFileNames();
        if (fileNames == null) {
            fileNames = Collections.emptyList();
        }
        return project.files(new Object[]{fileNames});
    }

    public String getGitWorkingBranchName() {
        return this._sourceFormatterArgs.getGitWorkingBranchName();
    }

    public int getMaxLineLength() {
        return this._sourceFormatterArgs.getMaxLineLength();
    }

    public int getProcessorThreadCount() {
        return this._sourceFormatterArgs.getProcessorThreadCount();
    }

    public boolean isAutoFix() {
        return this._sourceFormatterArgs.isAutoFix();
    }

    public boolean isFormatCurrentBranch() {
        return this._sourceFormatterArgs.isFormatCurrentBranch();
    }

    public boolean isFormatLatestAuthor() {
        return this._sourceFormatterArgs.isFormatLatestAuthor();
    }

    public boolean isFormatLocalChanges() {
        return this._sourceFormatterArgs.isFormatLocalChanges();
    }

    public boolean isIncludeSubrepositories() {
        return this._sourceFormatterArgs.isIncludeSubrepositories();
    }

    public boolean isPrintErrors() {
        return this._sourceFormatterArgs.isPrintErrors();
    }

    public boolean isShowDebugInformation() {
        return this._sourceFormatterArgs.isShowDebugInformation();
    }

    public boolean isShowDocumentation() {
        return this._sourceFormatterArgs.isShowDocumentation();
    }

    public boolean isShowStatusUpdates() {
        return this._sourceFormatterArgs.isShowStatusUpdates();
    }

    public boolean isThrowException() {
        return this._sourceFormatterArgs.isThrowException();
    }

    public void setAutoFix(boolean autoFix) {
        this._sourceFormatterArgs.setAutoFix(autoFix);
    }

    public void setBaseDirName(String baseDirName) {
        this._sourceFormatterArgs.setBaseDirName(baseDirName);
    }

    public void setClasspath(FileCollection classpath) {
        this._classpath = classpath;
    }

    public void setFileExtensions(Iterable<String> fileExtensions) {
        this._sourceFormatterArgs.setFileExtensions(CollectionUtils.toList(fileExtensions));
    }

    public void setFileExtensions(String ... fileExtensions) {
        this._sourceFormatterArgs.setFileExtensions(CollectionUtils.toList((Object[])fileExtensions));
    }

    public void setFileNames(Iterable<String> fileNames) {
        this._sourceFormatterArgs.setFileNames(CollectionUtils.toStringList(fileNames));
    }

    public void setFileNames(String ... fileNames) {
        this.setFileNames(Arrays.asList(fileNames));
    }

    public void setFormatCurrentBranch(boolean formatCurrentBranch) {
        this._sourceFormatterArgs.setFormatCurrentBranch(formatCurrentBranch);
    }

    public void setFormatLatestAuthor(boolean formatLatestAuthor) {
        this._sourceFormatterArgs.setFormatLatestAuthor(formatLatestAuthor);
    }

    public void setFormatLocalChanges(boolean formatLocalChanges) {
        this._sourceFormatterArgs.setFormatLocalChanges(formatLocalChanges);
    }

    public void setGitWorkingBranchName(String gitWorkingBranchName) {
        this._sourceFormatterArgs.setGitWorkingBranchName(gitWorkingBranchName);
    }

    public void setIncludeSubrepositories(boolean includeSubrepositories) {
        this._sourceFormatterArgs.setIncludeSubrepositories(includeSubrepositories);
    }

    public void setMaxLineLength(int maxLineLength) {
        this._sourceFormatterArgs.setMaxLineLength(maxLineLength);
    }

    public void setPrintErrors(boolean printErrors) {
        this._sourceFormatterArgs.setPrintErrors(printErrors);
    }

    public void setProcessorThreadCount(int processorThreadCount) {
        this._sourceFormatterArgs.setProcessorThreadCount(processorThreadCount);
    }

    public void setShowDebugInformation(boolean showDebugInformation) {
        this._sourceFormatterArgs.setShowDebugInformation(showDebugInformation);
    }

    public void setShowDocumentation(boolean showDocumentation) {
        this._sourceFormatterArgs.setShowDocumentation(showDocumentation);
    }

    public void setShowStatusUpdates(boolean showStatusUpdates) {
        this._sourceFormatterArgs.setShowStatusUpdates(showStatusUpdates);
    }

    public void setThrowException(boolean throwException) {
        this._sourceFormatterArgs.setThrowException(throwException);
    }

    protected List<String> getArgs() {
        ArrayList<String> args = new ArrayList<String>();
        args.add("format.current.branch=" + this.isFormatCurrentBranch());
        args.add("format.latest.author=" + this.isFormatLatestAuthor());
        args.add("format.local.changes=" + this.isFormatLocalChanges());
        args.add("git.working.branch.name=" + this.getGitWorkingBranchName());
        args.add("include.subrepositories=" + this.isIncludeSubrepositories());
        args.add("max.line.length=" + this.getMaxLineLength());
        args.add("processor.thread.count=" + this.getProcessorThreadCount());
        args.add("show.debug.information=" + this.isShowDebugInformation());
        args.add("show.documentation=" + this.isShowDocumentation());
        args.add("show.status.updates=" + this.isShowStatusUpdates());
        args.add("source.auto.fix=" + this.isAutoFix());
        args.add("source.file.extensions=" + CollectionUtils.join((String)",", this.getFileExtensions()));
        args.add("source.print.errors=" + this.isPrintErrors());
        args.add("source.throw.exception=" + this.isThrowException());
        FileCollection fileCollection = this.getFiles();
        if (fileCollection.isEmpty()) {
            args.add("source.base.dir=" + this._normalize(this.getBaseDir()));
        } else {
            args.add("source.files=" + this._merge((Iterable<File>)fileCollection));
        }
        return args;
    }

    protected String getMain() {
        return "com.liferay.source.formatter.SourceFormatter";
    }

    private String _merge(Iterable<File> files) {
        StringBuilder sb = new StringBuilder();
        int i = 0;
        for (File file : files) {
            if (i > 0) {
                sb.append(',');
            }
            sb.append(this._normalize(file));
            ++i;
        }
        return sb.toString();
    }

    private String _normalize(File file) {
        Path path = file.toPath();
        String pathString = path.toString();
        if (File.separatorChar != '/') {
            pathString = pathString.replace(File.separatorChar, '/');
        }
        if (pathString.charAt(pathString.length() - 1) != '/') {
            pathString = pathString + '/';
        }
        return pathString;
    }
}

