/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.gradle.plugins.service.builder;

import com.liferay.gradle.plugins.service.builder.BuildServiceTask;
import com.liferay.gradle.util.GradleUtil;
import java.io.File;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.Callable;
import org.gradle.api.Action;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.SourceDirectorySet;
import org.gradle.api.internal.plugins.osgi.OsgiHelper;
import org.gradle.api.plugins.ExtensionAware;
import org.gradle.api.plugins.JavaPlugin;
import org.gradle.api.plugins.PluginContainer;
import org.gradle.api.plugins.WarPlugin;
import org.gradle.api.plugins.WarPluginConvention;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.TaskContainer;

public class ServiceBuilderPlugin
implements Plugin<Project> {
    public static final String BUILD_SERVICE_TASK_NAME = "buildService";
    public static final String CONFIGURATION_NAME = "serviceBuilder";
    private static final OsgiHelper _osgiHelper = new OsgiHelper();

    public void apply(Project project) {
        GradleUtil.applyPlugin((Project)project, JavaPlugin.class);
        Configuration serviceBuilderConfiguration = this.addConfigurationServiceBuilder(project);
        this.addTaskBuildService(project);
        this.configureTasksBuildService(project, serviceBuilderConfiguration);
    }

    protected Configuration addConfigurationServiceBuilder(final Project project) {
        Configuration configuration = GradleUtil.addConfiguration((Project)project, (String)CONFIGURATION_NAME);
        configuration.setDescription("Configures Liferay Service Builder for this project.");
        configuration.setVisible(false);
        GradleUtil.executeIfEmpty((Configuration)configuration, (Action)new Action<Configuration>(){

            public void execute(Configuration configuration) {
                ServiceBuilderPlugin.this.addDependenciesServiceBuilder(project);
            }
        });
        return configuration;
    }

    protected void addDependenciesServiceBuilder(Project project) {
        GradleUtil.addDependency((Project)project, (String)CONFIGURATION_NAME, (String)"com.liferay", (String)"com.liferay.portal.tools.service.builder", (String)"latest.release");
    }

    protected BuildServiceTask addTaskBuildService(final Project project) {
        final BuildServiceTask buildServiceTask = (BuildServiceTask)GradleUtil.addTask((Project)project, (String)BUILD_SERVICE_TASK_NAME, BuildServiceTask.class);
        buildServiceTask.setDescription("Runs Liferay Service Builder.");
        buildServiceTask.setGroup("build");
        buildServiceTask.setHbmFile(new Callable<File>(){

            @Override
            public File call() throws Exception {
                File resourcesDir = ServiceBuilderPlugin.this.getResourcesDir(project);
                String fileName = "META-INF/portlet-hbm.xml";
                if (buildServiceTask.isOsgiModule()) {
                    fileName = "META-INF/module-hbm.xml";
                }
                return new File(resourcesDir, fileName);
            }
        });
        buildServiceTask.setImplDir(new Callable<File>(){

            @Override
            public File call() throws Exception {
                return ServiceBuilderPlugin.this.getJavaDir(project);
            }
        });
        buildServiceTask.setInputFile("service.xml");
        buildServiceTask.setModelHintsFile(new Callable<File>(){

            @Override
            public File call() throws Exception {
                File resourcesDir = ServiceBuilderPlugin.this.getResourcesDir(project);
                return new File(resourcesDir, "META-INF/portlet-model-hints.xml");
            }
        });
        buildServiceTask.setPluginName(new Callable<String>(){

            @Override
            public String call() throws Exception {
                if (buildServiceTask.isOsgiModule()) {
                    return "";
                }
                return project.getName();
            }
        });
        buildServiceTask.setPropsUtil(new Callable<String>(){

            @Override
            public String call() throws Exception {
                if (buildServiceTask.isOsgiModule()) {
                    String bundleSymbolicName = _osgiHelper.getBundleSymbolicName(project);
                    return bundleSymbolicName + ".util.ServiceProps";
                }
                return "com.liferay.util.service.ServiceProps";
            }
        });
        buildServiceTask.setResourcesDir(new Callable<File>(){

            @Override
            public File call() throws Exception {
                return ServiceBuilderPlugin.this.getResourcesDir(project);
            }
        });
        boolean springConfiguratorEnabled = GradleUtil.getProperty((ExtensionAware)project, (String)"spring.configurator.enabled", (boolean)false);
        buildServiceTask.setSpringConfiguratorEnabled(springConfiguratorEnabled);
        buildServiceTask.setSpringFile(new Callable<File>(){

            @Override
            public File call() throws Exception {
                File resourcesDir = ServiceBuilderPlugin.this.getResourcesDir(project);
                String fileName = "META-INF/portlet-spring.xml";
                if (buildServiceTask.isOsgiModule()) {
                    fileName = "META-INF/spring/module-spring.xml";
                }
                return new File(resourcesDir, fileName);
            }
        });
        buildServiceTask.setSqlDir(new Callable<File>(){

            @Override
            public File call() throws Exception {
                File resourcesDir = ServiceBuilderPlugin.this.getResourcesDir(project);
                return new File(resourcesDir, "META-INF/sql");
            }
        });
        PluginContainer pluginContainer = project.getPlugins();
        pluginContainer.withType(WarPlugin.class, (Action)new Action<WarPlugin>(){

            public void execute(WarPlugin warPlugin) {
                ServiceBuilderPlugin.this.configureTaskBuildServiceForWarPlugin(buildServiceTask);
            }
        });
        return buildServiceTask;
    }

    protected void configureTaskBuildServiceClasspath(BuildServiceTask buildServiceTask, Configuration serviceBuilderConfiguration) {
        buildServiceTask.setClasspath((FileCollection)serviceBuilderConfiguration);
    }

    protected void configureTaskBuildServiceForWarPlugin(final BuildServiceTask buildServiceTask) {
        buildServiceTask.setApiDir(new Callable<File>(){

            @Override
            public File call() throws Exception {
                return new File(ServiceBuilderPlugin.this.getWebAppDir(buildServiceTask.getProject()), "WEB-INF/service");
            }
        });
        buildServiceTask.setInputFile(new Callable<File>(){

            @Override
            public File call() throws Exception {
                return new File(ServiceBuilderPlugin.this.getWebAppDir(buildServiceTask.getProject()), "WEB-INF/service.xml");
            }
        });
        buildServiceTask.setSqlDir(new Callable<File>(){

            @Override
            public File call() throws Exception {
                return new File(ServiceBuilderPlugin.this.getWebAppDir(buildServiceTask.getProject()), "WEB-INF/sql");
            }
        });
    }

    protected void configureTasksBuildService(Project project, final Configuration serviceBuilderConfiguration) {
        TaskContainer taskContainer = project.getTasks();
        taskContainer.withType(BuildServiceTask.class, (Action)new Action<BuildServiceTask>(){

            public void execute(BuildServiceTask buildServiceTask) {
                ServiceBuilderPlugin.this.configureTaskBuildServiceClasspath(buildServiceTask, serviceBuilderConfiguration);
            }
        });
    }

    protected File getJavaDir(Project project) {
        SourceSet sourceSet = GradleUtil.getSourceSet((Project)project, (String)"main");
        return this.getSrcDir(sourceSet.getJava());
    }

    protected File getResourcesDir(Project project) {
        SourceSet sourceSet = GradleUtil.getSourceSet((Project)project, (String)"main");
        return this.getSrcDir(sourceSet.getResources());
    }

    protected File getSrcDir(SourceDirectorySet sourceDirectorySet) {
        Set srcDirs = sourceDirectorySet.getSrcDirs();
        Iterator iterator = srcDirs.iterator();
        return (File)iterator.next();
    }

    protected File getWebAppDir(Project project) {
        WarPluginConvention warPluginConvention = (WarPluginConvention)GradleUtil.getConvention((Project)project, WarPluginConvention.class);
        return warPluginConvention.getWebAppDir();
    }
}

