/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.gradle.plugins.python;

import com.liferay.gradle.util.GradleUtil;
import com.pswidersk.gradle.python.VenvTask;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import org.gradle.api.Action;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.tasks.TaskProvider;

public class PythonPlugin
implements Plugin<Project> {
    public static final String CHECK_PYTHON_FORMATTING_TASK_NAME = "checkPythonFormatting";
    public static final String FORMAT_PYTHON_TASK_NAME = "formatPython";
    public static final String PYTHON_BLACK_INSTALL_TASK_NAME = "pythonBlackInstall";
    private static final String _PYTHON_FORCE_EXCLUDE = "\"/(\\.git|\\.gradle|bin|build|classes|node_modules|node_modules_cache|test-classes|tmp)/\"";
    private static final String _PYTHON_INCLUDE = "\"\\.pyi?$\"";

    public void apply(Project project) {
        GradleUtil.applyPlugin((Project)project, com.pswidersk.gradle.python.PythonPlugin.class);
        TaskProvider checkPythonFormattingTaskProvider = GradleUtil.addTaskProvider((Project)project, (String)CHECK_PYTHON_FORMATTING_TASK_NAME, VenvTask.class);
        TaskProvider formatPythonTaskProvider = GradleUtil.addTaskProvider((Project)project, (String)FORMAT_PYTHON_TASK_NAME, VenvTask.class);
        TaskProvider pythonBlackInstallTaskProvider = GradleUtil.addTaskProvider((Project)project, (String)PYTHON_BLACK_INSTALL_TASK_NAME, VenvTask.class);
        this._configureTaskCheckPythonFormattingProvider(project, (TaskProvider<VenvTask>)checkPythonFormattingTaskProvider, (TaskProvider<VenvTask>)pythonBlackInstallTaskProvider);
        this._configureTaskFormatPythonProvider(project, (TaskProvider<VenvTask>)formatPythonTaskProvider, (TaskProvider<VenvTask>)pythonBlackInstallTaskProvider);
        this._configureTaskPythonBlackInstallProvider((TaskProvider<VenvTask>)pythonBlackInstallTaskProvider);
    }

    private void _configureTaskCheckPythonFormattingProvider(final Project project, TaskProvider<VenvTask> checkPythonFormattingTaskProvider, final TaskProvider<VenvTask> pythonBlackInstallTaskProvider) {
        checkPythonFormattingTaskProvider.configure((Action)new Action<VenvTask>(){

            public void execute(VenvTask checkPythonFormattingVenvTask) {
                checkPythonFormattingVenvTask.dependsOn(new Object[]{pythonBlackInstallTaskProvider});
                ArrayList<String> args = new ArrayList<String>();
                args.add("--check");
                args.add("--fast");
                args.add("--force-exclude");
                args.add(PythonPlugin._PYTHON_FORCE_EXCLUDE);
                args.add("--include");
                args.add(PythonPlugin._PYTHON_INCLUDE);
                String baseDir = GradleUtil.getTaskPrefixedProperty((String)project.getPath(), (String)checkPythonFormattingVenvTask.getName(), (String)"base.dir");
                if (baseDir == null) {
                    File projectDir = project.getProjectDir();
                    baseDir = projectDir.getPath();
                }
                args.add(baseDir);
                checkPythonFormattingVenvTask.setArgs(args);
                checkPythonFormattingVenvTask.setVenvExec("black");
            }
        });
    }

    private void _configureTaskFormatPythonProvider(final Project project, TaskProvider<VenvTask> formatPythonTaskProvider, final TaskProvider<VenvTask> pythonBlackInstallTaskProvider) {
        formatPythonTaskProvider.configure((Action)new Action<VenvTask>(){

            public void execute(VenvTask formatPythonVenvTask) {
                formatPythonVenvTask.dependsOn(new Object[]{pythonBlackInstallTaskProvider});
                ArrayList<String> args = new ArrayList<String>();
                args.add("--fast");
                args.add("--force-exclude");
                args.add(PythonPlugin._PYTHON_FORCE_EXCLUDE);
                args.add("--include");
                args.add(PythonPlugin._PYTHON_INCLUDE);
                String baseDir = GradleUtil.getTaskPrefixedProperty((String)project.getPath(), (String)formatPythonVenvTask.getName(), (String)"base.dir");
                if (baseDir == null) {
                    File projectDir = project.getProjectDir();
                    baseDir = projectDir.getPath();
                }
                args.add(baseDir);
                formatPythonVenvTask.setArgs(args);
                formatPythonVenvTask.setVenvExec("black");
            }
        });
    }

    private void _configureTaskPythonBlackInstallProvider(TaskProvider<VenvTask> pythonBlackInstallTaskProvider) {
        pythonBlackInstallTaskProvider.configure((Action)new Action<VenvTask>(){

            public void execute(VenvTask pythonBlackInstallVenvTask) {
                pythonBlackInstallVenvTask.setArgs(Arrays.asList("install", "black"));
                pythonBlackInstallVenvTask.setVenvExec("pip");
            }
        });
    }
}

