/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.gradle.plugins.node.task;

import com.liferay.gradle.plugins.node.internal.util.GradleUtil;
import com.liferay.gradle.plugins.node.task.PackageRunTask;
import java.io.File;
import org.gradle.api.Project;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.InputDirectory;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;

@CacheableTask
public class PackageRunBuildTask
extends PackageRunTask {
    private Object _destinationDir;
    private Object _sourceDir;
    private Object _yarnWorkingDir;

    public PackageRunBuildTask() {
        this.setScriptName("build");
    }

    public File getDestinationDir() {
        return GradleUtil.toFile(this.getProject(), this._destinationDir);
    }

    @InputFile
    @Optional
    @PathSensitive(value=PathSensitivity.RELATIVE)
    public File getNpmBridgeRCFile() {
        return this._getExistentFile(".npmbridgerc");
    }

    @InputFile
    @Optional
    @PathSensitive(value=PathSensitivity.RELATIVE)
    public File getNpmBundlerRCFile() {
        return this._getExistentFile(".npmbundlerrc");
    }

    @InputFile
    @Optional
    @PathSensitive(value=PathSensitivity.RELATIVE)
    public File getNpmScriptsConfigJSFile() {
        return this._getExistentFile("npmscripts.config.js");
    }

    @InputFile
    @PathSensitive(value=PathSensitivity.RELATIVE)
    public File getPackageJsonFile() {
        Project project = this.getProject();
        return project.file((Object)"package.json");
    }

    @InputFile
    @Optional
    @PathSensitive(value=PathSensitivity.RELATIVE)
    public File getPackageLockJsonFile() {
        return this._getExistentFile("package-lock.json");
    }

    @InputDirectory
    @Optional
    @PathSensitive(value=PathSensitivity.RELATIVE)
    public File getSourceDir() {
        return GradleUtil.toFile(this.getProject(), this._sourceDir);
    }

    @InputFile
    @Optional
    @PathSensitive(value=PathSensitivity.RELATIVE)
    public File getWebpackConfigJSFile() {
        return this._getExistentFile("webpack.config.js");
    }

    @InputFile
    @Optional
    @PathSensitive(value=PathSensitivity.RELATIVE)
    public File getYarnLockFile() {
        return this._getExistentYarnFile("yarn.lock");
    }

    @InputFile
    @Optional
    @PathSensitive(value=PathSensitivity.RELATIVE)
    public File getYarnNpmScriptsConfigJSFile() {
        return this._getExistentYarnFile("npmscripts.config.js");
    }

    @InputFile
    @Optional
    @PathSensitive(value=PathSensitivity.RELATIVE)
    public File getYarnPackageJsonFile() {
        return this._getExistentYarnFile("package.json");
    }

    @InputDirectory
    @Optional
    @PathSensitive(value=PathSensitivity.RELATIVE)
    public File getYarnProjectNodeModulesDir() {
        if (this.isUseNpm()) {
            return null;
        }
        return this._getExistentFile("node_modules");
    }

    public File getYarnWorkingDir() {
        return GradleUtil.toFile(this.getProject(), this._yarnWorkingDir);
    }

    public void setDestinationDir(Object destinationDir) {
        this._destinationDir = destinationDir;
    }

    public void setSourceDir(Object sourceDir) {
        this._sourceDir = sourceDir;
    }

    public void setYarnWorkingDir(Object yarnWorkingDir) {
        this._yarnWorkingDir = yarnWorkingDir;
    }

    private File _getExistentFile(String fileName) {
        Project project = this.getProject();
        File file = project.file((Object)fileName);
        if (!file.exists()) {
            file = null;
        }
        return file;
    }

    private File _getExistentYarnFile(String fileName) {
        File yarnWorkingDir = this.getYarnWorkingDir();
        if (yarnWorkingDir == null) {
            return null;
        }
        File file = new File(yarnWorkingDir, fileName);
        if (!file.exists()) {
            file = null;
        }
        return file;
    }
}

