/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.gradle.plugins.node.tasks;

import com.liferay.gradle.plugins.node.internal.util.FileUtil;
import com.liferay.gradle.plugins.node.internal.util.GradleUtil;
import com.liferay.gradle.plugins.node.tasks.ExecutePackageManagerTask;
import com.liferay.gradle.util.OSDetector;
import com.liferay.gradle.util.Validator;
import groovy.json.JsonSlurper;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.logging.Logger;
import org.gradle.api.plugins.PluginContainer;
import org.gradle.api.specs.Spec;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;

@CacheableTask
public class NpmInstallTask
extends ExecutePackageManagerTask {
    private Object _nodeModulesCacheDir;
    private boolean _nodeModulesCacheNativeSync = true;
    private Object _nodeModulesDigestFile;
    private Object _nodeVersion;
    private boolean _npmCacheVerify;
    private Object _npmVersion;
    private Object _removeShrinkwrappedUrls = new Callable<Boolean>(){

        @Override
        public Boolean call() throws Exception {
            if (Validator.isNotNull((String)NpmInstallTask.this.getRegistry())) {
                return true;
            }
            return false;
        }
    };
    private Object _useNpmCI;

    public NpmInstallTask() {
        this.onlyIf((Spec)new Spec<Task>(){

            public boolean isSatisfiedBy(Task task) {
                NpmInstallTask npmInstallTask = (NpmInstallTask)task;
                File packageJsonFile = npmInstallTask.getPackageJsonFile();
                if (!packageJsonFile.exists()) {
                    return false;
                }
                if (!NpmInstallTask.this.isUseNpm()) {
                    return false;
                }
                JsonSlurper jsonSlurper = new JsonSlurper();
                Map packageJsonMap = (Map)jsonSlurper.parse(packageJsonFile);
                return packageJsonMap.containsKey("dependencies") || packageJsonMap.containsKey("devDependencies");
            }
        });
    }

    @Override
    public void executeNode() throws Exception {
        this.executeNpmInstall(false);
    }

    public File getNodeModulesCacheDir() {
        return GradleUtil.toFile(this.getProject(), this._nodeModulesCacheDir);
    }

    public File getNodeModulesDigestFile() {
        return GradleUtil.toFile(this.getProject(), this._nodeModulesDigestFile);
    }

    @Override
    @OutputDirectory
    public File getNodeModulesDir() {
        return super.getNodeModulesDir();
    }

    @Input
    @Optional
    public String getNodeVersion() {
        return GradleUtil.toString((Object)this._nodeVersion);
    }

    @Input
    @Optional
    public String getNpmVersion() {
        return GradleUtil.toString((Object)this._npmVersion);
    }

    @InputFile
    @PathSensitive(value=PathSensitivity.RELATIVE)
    public File getPackageJsonFile() {
        Project project = this.getProject();
        return project.file((Object)"package.json");
    }

    @InputFile
    @Optional
    @PathSensitive(value=PathSensitivity.RELATIVE)
    public File getPackageLockJsonFile() {
        return this._getExistentFile("package-lock.json");
    }

    @InputFile
    @Optional
    @PathSensitive(value=PathSensitivity.RELATIVE)
    public File getShrinkwrapJsonFile() {
        return this._getExistentFile("npm-shrinkwrap.json");
    }

    public boolean isCheckDigest() {
        if (this._isCacheEnabled()) {
            return false;
        }
        Project project = this.getProject();
        PluginContainer pluginContainer = project.getPlugins();
        return !pluginContainer.hasPlugin("com.liferay.cache") && this.getNodeModulesDigestFile() != null;
    }

    public boolean isNodeModulesCacheNativeSync() {
        return this._nodeModulesCacheNativeSync;
    }

    public boolean isRemoveShrinkwrappedUrls() {
        return GradleUtil.toBoolean(this._removeShrinkwrappedUrls);
    }

    public boolean isUseNpmCI() {
        return GradleUtil.toBoolean(this._useNpmCI);
    }

    public void setNodeModulesCacheDir(Object nodeModulesCacheDir) {
        this._nodeModulesCacheDir = nodeModulesCacheDir;
    }

    public void setNodeModulesCacheNativeSync(boolean nodeModulesCacheNativeSync) {
        this._nodeModulesCacheNativeSync = nodeModulesCacheNativeSync;
    }

    public void setNodeModulesDigestFile(Object nodeModulesDigestFile) {
        this._nodeModulesDigestFile = nodeModulesDigestFile;
    }

    public void setNodeVersion(Object nodeVersion) {
        this._nodeVersion = nodeVersion;
    }

    public void setNpmVersion(Object npmVersion) {
        this._npmVersion = npmVersion;
    }

    public void setRemoveShrinkwrappedUrls(Object removeShrinkwrappedUrls) {
        this._removeShrinkwrappedUrls = removeShrinkwrappedUrls;
    }

    public void setUseNpmCI(Object useNpmCI) {
        this._useNpmCI = useNpmCI;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void executeNpmInstall(boolean reset) throws Exception {
        Logger logger = this.getLogger();
        Path shrinkwrapJsonBackupPath = null;
        Path shrinkwrapJsonPath = null;
        File shrinkwrapJsonFile = this.getShrinkwrapJsonFile();
        if (this.isRemoveShrinkwrappedUrls() && shrinkwrapJsonFile != null) {
            shrinkwrapJsonPath = shrinkwrapJsonFile.toPath();
            shrinkwrapJsonBackupPath = Paths.get(shrinkwrapJsonPath.toString() + ".backup", new String[0]);
            Files.copy(shrinkwrapJsonPath, shrinkwrapJsonBackupPath, StandardCopyOption.REPLACE_EXISTING);
            this._removeShrinkwrappedUrls();
        }
        try {
            if (this._isCacheEnabled()) {
                if (logger.isInfoEnabled()) {
                    logger.info("Cache for {} is enabled", (Object)this);
                }
                NpmInstallTask._npmInstallCached(this, reset);
            } else {
                if (logger.isInfoEnabled()) {
                    logger.info("Cache for {} is disabled", (Object)this);
                }
                if (this.isCheckDigest()) {
                    this._npmInstallCheckDigest(reset);
                } else {
                    this._npmInstall(reset);
                }
            }
            if (shrinkwrapJsonBackupPath == null) return;
        }
        catch (Throwable throwable) {
            if (shrinkwrapJsonBackupPath == null) throw throwable;
            Files.move(shrinkwrapJsonBackupPath, shrinkwrapJsonPath, StandardCopyOption.REPLACE_EXISTING);
            throw throwable;
        }
        Files.move(shrinkwrapJsonBackupPath, shrinkwrapJsonPath, StandardCopyOption.REPLACE_EXISTING);
    }

    @Override
    protected List<String> getCompleteArgs() {
        List<String> completeArgs = super.getCompleteArgs();
        if (this._npmCacheVerify) {
            completeArgs.add("cache");
            completeArgs.add("verify");
        } else if (this.isUseNpmCI() && this.getPackageLockJsonFile() != null) {
            completeArgs.add("ci");
        } else {
            completeArgs.add("install");
        }
        return completeArgs;
    }

    private static String _getNodeModulesCacheDigest(NpmInstallTask npmInstallTask) {
        Logger logger = npmInstallTask.getLogger();
        JsonSlurper jsonSlurper = new JsonSlurper();
        File jsonFile = npmInstallTask.getPackageLockJsonFile();
        if (jsonFile == null) {
            if (logger.isInfoEnabled()) {
                logger.info("Unable to find package-lock.json for {}, using npm-shrinkwrap.json instead", (Object)npmInstallTask.getProject());
            }
            jsonFile = npmInstallTask.getShrinkwrapJsonFile();
        }
        if (jsonFile == null) {
            if (logger.isWarnEnabled()) {
                logger.warn("Unable to find npm-shrinkwrap.json for {}, using package.json instead", (Object)npmInstallTask.getProject());
            }
            jsonFile = npmInstallTask.getPackageJsonFile();
        }
        Map map = (Map)jsonSlurper.parse(jsonFile);
        map.remove("name");
        map.remove("version");
        return String.valueOf(map.hashCode());
    }

    private static synchronized void _npmInstallCached(NpmInstallTask npmInstallTask, boolean reset) throws Exception {
        Logger logger = npmInstallTask.getLogger();
        Project project = npmInstallTask.getProject();
        String digest = NpmInstallTask._getNodeModulesCacheDigest(npmInstallTask);
        File nodeModulesCacheDir = new File(npmInstallTask.getNodeModulesCacheDir(), digest);
        File nodeModulesDir = npmInstallTask.getNodeModulesDir();
        boolean nativeSync = npmInstallTask.isNodeModulesCacheNativeSync();
        if (reset) {
            project.delete(new Object[]{nodeModulesCacheDir});
        }
        if (nodeModulesCacheDir.exists()) {
            if (logger.isLifecycleEnabled()) {
                logger.lifecycle("Restoring node_modules of {} from {}", new Object[]{project, nodeModulesCacheDir});
            }
            FileUtil.syncDir(project, nodeModulesCacheDir, nodeModulesDir, nativeSync);
            if (logger.isLifecycleEnabled()) {
                logger.lifecycle("Removing binary symbolic links of {} from {}", new Object[]{project, nodeModulesDir});
            }
            FileUtil.removeBinDirLinks(logger, nodeModulesDir);
        } else {
            npmInstallTask._npmInstall(reset);
            if (logger.isLifecycleEnabled()) {
                logger.lifecycle("Removing binary symbolic links of {} from {}", new Object[]{project, nodeModulesDir});
            }
            FileUtil.removeBinDirLinks(logger, nodeModulesDir);
            if (logger.isLifecycleEnabled()) {
                logger.lifecycle("Caching node_modules of {} in {}", new Object[]{project, nodeModulesCacheDir});
            }
            FileUtil.syncDir(project, nodeModulesDir, nodeModulesCacheDir, nativeSync);
        }
        if (!OSDetector.isWindows()) {
            if (logger.isLifecycleEnabled()) {
                logger.lifecycle("Restoring binary symbolic links of {} from {}", new Object[]{project, nodeModulesDir});
            }
            FileUtil.createBinDirLinks(logger, nodeModulesDir);
        }
    }

    private File _getExistentFile(String fileName) {
        Project project = this.getProject();
        File file = project.file((Object)fileName);
        if (!file.exists()) {
            file = null;
        }
        return file;
    }

    private boolean _isCacheEnabled() {
        Project project = this.getProject();
        PluginContainer pluginContainer = project.getPlugins();
        return !pluginContainer.hasPlugin("com.liferay.cache") && this.getNodeModulesCacheDir() != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _npmCacheVerify() {
        Logger logger = this.getLogger();
        try {
            this._npmCacheVerify = true;
            super.executeNode();
        }
        catch (Exception exception) {
            if (logger.isWarnEnabled()) {
                String message = "Unable to run \"npm cache verify\"";
                if (Validator.isNotNull((String)exception.getMessage())) {
                    message = exception.getMessage() + ". " + message;
                }
                logger.warn(message);
            }
        }
        finally {
            this._npmCacheVerify = false;
        }
    }

    private void _npmInstall(boolean reset) throws Exception {
        Logger logger = this.getLogger();
        int npmInstallRetries = this.getNpmInstallRetries();
        Project project = this.getProject();
        for (int i = 0; i < npmInstallRetries + 1; ++i) {
            if (reset || i > 0) {
                project.delete(new Object[]{this.getNodeModulesDir()});
            }
            try {
                super.executeNode();
                break;
            }
            catch (IOException ioException) {
                if (i == npmInstallRetries) {
                    throw ioException;
                }
                if (logger.isWarnEnabled()) {
                    logger.warn(ioException.getMessage() + ". Running \"npm install\" again");
                }
                this._npmCacheVerify();
                continue;
            }
        }
    }

    private void _npmInstallCheckDigest(boolean reset) throws Exception {
        String digest = NpmInstallTask._getNodeModulesCacheDigest(this);
        byte[] digestBytes = digest.getBytes(StandardCharsets.UTF_8);
        File nodeModulesDigestFile = this.getNodeModulesDigestFile();
        Path nodeModulesDigestPath = nodeModulesDigestFile.toPath();
        if (!reset && Files.exists(nodeModulesDigestPath, new LinkOption[0])) {
            byte[] bytes = Files.readAllBytes(nodeModulesDigestPath);
            if (Arrays.equals(bytes, digestBytes)) {
                return;
            }
            reset = true;
        } else {
            reset = true;
        }
        this._npmInstall(reset);
        Files.write(nodeModulesDigestPath, digestBytes, new OpenOption[0]);
    }

    private void _removeShrinkwrappedUrls() throws IOException {
        File shrinkwrapJsonFile = this.getShrinkwrapJsonFile();
        Path shrinkwrapJsonPath = shrinkwrapJsonFile.toPath();
        String json = new String(Files.readAllBytes(shrinkwrapJsonPath), StandardCharsets.UTF_8);
        json = json.replaceAll("\\s+\"(?:from|resolved)\": \"http.+\",*\\r*\\n", "");
        Files.write(shrinkwrapJsonPath, json.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
    }
}

