/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.gradle.plugins.node.tasks;

import com.liferay.gradle.plugins.node.internal.util.FileUtil;
import com.liferay.gradle.plugins.node.internal.util.GradleUtil;
import com.liferay.gradle.plugins.node.tasks.ExecutePackageManagerTask;
import com.liferay.gradle.util.GUtil;
import com.liferay.gradle.util.Validator;
import groovy.json.JsonOutput;
import groovy.json.JsonSlurper;
import groovy.lang.Writable;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.codehaus.groovy.runtime.EncodingGroovyMethods;
import org.gradle.api.Project;
import org.gradle.api.logging.Logger;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputDirectory;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;

@CacheableTask
public class PublishNodeModuleTask
extends ExecutePackageManagerTask {
    private Object _moduleAuthor;
    private Object _moduleBugsUrl;
    private Object _moduleDescription;
    private final List<Object> _moduleKeywords = new ArrayList<Object>();
    private Object _moduleLicense;
    private Object _moduleMain;
    private Object _moduleName;
    private Object _moduleRepository;
    private Object _moduleVersion;
    private Object _npmEmailAddress;
    private Object _npmPassword;
    private Object _npmUserName;
    private final Set<String> _overriddenPackageJsonKeys = new HashSet<String>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void executeNode() throws Exception {
        Project project = this.getProject();
        File npmrcFile = this._getNpmrcFile();
        File packageJsonFile = new File(this.getWorkingDir(), "package.json");
        Path packageJsonPath = packageJsonFile.toPath();
        Path packageJsonBackupPath = null;
        if (Files.exists(packageJsonPath, new LinkOption[0])) {
            File packageJsonBackupFile = new File(this.getTemporaryDir(), "package.json.backup");
            packageJsonBackupPath = packageJsonBackupFile.toPath();
            Files.copy(packageJsonPath, packageJsonBackupPath, StandardCopyOption.REPLACE_EXISTING);
        } else {
            File rootPackageJsonFile = project.file((Object)"package.json");
            if (rootPackageJsonFile.exists()) {
                Files.copy(rootPackageJsonFile.toPath(), packageJsonPath, new CopyOption[0]);
            }
        }
        try {
            this._createNpmrcFile(npmrcFile);
            this._updatePackageJsonFile(packageJsonPath);
            super.executeNode();
        }
        catch (Throwable throwable) {
            project.delete(new Object[]{npmrcFile});
            if (packageJsonBackupPath != null) {
                Files.move(packageJsonBackupPath, packageJsonPath, StandardCopyOption.REPLACE_EXISTING);
            } else {
                Files.delete(packageJsonPath);
            }
            throw throwable;
        }
        project.delete(new Object[]{npmrcFile});
        if (packageJsonBackupPath != null) {
            Files.move(packageJsonBackupPath, packageJsonPath, StandardCopyOption.REPLACE_EXISTING);
        } else {
            Files.delete(packageJsonPath);
        }
    }

    @Input
    @Optional
    public String getModuleAuthor() {
        return GradleUtil.toString((Object)this._moduleAuthor);
    }

    public String getModuleBugsUrl() {
        return GradleUtil.toString((Object)this._moduleBugsUrl);
    }

    @Input
    @Optional
    public String getModuleDescription() {
        return GradleUtil.toString((Object)this._moduleDescription);
    }

    @Input
    public List<String> getModuleKeywords() {
        return GradleUtil.toStringList(this._moduleKeywords);
    }

    @Input
    @Optional
    public String getModuleLicense() {
        return GradleUtil.toString((Object)this._moduleLicense);
    }

    @Input
    @Optional
    public String getModuleMain() {
        return GradleUtil.toString((Object)this._moduleMain);
    }

    @Input
    public String getModuleName() {
        return GradleUtil.toString((Object)this._moduleName);
    }

    @Input
    @Optional
    public String getModuleRepository() {
        return GradleUtil.toString((Object)this._moduleRepository);
    }

    @Input
    public String getModuleVersion() {
        return GradleUtil.toString((Object)this._moduleVersion);
    }

    @Input
    public String getNpmEmailAddress() {
        return GradleUtil.toString((Object)this._npmEmailAddress);
    }

    @Input
    public String getNpmPassword() {
        return GradleUtil.toString((Object)this._npmPassword);
    }

    @Input
    public String getNpmUserName() {
        return GradleUtil.toString((Object)this._npmUserName);
    }

    @Input
    public Set<String> getOverriddenPackageJsonKeys() {
        return this._overriddenPackageJsonKeys;
    }

    @Override
    @InputDirectory
    @PathSensitive(value=PathSensitivity.RELATIVE)
    public File getWorkingDir() {
        return super.getWorkingDir();
    }

    public PublishNodeModuleTask overriddenPackageJsonKeys(Iterable<String> overriddenPackageJsonKeys) {
        GUtil.addToCollection(this._overriddenPackageJsonKeys, overriddenPackageJsonKeys);
        return this;
    }

    public PublishNodeModuleTask overriddenPackageJsonKeys(String ... overriddenPackageJsonKeys) {
        return this.overriddenPackageJsonKeys(Arrays.asList(overriddenPackageJsonKeys));
    }

    public void setModuleAuthor(Object moduleAuthor) {
        this._moduleAuthor = moduleAuthor;
    }

    public void setModuleBugsUrl(Object moduleBugsUrl) {
        this._moduleBugsUrl = moduleBugsUrl;
    }

    public void setModuleDescription(Object moduleDescription) {
        this._moduleDescription = moduleDescription;
    }

    public void setModuleKeywords(Iterable<?> moduleKeywords) {
        this._moduleKeywords.clear();
    }

    public void setModuleKeywords(Object ... moduleKeywords) {
        this.setModuleKeywords(Arrays.asList(moduleKeywords));
    }

    public void setModuleLicense(Object moduleLicense) {
        this._moduleLicense = moduleLicense;
    }

    public void setModuleMain(Object moduleMain) {
        this._moduleMain = moduleMain;
    }

    public void setModuleName(Object moduleName) {
        this._moduleName = moduleName;
    }

    public void setModuleRepository(Object moduleRepository) {
        this._moduleRepository = moduleRepository;
    }

    public void setModuleVersion(Object moduleVersion) {
        this._moduleVersion = moduleVersion;
    }

    public void setNpmEmailAddress(Object npmEmailAddress) {
        this._npmEmailAddress = npmEmailAddress;
    }

    public void setNpmPassword(Object npmPassword) {
        this._npmPassword = npmPassword;
    }

    public void setNpmUserName(Object npmUserName) {
        this._npmUserName = npmUserName;
    }

    public void setOverriddenPackageJsonKeys(Iterable<String> overriddenPackageJsonKeys) {
        this._overriddenPackageJsonKeys.clear();
        this.overriddenPackageJsonKeys(overriddenPackageJsonKeys);
    }

    public void setOverriddenPackageJsonKeys(String ... overriddenPackageJsonKeys) {
        this.setOverriddenPackageJsonKeys(Arrays.asList(overriddenPackageJsonKeys));
    }

    @Override
    protected List<String> getCompleteArgs() {
        List<String> completeArgs = super.getCompleteArgs();
        completeArgs.add("publish");
        completeArgs.add("--userconfig");
        completeArgs.add(FileUtil.getAbsolutePath((File)this._getNpmrcFile()));
        return completeArgs;
    }

    private void _createNpmrcFile(File npmrcFile) throws IOException {
        ArrayList<String> npmrcContents = new ArrayList<String>(2);
        npmrcContents.add("_auth = " + this._getNpmAuth());
        npmrcContents.add("email = " + this.getNpmEmailAddress());
        npmrcContents.add("username = " + this.getNpmUserName());
        FileUtil.write((File)npmrcFile, npmrcContents);
    }

    private String _getNpmAuth() {
        String auth = this.getNpmUserName() + ":" + this.getNpmPassword();
        Writable writable = EncodingGroovyMethods.encodeBase64((byte[])auth.getBytes());
        return writable.toString();
    }

    private File _getNpmrcFile() {
        if (this.isUseNpm()) {
            return new File(this.getTemporaryDir(), "npmrc");
        }
        Project curProject = this.getProject();
        do {
            File file;
            if (!(file = curProject.file((Object)"yarn.lock")).exists()) continue;
            return curProject.file((Object)".npmrc");
        } while ((curProject = curProject.getParent()) != null);
        Project project = this.getProject();
        return project.file((Object)".npmrc");
    }

    private void _updatePackageJsonFile(Path packageJsonPath) throws IOException {
        Logger logger = this.getLogger();
        Map<String, Object> map = null;
        if (Files.exists(packageJsonPath, new LinkOption[0])) {
            JsonSlurper jsonSlurper = new JsonSlurper();
            map = (Map)jsonSlurper.parse(packageJsonPath.toFile());
        } else {
            map = new HashMap<String, Object>();
        }
        this._updatePackageJsonValue(map, "author", this.getModuleAuthor());
        this._updatePackageJsonValue(map, "bugs", this.getModuleBugsUrl());
        this._updatePackageJsonValue(map, "description", this.getModuleDescription());
        this._updatePackageJsonValue(map, "keywords", this.getModuleKeywords());
        this._updatePackageJsonValue(map, "license", this.getModuleLicense());
        this._updatePackageJsonValue(map, "main", this.getModuleMain());
        this._updatePackageJsonValue(map, "name", this.getModuleName());
        this._updatePackageJsonValue(map, "repository", this.getModuleRepository());
        this._updatePackageJsonValue(map, "version", this.getModuleVersion());
        String json = JsonOutput.toJson(map);
        if (logger.isInfoEnabled()) {
            logger.info(json);
        }
        Files.write(packageJsonPath, json.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
    }

    private void _updatePackageJsonValue(Map<String, Object> map, String key, Object value) {
        if (value == null || value instanceof String && Validator.isNull((String)((String)value))) {
            return;
        }
        Set<String> overriddenPackageJsonKeys = this.getOverriddenPackageJsonKeys();
        if (!map.containsKey(key) || overriddenPackageJsonKeys.contains(key)) {
            map.put(key, value);
        }
    }
}

