/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.gradle.plugins.node.internal.util;

import com.liferay.gradle.util.Validator;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Comparator;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import org.gradle.api.GradleException;
import org.gradle.api.UncheckedIOException;
import org.gradle.internal.hash.HashUtil;
import org.gradle.internal.hash.HashValue;

public class DigestUtil {
    public static String getDigest(File digestFile) {
        if (!digestFile.exists()) {
            return null;
        }
        byte[] bytes = null;
        try {
            bytes = Files.readAllBytes(digestFile.toPath());
        }
        catch (IOException ioException) {
            throw new UncheckedIOException((Throwable)ioException);
        }
        return new String(bytes, StandardCharsets.UTF_8);
    }

    public static String getDigest(Iterable<File> files) {
        StringBuilder sb = new StringBuilder();
        SortedSet<File> sortedFiles = null;
        try {
            sortedFiles = DigestUtil._flattenAndSort(files);
        }
        catch (IOException ioException) {
            throw new GradleException("Unable to flatten files", (Throwable)ioException);
        }
        for (File file : sortedFiles) {
            if (!file.exists()) continue;
            try {
                List<String> lines = Files.readAllLines(file.toPath(), StandardCharsets.UTF_8);
                sb.append(Integer.toHexString(lines.hashCode()));
            }
            catch (IOException ioException) {
                HashValue hashValue = HashUtil.sha1((File)file);
                sb.append(hashValue.asHexString());
            }
            sb.append('-');
        }
        if (sb.length() > 0) {
            sb.setLength(sb.length() - 1);
        }
        return sb.toString();
    }

    public static String getDigest(String ... array) {
        StringBuilder sb = new StringBuilder();
        for (String s : array) {
            if (!Validator.isNotNull((String)s)) continue;
            sb.append(Integer.toHexString(s.hashCode()));
            sb.append('-');
        }
        if (sb.length() > 0) {
            sb.setLength(sb.length() - 1);
        }
        return sb.toString();
    }

    private static SortedSet<File> _flattenAndSort(Iterable<File> files) throws IOException {
        final TreeSet<File> sortedFiles = new TreeSet<File>(new FileComparator());
        if (files == null) {
            return sortedFiles;
        }
        for (File file : files) {
            if (file.isDirectory()) {
                Files.walkFileTree(file.toPath(), (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                    @Override
                    public FileVisitResult visitFile(Path path, BasicFileAttributes basicFileAttributes) throws IOException {
                        sortedFiles.add(path.toFile());
                        return FileVisitResult.CONTINUE;
                    }
                });
                continue;
            }
            sortedFiles.add(file);
        }
        return sortedFiles;
    }

    private static class FileComparator
    implements Comparator<File> {
        private FileComparator() {
        }

        @Override
        public int compare(File file1, File file2) {
            String canonicalPath1 = this._getCanonicalPath(file1);
            String canonicalPath2 = this._getCanonicalPath(file2);
            return canonicalPath1.compareTo(canonicalPath2);
        }

        private String _getCanonicalPath(File file) {
            String canonicalPath = null;
            try {
                canonicalPath = file.getCanonicalPath();
            }
            catch (IOException ioException) {
                String message = "Unable to get canonical path of " + file;
                throw new UncheckedIOException(message, (Throwable)ioException);
            }
            if (File.separatorChar != '/') {
                canonicalPath = canonicalPath.replace(File.separatorChar, '/');
            }
            return canonicalPath;
        }
    }
}

