/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.gradle.plugins.node.tasks;

import com.liferay.gradle.plugins.node.internal.util.FileUtil;
import com.liferay.gradle.plugins.node.internal.util.GradleUtil;
import com.liferay.gradle.plugins.node.tasks.ExecuteNodeScriptTask;
import com.liferay.gradle.util.Validator;
import java.io.File;
import java.util.List;
import java.util.concurrent.Callable;
import org.gradle.api.Project;
import org.gradle.api.logging.Logger;
import org.gradle.api.tasks.CacheableTask;

@CacheableTask
public class ExecutePackageManagerTask
extends ExecuteNodeScriptTask {
    private Object _cacheConcurrent;
    private Object _cacheDir;
    private Object _logLevel;
    private Object _nodeModulesDir;
    private boolean _production;
    private boolean _progress = true;
    private Object _registry;
    private Object _useNpm;

    public ExecutePackageManagerTask() {
        this.setCommand(new Callable<String>(){

            @Override
            public String call() throws Exception {
                if (ExecutePackageManagerTask.this.getNodeDir() == null) {
                    return "npm";
                }
                return "node";
            }
        });
        this.setLogLevel(new Callable<String>(){

            @Override
            public String call() throws Exception {
                String logLevel = null;
                Logger logger = ExecutePackageManagerTask.this.getLogger();
                if (logger.isTraceEnabled()) {
                    logLevel = "silly";
                } else if (logger.isDebugEnabled()) {
                    logLevel = "verbose";
                } else if (logger.isInfoEnabled()) {
                    logLevel = "info";
                } else if (logger.isWarnEnabled()) {
                    logLevel = "warn";
                } else if (logger.isErrorEnabled()) {
                    logLevel = "error";
                }
                return logLevel;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void executeNode() throws Exception {
        Project project = this.getProject();
        File cacheDir = this.getCacheDir();
        if (this.isCacheConcurrent() || cacheDir != null && FileUtil.isChild((File)cacheDir, (File)project.getProjectDir())) {
            super.executeNode();
            return;
        }
        Class<ExecutePackageManagerTask> clazz = ExecutePackageManagerTask.class;
        synchronized (ExecutePackageManagerTask.class) {
            super.executeNode();
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    public File getCacheDir() {
        return GradleUtil.toFile(this.getProject(), this._cacheDir);
    }

    public String getLogLevel() {
        return GradleUtil.toString((Object)this._logLevel);
    }

    public File getNodeModulesDir() {
        return GradleUtil.toFile(this.getProject(), this._nodeModulesDir);
    }

    public String getRegistry() {
        return GradleUtil.toString((Object)this._registry);
    }

    public boolean isCacheConcurrent() {
        return GradleUtil.toBoolean(this._cacheConcurrent);
    }

    public boolean isProduction() {
        return this._production;
    }

    public boolean isProgress() {
        return this._progress;
    }

    public boolean isUseNpm() {
        return GradleUtil.toBoolean(this._useNpm);
    }

    public void setCacheConcurrent(Object cacheConcurrent) {
        this._cacheConcurrent = cacheConcurrent;
    }

    public void setCacheDir(Object cacheDir) {
        this._cacheDir = cacheDir;
    }

    public void setLogLevel(Object logLevel) {
        this._logLevel = logLevel;
    }

    public void setNodeModulesDir(Object nodeModulesDir) {
        this._nodeModulesDir = nodeModulesDir;
    }

    public void setProduction(boolean production) {
        this._production = production;
    }

    public void setProgress(boolean progress) {
        this._progress = progress;
    }

    public void setRegistry(Object registry) {
        this._registry = registry;
    }

    public void setUseNpm(Object useNpm) {
        this._useNpm = useNpm;
    }

    @Override
    protected List<String> getCompleteArgs() {
        String logLevel;
        List<String> completeArgs = super.getCompleteArgs();
        completeArgs.add("--production");
        completeArgs.add(Boolean.toString(this.isProduction()));
        String registry = this.getRegistry();
        if (Validator.isNotNull((String)registry)) {
            completeArgs.add("--registry");
            completeArgs.add(registry);
        }
        if (!this.isUseNpm()) {
            return completeArgs;
        }
        File cacheDir = this.getCacheDir();
        if (cacheDir != null) {
            completeArgs.add("--cache");
            completeArgs.add(FileUtil.getAbsolutePath((File)cacheDir));
        }
        if (Validator.isNotNull((String)(logLevel = this.getLogLevel()))) {
            completeArgs.add("--loglevel");
            completeArgs.add(logLevel);
        }
        completeArgs.add("--progress");
        completeArgs.add(Boolean.toString(this.isProgress()));
        return completeArgs;
    }
}

