/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.gradle.plugins.node;

import com.liferay.gradle.plugins.node.NodeExtension;
import com.liferay.gradle.plugins.node.internal.util.FileUtil;
import com.liferay.gradle.plugins.node.internal.util.GradleUtil;
import com.liferay.gradle.plugins.node.internal.util.NodePluginUtil;
import com.liferay.gradle.plugins.node.internal.util.StringUtil;
import com.liferay.gradle.plugins.node.tasks.DownloadNodeModuleTask;
import com.liferay.gradle.plugins.node.tasks.DownloadNodeTask;
import com.liferay.gradle.plugins.node.tasks.ExecuteNodeTask;
import com.liferay.gradle.plugins.node.tasks.ExecutePackageManagerTask;
import com.liferay.gradle.plugins.node.tasks.NpmInstallTask;
import com.liferay.gradle.plugins.node.tasks.NpmShrinkwrapTask;
import com.liferay.gradle.plugins.node.tasks.PackageLinkTask;
import com.liferay.gradle.plugins.node.tasks.PackageRunBuildTask;
import com.liferay.gradle.plugins.node.tasks.PackageRunTask;
import com.liferay.gradle.plugins.node.tasks.PublishNodeModuleTask;
import com.liferay.gradle.util.Validator;
import groovy.json.JsonSlurper;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.gradle.api.Action;
import org.gradle.api.GradleException;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.UncheckedIOException;
import org.gradle.api.file.CopySpec;
import org.gradle.api.file.FileCollection;
import org.gradle.api.internal.TaskOutputsInternal;
import org.gradle.api.internal.plugins.osgi.OsgiHelper;
import org.gradle.api.plugins.ExtensionAware;
import org.gradle.api.plugins.JavaPlugin;
import org.gradle.api.plugins.PluginContainer;
import org.gradle.api.specs.Spec;
import org.gradle.api.tasks.Delete;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.TaskCollection;
import org.gradle.api.tasks.TaskContainer;
import org.gradle.language.base.plugins.LifecycleBasePlugin;
import org.gradle.language.jvm.tasks.ProcessResources;
import org.gradle.util.VersionNumber;

public class NodePlugin
implements Plugin<Project> {
    public static final String CLEAN_NPM_TASK_NAME = "cleanNPM";
    public static final String DOWNLOAD_NODE_TASK_NAME = "downloadNode";
    public static final String EXTENSION_NAME = "node";
    public static final String NPM_INSTALL_TASK_NAME = "npmInstall";
    public static final String NPM_PACKAGE_LOCK_TASK_NAME = "npmPackageLock";
    public static final String NPM_SHRINKWRAP_TASK_NAME = "npmShrinkwrap";
    public static final String PACKAGE_LINKS_TASK_NAME = "packageLinks";
    public static final String PACKAGE_RUN_BUILD_TASK_NAME = "packageRunBuild";
    public static final String PACKAGE_RUN_TEST_TASK_NAME = "packageRunTest";
    private static final String _PACKAGE_LINK_TASK_NAME_PREFIX = "packageLink";
    private static final String _PACKAGE_RUN_TASK_NAME_PREFIX = "packageRun";
    private static final VersionNumber _node8VersionNumber = VersionNumber.version((int)8);
    private static final VersionNumber _npm5VersionNumber = VersionNumber.version((int)5);
    private static final OsgiHelper _osgiHelper = new OsgiHelper();

    public void apply(Project project) {
        final NodeExtension nodeExtension = (NodeExtension)GradleUtil.addExtension((ExtensionAware)project, (String)EXTENSION_NAME, NodeExtension.class);
        final DownloadNodeTask downloadNodeTask = this._addTaskDownloadNode(project, nodeExtension);
        Delete cleanNpmTask = this._addTaskCleanNpm(project);
        NpmInstallTask npmInstallTask = this._addTaskNpmInstall(project, cleanNpmTask);
        Map packageJsonMap = null;
        File packageJsonFile = npmInstallTask.getPackageJsonFile();
        if (packageJsonFile.exists()) {
            JsonSlurper jsonSlurper = new JsonSlurper();
            packageJsonMap = (Map)jsonSlurper.parse(packageJsonFile);
        }
        this._addTaskNpmPackageLock(project, cleanNpmTask, npmInstallTask);
        this._addTaskNpmShrinkwrap(project, cleanNpmTask, npmInstallTask);
        this._addTasksPackageLink(npmInstallTask, packageJsonMap);
        this._addTasksPackageRun(npmInstallTask, packageJsonMap, nodeExtension);
        this._configureTasksDownloadNodeModule(project, npmInstallTask, packageJsonMap);
        this._configureTasksExecuteNode(project, nodeExtension, GradleUtil.isRunningInsideDaemon());
        this._configureTasksExecutePackageManager(project, nodeExtension);
        this._configureTasksPublishNodeModule(project);
        project.afterEvaluate((Action)new Action<Project>(){

            public void execute(Project project) {
                NodePlugin.this._configureTaskDownloadNodeGlobal(downloadNodeTask, nodeExtension);
                NodePlugin.this._configureTasksExecutePackageManagerArgs(project, nodeExtension);
                NodePlugin.this._configureTasksNpmInstall(project, nodeExtension);
                NodePlugin.this._configureTasksPackageRun(project);
            }
        });
    }

    private Delete _addTaskCleanNpm(Project project) {
        Delete delete = (Delete)GradleUtil.addTask((Project)project, (String)CLEAN_NPM_TASK_NAME, Delete.class);
        delete.delete(new Object[]{"node_modules", "npm-shrinkwrap.json", "package-lock.json"});
        delete.setDescription("Deletes NPM files from this project.");
        return delete;
    }

    private DownloadNodeTask _addTaskDownloadNode(Project project, NodeExtension nodeExtension) {
        return this._addTaskDownloadNode(project, DOWNLOAD_NODE_TASK_NAME, nodeExtension);
    }

    private DownloadNodeTask _addTaskDownloadNode(Project project, String taskName, final NodeExtension nodeExtension) {
        DownloadNodeTask downloadNodeTask = (DownloadNodeTask)GradleUtil.addTask((Project)project, (String)taskName, DownloadNodeTask.class);
        downloadNodeTask.setNodeDir(new Callable<File>(){

            @Override
            public File call() throws Exception {
                return nodeExtension.getNodeDir();
            }
        });
        downloadNodeTask.setNodeUrl(new Callable<String>(){

            @Override
            public String call() throws Exception {
                return nodeExtension.getNodeUrl();
            }
        });
        downloadNodeTask.setNpmUrl(new Callable<String>(){

            @Override
            public String call() throws Exception {
                return nodeExtension.getNpmUrl();
            }
        });
        downloadNodeTask.onlyIf((Spec)new Spec<Task>(){

            public boolean isSatisfiedBy(Task task) {
                return nodeExtension.isDownload();
            }
        });
        downloadNodeTask.setDescription("Downloads Node.js in the project build directory.");
        return downloadNodeTask;
    }

    private NpmInstallTask _addTaskNpmInstall(Project project, Delete cleanNpmTask) {
        NpmInstallTask npmInstallTask = (NpmInstallTask)GradleUtil.addTask((Project)project, (String)NPM_INSTALL_TASK_NAME, NpmInstallTask.class);
        npmInstallTask.mustRunAfter(new Object[]{cleanNpmTask});
        npmInstallTask.setDescription("Installs Node packages from package.json.");
        npmInstallTask.setNpmInstallRetries(2);
        return npmInstallTask;
    }

    private Task _addTaskNpmPackageLock(Project project, Delete cleanNpmTask, NpmInstallTask npmInstallTask) {
        Task task = project.task(NPM_PACKAGE_LOCK_TASK_NAME);
        task.dependsOn(new Object[]{cleanNpmTask, npmInstallTask});
        task.setDescription("Deletes NPM files and installs Node packages from package.json.");
        return task;
    }

    private NpmShrinkwrapTask _addTaskNpmShrinkwrap(Project project, Delete cleanNpmTask, NpmInstallTask npmInstallTask) {
        NpmShrinkwrapTask npmShrinkwrapTask = (NpmShrinkwrapTask)GradleUtil.addTask((Project)project, (String)NPM_SHRINKWRAP_TASK_NAME, NpmShrinkwrapTask.class);
        npmShrinkwrapTask.dependsOn(new Object[]{cleanNpmTask, npmInstallTask});
        npmShrinkwrapTask.setDescription("Locks down the versions of a package's dependencies in order to control which versions of each dependency will be used.");
        return npmShrinkwrapTask;
    }

    private PackageLinkTask _addTaskPackageLink(String dependencyName, NpmInstallTask npmInstallTask) {
        Project project = npmInstallTask.getProject();
        String suffix = StringUtil.camelCase(dependencyName, true);
        PackageLinkTask packageLinkTask = (PackageLinkTask)GradleUtil.addTask((Project)project, (String)(_PACKAGE_LINK_TASK_NAME_PREFIX + suffix), PackageLinkTask.class);
        packageLinkTask.dependsOn(new Object[]{npmInstallTask});
        packageLinkTask.setDescription("Links the \"" + dependencyName + "\" package.json dependency.");
        packageLinkTask.setDependencyName(dependencyName);
        return packageLinkTask;
    }

    private Task _addTaskPackageLinks(Set<String> dependencyNames, Project project) {
        Task task = project.task(PACKAGE_LINKS_TASK_NAME);
        task.setDescription("Links all the package.json dependencies.");
        Pattern pattern = null;
        String taskNameRegex = GradleUtil.getTaskPrefixedProperty((Task)task, (String)"task.name.regex");
        if (Validator.isNotNull((String)taskNameRegex)) {
            pattern = Pattern.compile(taskNameRegex);
        }
        for (String dependencyName : dependencyNames) {
            Matcher matcher;
            String suffix = StringUtil.camelCase(dependencyName, true);
            String taskName = _PACKAGE_LINK_TASK_NAME_PREFIX + suffix;
            if (pattern != null && !(matcher = pattern.matcher(taskName)).find()) continue;
            task.dependsOn(new Object[]{taskName});
        }
        return task;
    }

    private PackageRunTask _addTaskPackageRun(String scriptName, NpmInstallTask npmInstallTask) {
        Project project = npmInstallTask.getProject();
        String suffix = StringUtil.camelCase(scriptName, true);
        String taskName = _PACKAGE_RUN_TASK_NAME_PREFIX + suffix;
        final PackageRunTask packageRunTask = (PackageRunTask)GradleUtil.addTask((Project)project, (String)taskName, PackageRunTask.class);
        packageRunTask.dependsOn(new Object[]{npmInstallTask});
        packageRunTask.setDescription("Runs the \"" + scriptName + "\" package.json script.");
        packageRunTask.setGroup("build");
        packageRunTask.setScriptName(scriptName);
        if (taskName.equals(PACKAGE_RUN_TEST_TASK_NAME)) {
            PluginContainer pluginContainer = project.getPlugins();
            pluginContainer.withType(LifecycleBasePlugin.class, (Action)new Action<LifecycleBasePlugin>(){

                public void execute(LifecycleBasePlugin lifecycleBasePlugin) {
                    NodePlugin.this._configureTaskPackageRunTestForLifecycleBasePlugin(packageRunTask);
                }
            });
        }
        return packageRunTask;
    }

    private PackageRunBuildTask _addTaskPackageRunBuild(NpmInstallTask npmInstallTask, NodeExtension nodeExtension) {
        final Project project = npmInstallTask.getProject();
        final PackageRunBuildTask packageRunBuildTask = (PackageRunBuildTask)GradleUtil.addTask((Project)project, (String)PACKAGE_RUN_BUILD_TASK_NAME, PackageRunBuildTask.class);
        packageRunBuildTask.dependsOn(new Object[]{npmInstallTask});
        packageRunBuildTask.setDescription("Runs the \"build\" package.json script.");
        packageRunBuildTask.setGroup("build");
        packageRunBuildTask.setNodeVersion(nodeExtension.getNodeVersion());
        packageRunBuildTask.doLast((Action)new Action<Task>(){

            public void execute(Task task) {
                PackageRunBuildTask packageRunBuildTask = (PackageRunBuildTask)task;
                String result = packageRunBuildTask.getResult();
                if (result.contains("errors during Soy compilation")) {
                    project.delete(new Object[]{packageRunBuildTask.getDigestFile()});
                    throw new GradleException("Soy compile error");
                }
            }
        });
        PluginContainer pluginContainer = project.getPlugins();
        pluginContainer.withType(JavaPlugin.class, (Action)new Action<JavaPlugin>(){

            public void execute(JavaPlugin javaPlugin) {
                NodePlugin.this._configureTaskPackageRunBuildForJavaPlugin(packageRunBuildTask);
            }
        });
        return packageRunBuildTask;
    }

    private void _addTasksPackageLink(NpmInstallTask npmInstallTask, Map<String, Object> packageJsonMap) {
        if (packageJsonMap == null) {
            return;
        }
        Map dependenciesJsonMap = (Map)packageJsonMap.get("dependencies");
        if (dependenciesJsonMap != null) {
            Set<String> dependencyNames = dependenciesJsonMap.keySet();
            for (String dependencyName : dependencyNames) {
                this._addTaskPackageLink(dependencyName, npmInstallTask);
            }
            this._addTaskPackageLinks(dependencyNames, npmInstallTask.getProject());
        }
    }

    private void _addTasksPackageRun(NpmInstallTask npmInstallTask, Map<String, Object> packageJsonMap, NodeExtension nodeExtension) {
        if (packageJsonMap == null) {
            return;
        }
        Map scriptsJsonMap = (Map)packageJsonMap.get("scripts");
        if (scriptsJsonMap != null) {
            for (String scriptName : scriptsJsonMap.keySet()) {
                if (Objects.equals(scriptName, "build")) {
                    this._addTaskPackageRunBuild(npmInstallTask, nodeExtension);
                    continue;
                }
                this._addTaskPackageRun(scriptName, npmInstallTask);
            }
        }
    }

    private void _configureTaskDownloadNodeGlobal(DownloadNodeTask downloadNodeTask, NodeExtension nodeExtension) {
        Project project = downloadNodeTask.getProject();
        if (!nodeExtension.isDownload() || !nodeExtension.isGlobal() || project.getParent() == null) {
            return;
        }
        Project rootProject = project.getRootProject();
        DownloadNodeTask rootDownloadNodeTask = null;
        TaskContainer taskContainer = rootProject.getTasks();
        TaskCollection rootDownloadNodeTasks = taskContainer.withType(DownloadNodeTask.class);
        File nodeDir = downloadNodeTask.getNodeDir();
        String nodeUrl = downloadNodeTask.getNodeUrl();
        for (DownloadNodeTask curRootDownloadNodeTask : rootDownloadNodeTasks) {
            if (!nodeDir.equals(curRootDownloadNodeTask.getNodeDir()) || !nodeUrl.equals(curRootDownloadNodeTask.getNodeUrl())) continue;
            rootDownloadNodeTask = curRootDownloadNodeTask;
            break;
        }
        if (rootDownloadNodeTask == null) {
            String taskName = DOWNLOAD_NODE_TASK_NAME;
            if (!rootDownloadNodeTasks.isEmpty()) {
                taskName = taskName + rootDownloadNodeTasks.size();
            }
            rootDownloadNodeTask = this._addTaskDownloadNode(rootProject, taskName, nodeExtension);
        }
        downloadNodeTask.setActions(Collections.emptyList());
        downloadNodeTask.dependsOn(new Object[]{rootDownloadNodeTask});
    }

    private void _configureTaskDownloadNodeModule(DownloadNodeModuleTask downloadNodeModuleTask, final NpmInstallTask npmInstallTask, final Map<String, Object> packageJsonMap) {
        downloadNodeModuleTask.onlyIf((Spec)new Spec<Task>(){

            public boolean isSatisfiedBy(Task task) {
                DownloadNodeModuleTask downloadNodeModuleTask = (DownloadNodeModuleTask)task;
                File moduleDir = downloadNodeModuleTask.getModuleDir();
                File moduleParentDir = moduleDir.getParentFile();
                if (!moduleParentDir.equals(npmInstallTask.getNodeModulesDir())) {
                    return true;
                }
                if (packageJsonMap == null) {
                    return true;
                }
                String moduleName = downloadNodeModuleTask.getModuleName();
                Map dependenciesJsonMap = (Map)packageJsonMap.get("dependencies");
                if (dependenciesJsonMap != null && dependenciesJsonMap.containsKey(moduleName)) {
                    return false;
                }
                dependenciesJsonMap = (Map)packageJsonMap.get("devDependencies");
                return dependenciesJsonMap == null || !dependenciesJsonMap.containsKey(moduleName);
            }
        });
    }

    private void _configureTaskExecuteNode(ExecuteNodeTask executeNodeTask, final NodeExtension nodeExtension, boolean useGradleExec) {
        executeNodeTask.setNodeDir(new Callable<File>(){

            @Override
            public File call() throws Exception {
                if (nodeExtension.isDownload()) {
                    return nodeExtension.getNodeDir();
                }
                return null;
            }
        });
        executeNodeTask.setUseGradleExec(useGradleExec);
    }

    private void _configureTaskExecutePackageManager(final ExecutePackageManagerTask executePackageManagerTask, final NodeExtension nodeExtension) {
        final Callable<Boolean> useGlobalConcurrentCacheCallable = new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                int value1 = _node8VersionNumber.compareTo(VersionNumber.parse((String)nodeExtension.getNodeVersion()));
                int value2 = _npm5VersionNumber.compareTo(VersionNumber.parse((String)nodeExtension.getNpmVersion()));
                if (value1 <= 0 || value2 <= 0) {
                    return true;
                }
                return false;
            }
        };
        executePackageManagerTask.setCacheConcurrent(useGlobalConcurrentCacheCallable);
        executePackageManagerTask.setCacheDir(new Callable<File>(){

            @Override
            public File call() throws Exception {
                if (((Boolean)useGlobalConcurrentCacheCallable.call()).booleanValue()) {
                    return null;
                }
                File nodeDir = executePackageManagerTask.getNodeDir();
                if (nodeDir == null) {
                    return null;
                }
                return new File(nodeDir, ".cache");
            }
        });
        final Project project = executePackageManagerTask.getProject();
        executePackageManagerTask.setNodeModulesDir(new Callable<File>(){

            @Override
            public File call() throws Exception {
                if (nodeExtension.isUseNpm()) {
                    return project.file((Object)"node_modules");
                }
                File scriptFile = executePackageManagerTask.getScriptFile();
                return new File(scriptFile.getParent(), "node_modules");
            }
        });
        executePackageManagerTask.setScriptFile(new Callable<File>(){

            @Override
            public File call() throws Exception {
                File nodeDir = nodeExtension.getNodeDir();
                if (nodeDir == null) {
                    return null;
                }
                if (nodeExtension.isUseNpm()) {
                    File npmDir = NodePluginUtil.getNpmDir(nodeDir);
                    return new File(npmDir, "bin/npm-cli.js");
                }
                return nodeExtension.getYarnScriptFile();
            }
        });
        executePackageManagerTask.setUseNpm(new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                return nodeExtension.isUseNpm();
            }
        });
    }

    private void _configureTaskExecutePackageManagerArgs(ExecutePackageManagerTask executePackageManagerTask, NodeExtension nodeExtension) {
        if (nodeExtension.isUseNpm()) {
            executePackageManagerTask.args(nodeExtension.getNpmArgs());
        }
    }

    private void _configureTaskNpmInstall(NpmInstallTask npmInstallTask, NodeExtension nodeExtension) {
        npmInstallTask.setNodeVersion(nodeExtension.getNodeVersion());
        npmInstallTask.setNpmVersion(nodeExtension.getNpmVersion());
    }

    private void _configureTaskPackageRun(PackageRunTask packageRunTask) {
        SourceSet sourceSet;
        File javaClassesDir;
        Project project = packageRunTask.getProject();
        PluginContainer pluginContainer = project.getPlugins();
        if (pluginContainer.hasPlugin(JavaPlugin.class) && !(javaClassesDir = FileUtil.getJavaClassesDir((SourceSet)(sourceSet = GradleUtil.getSourceSet((Project)packageRunTask.getProject(), (String)"main")))).exists()) {
            TaskOutputsInternal taskOutputs = packageRunTask.getOutputs();
            taskOutputs.upToDateWhen((Spec)new Spec<Task>(){

                public boolean isSatisfiedBy(Task task) {
                    return false;
                }
            });
        }
    }

    private void _configureTaskPackageRunBuildForJavaPlugin(PackageRunBuildTask packageRunBuildTask) {
        packageRunBuildTask.mustRunAfter(new Object[]{"processResources"});
        Task classesTask = GradleUtil.getTask((Project)packageRunBuildTask.getProject(), (String)"classes");
        classesTask.dependsOn(new Object[]{packageRunBuildTask});
        final File digestFile = packageRunBuildTask.getDigestFile();
        if (!this._isStale(digestFile, packageRunBuildTask.getSourceFiles())) {
            final Project project = packageRunBuildTask.getProject();
            ProcessResources processResourcesTask = (ProcessResources)GradleUtil.getTask((Project)project, (String)"processResources");
            processResourcesTask.doFirst((Action)new Action<Task>(){

                public void execute(Task task) {
                    ProcessResources processResourcesTask = (ProcessResources)task;
                    final File processResourcesDir = processResourcesTask.getDestinationDir();
                    final File outputsDir = new File(digestFile.getParentFile(), "outputs");
                    project.delete(new Object[]{outputsDir});
                    outputsDir.mkdirs();
                    project.copy((Action)new Action<CopySpec>(){

                        public void execute(CopySpec copySpec) {
                            copySpec.from(new Object[]{processResourcesDir});
                            copySpec.include(new String[]{"**/*.js"});
                            copySpec.into((Object)outputsDir);
                            copySpec.setIncludeEmptyDirs(false);
                        }
                    });
                }
            });
            processResourcesTask.doLast((Action)new Action<Task>(){

                public void execute(Task task) {
                    ProcessResources processResourcesTask = (ProcessResources)task;
                    final File processResourcesDir = processResourcesTask.getDestinationDir();
                    final File outputsDir = new File(digestFile.getParentFile(), "outputs");
                    project.copy((Action)new Action<CopySpec>(){

                        public void execute(CopySpec copySpec) {
                            copySpec.from(new Object[]{outputsDir});
                            copySpec.into((Object)processResourcesDir);
                        }
                    });
                }
            });
        }
    }

    private void _configureTaskPackageRunTestForLifecycleBasePlugin(ExecutePackageManagerTask executePackageManagerTask) {
        Task checkTask = GradleUtil.getTask((Project)executePackageManagerTask.getProject(), (String)"check");
        checkTask.dependsOn(new Object[]{executePackageManagerTask});
    }

    private void _configureTaskPublishNodeModule(PublishNodeModuleTask publishNodeModuleTask) {
        final Project project = publishNodeModuleTask.getProject();
        publishNodeModuleTask.setModuleDescription(new Callable<String>(){

            @Override
            public String call() throws Exception {
                return project.getDescription();
            }
        });
        publishNodeModuleTask.setModuleName(new Callable<String>(){

            @Override
            public String call() throws Exception {
                String moduleName = _osgiHelper.getBundleSymbolicName(project);
                int pos = moduleName.indexOf(46);
                if (pos != -1) {
                    moduleName = moduleName.substring(pos + 1);
                    moduleName = moduleName.replace('.', '-');
                }
                return moduleName;
            }
        });
        publishNodeModuleTask.setModuleVersion(new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                return project.getVersion();
            }
        });
    }

    private void _configureTasksDownloadNodeModule(Project project, final NpmInstallTask npmInstallTask, final Map<String, Object> packageJsonMap) {
        TaskContainer taskContainer = project.getTasks();
        taskContainer.withType(DownloadNodeModuleTask.class, (Action)new Action<DownloadNodeModuleTask>(){

            public void execute(DownloadNodeModuleTask downloadNodeModuleTask) {
                NodePlugin.this._configureTaskDownloadNodeModule(downloadNodeModuleTask, npmInstallTask, packageJsonMap);
            }
        });
    }

    private void _configureTasksExecuteNode(Project project, final NodeExtension nodeExtension, final boolean useGradleExec) {
        TaskContainer taskContainer = project.getTasks();
        taskContainer.withType(ExecuteNodeTask.class, (Action)new Action<ExecuteNodeTask>(){

            public void execute(ExecuteNodeTask executeNodeTask) {
                NodePlugin.this._configureTaskExecuteNode(executeNodeTask, nodeExtension, useGradleExec);
            }
        });
    }

    private void _configureTasksExecutePackageManager(Project project, final NodeExtension nodeExtension) {
        TaskContainer taskContainer = project.getTasks();
        taskContainer.withType(ExecutePackageManagerTask.class, (Action)new Action<ExecutePackageManagerTask>(){

            public void execute(ExecutePackageManagerTask executePackageManagerTask) {
                NodePlugin.this._configureTaskExecutePackageManager(executePackageManagerTask, nodeExtension);
            }
        });
    }

    private void _configureTasksExecutePackageManagerArgs(Project project, final NodeExtension nodeExtension) {
        TaskContainer taskContainer = project.getTasks();
        taskContainer.withType(ExecutePackageManagerTask.class, (Action)new Action<ExecutePackageManagerTask>(){

            public void execute(ExecutePackageManagerTask executePackageManagerTask) {
                NodePlugin.this._configureTaskExecutePackageManagerArgs(executePackageManagerTask, nodeExtension);
            }
        });
    }

    private void _configureTasksNpmInstall(Project project, final NodeExtension nodeExtension) {
        TaskContainer taskContainer = project.getTasks();
        taskContainer.withType(NpmInstallTask.class, (Action)new Action<NpmInstallTask>(){

            public void execute(NpmInstallTask npmInstallTask) {
                NodePlugin.this._configureTaskNpmInstall(npmInstallTask, nodeExtension);
            }
        });
    }

    private void _configureTasksPackageRun(Project project) {
        TaskContainer taskContainer = project.getTasks();
        taskContainer.withType(PackageRunTask.class, (Action)new Action<PackageRunTask>(){

            public void execute(PackageRunTask packageRunTask) {
                NodePlugin.this._configureTaskPackageRun(packageRunTask);
            }
        });
    }

    private void _configureTasksPublishNodeModule(Project project) {
        TaskContainer taskContainer = project.getTasks();
        taskContainer.withType(PublishNodeModuleTask.class, (Action)new Action<PublishNodeModuleTask>(){

            public void execute(PublishNodeModuleTask publishNodeModuleTask) {
                NodePlugin.this._configureTaskPublishNodeModule(publishNodeModuleTask);
            }
        });
    }

    private boolean _isStale(File sourceDigestFile, FileCollection sourceFileCollection) {
        if (!sourceDigestFile.exists()) {
            return true;
        }
        byte[] bytes = null;
        try {
            bytes = Files.readAllBytes(sourceDigestFile.toPath());
        }
        catch (IOException ioe) {
            throw new UncheckedIOException((Throwable)ioe);
        }
        String oldDigest = new String(bytes, StandardCharsets.UTF_8);
        String newDigest = FileUtil.getDigest((Iterable<File>)sourceFileCollection);
        return !Objects.equals(oldDigest, newDigest);
    }
}

