/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.gradle.plugins.node.internal.util;

import com.liferay.gradle.util.OSDetector;
import groovy.json.JsonSlurper;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.DirectoryStream;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import org.gradle.api.Action;
import org.gradle.api.GradleException;
import org.gradle.api.Project;
import org.gradle.api.UncheckedIOException;
import org.gradle.api.file.CopySpec;
import org.gradle.api.logging.Logger;
import org.gradle.internal.hash.HashUtil;
import org.gradle.internal.hash.HashValue;
import org.gradle.process.ExecResult;
import org.gradle.process.ExecSpec;

public class FileUtil
extends com.liferay.gradle.util.FileUtil {
    private static final String _NODE_MODULES_BIN_DIR_NAME = ".bin";
    private static final DirectoryStream.Filter<Path> _directoryStreamFilter = new DirectoryStream.Filter<Path>(){

        @Override
        public boolean accept(Path path) throws IOException {
            return Files.isDirectory(path, new LinkOption[0]);
        }
    };

    public static void createBinDirLinks(Logger logger, File nodeModulesDir) throws IOException {
        for (File nodeModulesBinDir : FileUtil._getNodeModulesBinDirs(nodeModulesDir)) {
            FileUtil._createBinDirLinks(logger, nodeModulesBinDir);
        }
    }

    public static void deleteSymbolicLinks(Path dirPath) throws IOException {
        try (DirectoryStream<Path> directoryStream = Files.newDirectoryStream(dirPath);){
            for (Path path : directoryStream) {
                if (!Files.isSymbolicLink(path)) continue;
                Files.delete(path);
            }
        }
    }

    public static String getDigest(Iterable<File> files) {
        StringBuilder sb = new StringBuilder();
        SortedSet<File> sortedFiles = null;
        try {
            sortedFiles = FileUtil._flattenAndSort(files);
        }
        catch (IOException ioe) {
            throw new GradleException("Unable to flatten files", (Throwable)ioe);
        }
        for (File file : sortedFiles) {
            if (!file.exists()) continue;
            try {
                List<String> lines = Files.readAllLines(file.toPath(), StandardCharsets.UTF_8);
                sb.append(Integer.toHexString(lines.hashCode()));
            }
            catch (IOException ioe) {
                HashValue hashValue = HashUtil.sha1((File)file);
                sb.append(hashValue.asHexString());
            }
            sb.append('-');
        }
        if (sb.length() > 0) {
            sb.setLength(sb.length() - 1);
        }
        return sb.toString();
    }

    public static void removeBinDirLinks(Logger logger, File nodeModulesDir) throws IOException {
        for (File nodeModulesBinDir : FileUtil._getNodeModulesBinDirs(nodeModulesDir)) {
            if (logger.isInfoEnabled()) {
                String message = "Removing binary symbolic links from {}";
                logger.info(message, (Object)nodeModulesBinDir.toPath());
            }
            FileUtil.deleteSymbolicLinks(nodeModulesBinDir.toPath());
        }
    }

    public static void syncDir(Project project, final File sourceDir, final File targetDir, boolean nativeSync) {
        ExecResult execResult = null;
        if (nativeSync) {
            execResult = project.exec((Action)new Action<ExecSpec>(){

                public void execute(ExecSpec execSpec) {
                    if (OSDetector.isWindows()) {
                        execSpec.args(new Object[]{"/MIR", "/NDL", "/NFL", "/NJH", "/NJS", "/NP", sourceDir.getAbsolutePath(), targetDir.getAbsolutePath()});
                        execSpec.setExecutable("robocopy");
                    } else {
                        execSpec.args(new Object[]{"--archive", "--delete", sourceDir.getAbsolutePath() + File.separator, targetDir.getAbsolutePath()});
                        execSpec.setExecutable("rsync");
                    }
                    execSpec.setIgnoreExitValue(true);
                }
            });
        }
        if (execResult != null && execResult.getExitValue() == 0) {
            return;
        }
        project.delete(new Object[]{targetDir});
        try {
            project.copy((Action)new Action<CopySpec>(){

                public void execute(CopySpec copySpec) {
                    copySpec.from(new Object[]{sourceDir});
                    copySpec.into((Object)targetDir);
                }
            });
        }
        catch (RuntimeException re) {
            project.delete(new Object[]{targetDir});
            throw re;
        }
    }

    private static void _createBinDirLinks(Logger logger, File nodeModulesBinDir) throws IOException {
        JsonSlurper jsonSlurper = new JsonSlurper();
        Path nodeModulesBinDirPath = nodeModulesBinDir.toPath();
        File nodeModulesDir = nodeModulesBinDir.getParentFile();
        try (DirectoryStream<Path> directoryStream = Files.newDirectoryStream(nodeModulesDir.toPath(), _directoryStreamFilter);){
            for (Path dirPath : directoryStream) {
                Map binJsonMap;
                Map packageJsonMap;
                Object binObject;
                Path packageJsonPath = dirPath.resolve("package.json");
                if (Files.notExists(packageJsonPath, new LinkOption[0]) && Files.exists(dirPath.resolve("cli"), new LinkOption[0])) {
                    dirPath = dirPath.resolve("cli");
                    packageJsonPath = dirPath.resolve("package.json");
                }
                if (Files.notExists(packageJsonPath, new LinkOption[0]) || !((binObject = (packageJsonMap = (Map)jsonSlurper.parse(packageJsonPath.toFile())).get("bin")) instanceof Map) || (binJsonMap = (Map)binObject).isEmpty()) continue;
                Files.createDirectories(nodeModulesBinDirPath, new FileAttribute[0]);
                for (Map.Entry entry : binJsonMap.entrySet()) {
                    String linkFileName = (String)entry.getKey();
                    String linkTargetFileName = (String)entry.getValue();
                    Path linkPath = nodeModulesBinDirPath.resolve(linkFileName);
                    Path linkTargetPath = dirPath.resolve(linkTargetFileName);
                    Files.deleteIfExists(linkPath);
                    Files.createSymbolicLink(linkPath, linkTargetPath, new FileAttribute[0]);
                    if (!logger.isInfoEnabled()) continue;
                    logger.info("Created binary symbolic link {} which targets {}", (Object)linkPath, (Object)linkTargetPath);
                }
            }
        }
    }

    private static SortedSet<File> _flattenAndSort(Iterable<File> files) throws IOException {
        final TreeSet<File> sortedFiles = new TreeSet<File>(new FileComparator());
        if (files == null) {
            return sortedFiles;
        }
        for (File file : files) {
            if (file.isDirectory()) {
                Files.walkFileTree(file.toPath(), (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                    @Override
                    public FileVisitResult visitFile(Path path, BasicFileAttributes basicFileAttributes) throws IOException {
                        sortedFiles.add(path.toFile());
                        return FileVisitResult.CONTINUE;
                    }
                });
                continue;
            }
            sortedFiles.add(file);
        }
        return sortedFiles;
    }

    private static Set<File> _getNodeModulesBinDirs(File nodeModulesDir) throws IOException {
        final HashSet<File> nodeModulesBinDirs = new HashSet<File>();
        Files.walkFileTree(nodeModulesDir.toPath(), (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult preVisitDirectory(Path dirPath, BasicFileAttributes basicFileAttributes) throws IOException {
                String dirName = String.valueOf(dirPath.getFileName());
                if (dirName.equals(FileUtil._NODE_MODULES_BIN_DIR_NAME)) {
                    nodeModulesBinDirs.add(dirPath.toFile());
                    return FileVisitResult.SKIP_SUBTREE;
                }
                return FileVisitResult.CONTINUE;
            }
        });
        return nodeModulesBinDirs;
    }

    private static class FileComparator
    implements Comparator<File> {
        private FileComparator() {
        }

        @Override
        public int compare(File file1, File file2) {
            String canonicalPath1 = FileComparator._getCanonicalPath(file1);
            String canonicalPath2 = FileComparator._getCanonicalPath(file2);
            return canonicalPath1.compareTo(canonicalPath2);
        }

        private static String _getCanonicalPath(File file) {
            String canonicalPath = null;
            try {
                canonicalPath = file.getCanonicalPath();
            }
            catch (IOException ioe) {
                String message = "Unable to get canonical path of " + file;
                throw new UncheckedIOException(message, (Throwable)ioe);
            }
            if (File.separatorChar != '/') {
                canonicalPath = canonicalPath.replace(File.separatorChar, '/');
            }
            return canonicalPath;
        }
    }
}

