/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.gradle.plugins.node.tasks;

import com.liferay.gradle.plugins.node.internal.util.FileUtil;
import com.liferay.gradle.plugins.node.internal.util.GradleUtil;
import com.liferay.gradle.plugins.node.tasks.ExecuteNpmTask;
import groovy.lang.Closure;
import java.io.File;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Set;
import org.gradle.api.Project;
import org.gradle.api.file.ConfigurableFileTree;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.FileTree;
import org.gradle.api.file.FileTreeElement;
import org.gradle.api.specs.Spec;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.util.PatternFilterable;
import org.gradle.api.tasks.util.PatternSet;

public abstract class BaseNpmCommandTask
extends ExecuteNpmTask
implements PatternFilterable {
    private Object _nodeVersion;
    private Object _npmCommand;
    private Object _npmVersion;
    private final PatternFilterable _patternFilterable = new PatternSet();
    private Object _sourceDir;

    public BaseNpmCommandTask exclude(Closure excludeSpec) {
        this._patternFilterable.exclude(excludeSpec);
        return this;
    }

    public BaseNpmCommandTask exclude(Iterable<String> excludes) {
        this._patternFilterable.exclude(excludes);
        return this;
    }

    public BaseNpmCommandTask exclude(Spec<FileTreeElement> excludeSpec) {
        this._patternFilterable.exclude(excludeSpec);
        return this;
    }

    public BaseNpmCommandTask exclude(String ... excludes) {
        this._patternFilterable.exclude(excludes);
        return this;
    }

    @Override
    public void executeNode() throws Exception {
        String digest = FileUtil.getDigest((Iterable<File>)this.getSourceFiles());
        super.executeNode();
        this._writeSourceDigestFile(digest.getBytes(StandardCharsets.UTF_8));
    }

    public Set<String> getExcludes() {
        return this._patternFilterable.getExcludes();
    }

    public Set<String> getIncludes() {
        return this._patternFilterable.getIncludes();
    }

    @Input
    @Optional
    public String getNodeVersion() {
        return GradleUtil.toString((Object)this._nodeVersion);
    }

    @Input
    public String getNpmCommand() {
        return GradleUtil.toString((Object)this._npmCommand);
    }

    @Input
    @Optional
    public String getNpmVersion() {
        return GradleUtil.toString((Object)this._npmVersion);
    }

    @OutputFile
    public File getSourceDigestFile() {
        Project project = this.getProject();
        String pathname = "npm/" + this.getName() + "/.digest";
        return new File(project.getBuildDir(), pathname);
    }

    @Input
    @Optional
    public File getSourceDir() {
        return GradleUtil.toFile(this.getProject(), this._sourceDir);
    }

    @InputFiles
    @Optional
    public FileCollection getSourceFiles() {
        File sourceDir = this.getSourceDir();
        if (sourceDir == null || !sourceDir.exists()) {
            return null;
        }
        Project project = this.getProject();
        ConfigurableFileTree fileTree = project.fileTree((Object)sourceDir);
        FileTree fileCollection = fileTree.matching(this._patternFilterable);
        if (fileCollection.isEmpty()) {
            return null;
        }
        return fileCollection;
    }

    public BaseNpmCommandTask include(Closure includeSpec) {
        this._patternFilterable.include(includeSpec);
        return this;
    }

    public BaseNpmCommandTask include(Iterable<String> includes) {
        this._patternFilterable.include(includes);
        return this;
    }

    public BaseNpmCommandTask include(Spec<FileTreeElement> includeSpec) {
        this._patternFilterable.include(includeSpec);
        return this;
    }

    public BaseNpmCommandTask include(String ... includes) {
        this._patternFilterable.include(includes);
        return this;
    }

    public BaseNpmCommandTask setExcludes(Iterable<String> excludes) {
        this._patternFilterable.setExcludes(excludes);
        return this;
    }

    public BaseNpmCommandTask setIncludes(Iterable<String> includes) {
        this._patternFilterable.setIncludes(includes);
        return this;
    }

    public void setNodeVersion(Object nodeVersion) {
        this._nodeVersion = nodeVersion;
    }

    public void setNpmCommand(Object npmCommand) {
        this._npmCommand = npmCommand;
    }

    public void setNpmVersion(Object npmVersion) {
        this._npmVersion = npmVersion;
    }

    public void setSourceDir(Object sourceDir) {
        this._sourceDir = sourceDir;
    }

    private void _writeSourceDigestFile(byte[] bytes) throws Exception {
        File file = this.getSourceDigestFile();
        File dir = file.getParentFile();
        if (dir != null) {
            Files.createDirectories(dir.toPath(), new FileAttribute[0]);
        }
        Files.write(file.toPath(), bytes, new OpenOption[0]);
    }
}

