/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.gradle.plugins.node.internal.util;

import com.liferay.gradle.util.OSDetector;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import org.gradle.api.Action;
import org.gradle.api.Project;
import org.gradle.api.file.CopySpec;
import org.gradle.process.ExecResult;
import org.gradle.process.ExecSpec;

public class FileUtil
extends com.liferay.gradle.util.FileUtil {
    public static void removeDirs(final Project project, File rootDir, final String dirName) throws IOException {
        Files.walkFileTree(rootDir.toPath(), (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult preVisitDirectory(Path dirPath, BasicFileAttributes basicFileAttributes) throws IOException {
                Path dirNamePath = dirPath.getFileName();
                if (!dirName.equals(dirNamePath.toString())) {
                    return FileVisitResult.CONTINUE;
                }
                project.delete(new Object[]{dirPath.toFile()});
                return FileVisitResult.SKIP_SUBTREE;
            }
        });
    }

    public static void syncDir(Project project, final File sourceDir, final File targetDir, boolean nativeSync) {
        ExecResult execResult = null;
        if (nativeSync) {
            execResult = project.exec((Action)new Action<ExecSpec>(){

                public void execute(ExecSpec execSpec) {
                    if (OSDetector.isWindows()) {
                        execSpec.args(new Object[]{"/MIR", "/NDL", "/NFL", "/NJH", "/NJS", "/NP", sourceDir.getAbsolutePath(), targetDir.getAbsolutePath()});
                        execSpec.setExecutable((Object)"robocopy");
                    } else {
                        execSpec.args(new Object[]{"--archive", "--delete", sourceDir.getAbsolutePath() + File.separator, targetDir.getAbsolutePath()});
                        execSpec.setExecutable((Object)"rsync");
                    }
                    execSpec.setIgnoreExitValue(true);
                }
            });
        }
        if (execResult != null && execResult.getExitValue() == 0) {
            return;
        }
        project.delete(new Object[]{targetDir});
        try {
            project.copy((Action)new Action<CopySpec>(){

                public void execute(CopySpec copySpec) {
                    copySpec.from(new Object[]{sourceDir});
                    copySpec.into((Object)targetDir);
                }
            });
        }
        catch (RuntimeException re) {
            project.delete(new Object[]{targetDir});
            throw re;
        }
    }
}

