/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.gradle.plugins.node.tasks;

import com.liferay.gradle.plugins.node.internal.util.FileUtil;
import com.liferay.gradle.plugins.node.internal.util.GradleUtil;
import com.liferay.gradle.plugins.node.tasks.ExecuteNpmTask;
import com.liferay.gradle.util.Validator;
import groovy.json.JsonSlurper;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.logging.Logger;
import org.gradle.api.plugins.PluginContainer;
import org.gradle.api.specs.Spec;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OutputDirectory;

public class NpmInstallTask
extends ExecuteNpmTask {
    private static final String _NODE_MODULES_BIN_DIR_NAME = ".bin";
    private Object _nodeModulesCacheDir;
    private boolean _nodeModulesCacheNativeSync = true;
    private boolean _nodeModulesCacheRemoveBinDirs = true;
    private Object _removeShrinkwrappedUrls = new Callable<Boolean>(){

        @Override
        public Boolean call() throws Exception {
            if (Validator.isNotNull((String)NpmInstallTask.this.getRegistry())) {
                return true;
            }
            return false;
        }
    };

    public NpmInstallTask() {
        this.onlyIf((Spec)new Spec<Task>(){

            public boolean isSatisfiedBy(Task task) {
                NpmInstallTask npmInstallTask = (NpmInstallTask)task;
                File packageJsonFile = npmInstallTask.getPackageJsonFile();
                if (!packageJsonFile.exists()) {
                    return false;
                }
                JsonSlurper jsonSlurper = new JsonSlurper();
                Map packageJson = (Map)jsonSlurper.parse(packageJsonFile);
                return packageJson.containsKey("dependencies") || packageJson.containsKey("devDependencies");
            }
        });
    }

    @Override
    public void executeNode() throws Exception {
        this.executeNpmInstall(false);
    }

    public File getNodeModulesCacheDir() {
        return GradleUtil.toFile(this.getProject(), this._nodeModulesCacheDir);
    }

    @OutputDirectory
    public File getNodeModulesDir() {
        Project project = this.getProject();
        return project.file((Object)"node_modules");
    }

    @InputFile
    public File getPackageJsonFile() {
        Project project = this.getProject();
        return project.file((Object)"package.json");
    }

    @InputFile
    @Optional
    public File getShrinkwrapJsonFile() {
        Project project = this.getProject();
        File shrinkwrapJsonFile = project.file((Object)"npm-shrinkwrap.json");
        if (!shrinkwrapJsonFile.exists()) {
            shrinkwrapJsonFile = null;
        }
        return shrinkwrapJsonFile;
    }

    public boolean isNodeModulesCacheNativeSync() {
        return this._nodeModulesCacheNativeSync;
    }

    public boolean isNodeModulesCacheRemoveBinDirs() {
        return this._nodeModulesCacheRemoveBinDirs;
    }

    public boolean isRemoveShrinkwrappedUrls() {
        return GradleUtil.toBoolean(this._removeShrinkwrappedUrls);
    }

    public void setNodeModulesCacheDir(Object nodeModulesCacheDir) {
        this._nodeModulesCacheDir = nodeModulesCacheDir;
    }

    public void setNodeModulesCacheNativeSync(boolean nodeModulesCacheNativeSync) {
        this._nodeModulesCacheNativeSync = nodeModulesCacheNativeSync;
    }

    public void setNodeModulesCacheRemoveBinDirs(boolean nodeModulesCacheRemoveBinDirs) {
        this._nodeModulesCacheRemoveBinDirs = nodeModulesCacheRemoveBinDirs;
    }

    @Deprecated
    public void setRemoveShrinkwrappedUrls(boolean removeShrinkwrappedUrls) {
        this._removeShrinkwrappedUrls = removeShrinkwrappedUrls;
    }

    public void setRemoveShrinkwrappedUrls(Object removeShrinkwrappedUrls) {
        this._removeShrinkwrappedUrls = removeShrinkwrappedUrls;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void executeNpmInstall(boolean reset) throws Exception {
        Logger logger = this.getLogger();
        Path shrinkwrapJsonBackupPath = null;
        Path shrinkwrapJsonPath = null;
        File shrinkwrapJsonFile = this.getShrinkwrapJsonFile();
        if (this.isRemoveShrinkwrappedUrls() && shrinkwrapJsonFile != null) {
            shrinkwrapJsonPath = shrinkwrapJsonFile.toPath();
            shrinkwrapJsonBackupPath = Paths.get(shrinkwrapJsonPath.toString() + ".backup", new String[0]);
            Files.copy(shrinkwrapJsonPath, shrinkwrapJsonBackupPath, StandardCopyOption.REPLACE_EXISTING);
            this._removeShrinkwrappedUrls();
        }
        try {
            if (this._isCacheEnabled()) {
                if (logger.isInfoEnabled()) {
                    logger.info("Cache for {} is enabled", (Object)this);
                }
                NpmInstallTask._npmInstallCached(this, reset);
            } else {
                if (logger.isInfoEnabled()) {
                    logger.info("Cache for {} is disabled", (Object)this);
                }
                this._npmInstall(reset);
            }
            if (shrinkwrapJsonBackupPath == null) return;
        }
        catch (Throwable throwable) {
            if (shrinkwrapJsonBackupPath == null) throw throwable;
            Files.move(shrinkwrapJsonBackupPath, shrinkwrapJsonPath, StandardCopyOption.REPLACE_EXISTING);
            throw throwable;
        }
        Files.move(shrinkwrapJsonBackupPath, shrinkwrapJsonPath, StandardCopyOption.REPLACE_EXISTING);
    }

    @Override
    protected List<String> getCompleteArgs() {
        List<String> completeArgs = super.getCompleteArgs();
        completeArgs.add("install");
        return completeArgs;
    }

    private static String _getNodeModulesCacheDigest(NpmInstallTask npmInstallTask) {
        JsonSlurper jsonSlurper = new JsonSlurper();
        File jsonFile = npmInstallTask.getShrinkwrapJsonFile();
        if (jsonFile == null) {
            Logger logger = npmInstallTask.getLogger();
            if (logger.isWarnEnabled()) {
                logger.warn("Unable to find npm-shrinkwrap.json for {}, using package.json instead", (Object)npmInstallTask.getProject());
            }
            jsonFile = npmInstallTask.getPackageJsonFile();
        }
        Map map = (Map)jsonSlurper.parse(jsonFile);
        map.remove("name");
        map.remove("version");
        return String.valueOf(map.hashCode());
    }

    private static synchronized void _npmInstallCached(NpmInstallTask npmInstallTask, boolean reset) throws Exception {
        Logger logger = npmInstallTask.getLogger();
        Project project = npmInstallTask.getProject();
        String digest = NpmInstallTask._getNodeModulesCacheDigest(npmInstallTask);
        File nodeModulesCacheDir = new File(npmInstallTask.getNodeModulesCacheDir(), digest);
        File nodeModulesDir = npmInstallTask.getNodeModulesDir();
        boolean nativeSync = npmInstallTask.isNodeModulesCacheNativeSync();
        boolean removeBinDirs = npmInstallTask.isNodeModulesCacheRemoveBinDirs();
        if (reset) {
            project.delete(new Object[]{nodeModulesCacheDir});
        }
        if (nodeModulesCacheDir.exists()) {
            if (logger.isLifecycleEnabled()) {
                logger.lifecycle("Restoring node_modules of {} from {}", new Object[]{project, nodeModulesCacheDir});
            }
            FileUtil.syncDir(project, nodeModulesCacheDir, nodeModulesDir, nativeSync);
            if (removeBinDirs) {
                FileUtil.removeDirs(project, nodeModulesDir, _NODE_MODULES_BIN_DIR_NAME);
            }
        } else {
            npmInstallTask._npmInstall(reset);
            if (removeBinDirs) {
                FileUtil.removeDirs(project, nodeModulesDir, _NODE_MODULES_BIN_DIR_NAME);
            }
            if (logger.isLifecycleEnabled()) {
                logger.lifecycle("Caching node_modules of {} in {}", new Object[]{project, nodeModulesCacheDir});
            }
            FileUtil.syncDir(project, nodeModulesDir, nodeModulesCacheDir, nativeSync);
        }
    }

    private boolean _isCacheEnabled() {
        Project project = this.getProject();
        PluginContainer pluginContainer = project.getPlugins();
        return !pluginContainer.hasPlugin("com.liferay.cache") && this.getNodeModulesCacheDir() != null;
    }

    private void _npmInstall(boolean reset) throws Exception {
        Logger logger = this.getLogger();
        int npmInstallRetries = this.getNpmInstallRetries();
        Project project = this.getProject();
        for (int i = 0; i < npmInstallRetries + 1; ++i) {
            if (reset || i > 0) {
                project.delete(new Object[]{this.getNodeModulesDir()});
            }
            try {
                super.executeNode();
                break;
            }
            catch (IOException ioe) {
                if (i == npmInstallRetries) {
                    throw ioe;
                }
                if (!logger.isWarnEnabled()) continue;
                logger.warn(ioe.getMessage() + ". Running \"npm install\" again");
                continue;
            }
        }
    }

    private void _removeShrinkwrappedUrls() throws IOException {
        File shrinkwrapJsonFile = this.getShrinkwrapJsonFile();
        Path shrinkwrapJsonPath = shrinkwrapJsonFile.toPath();
        String json = new String(Files.readAllBytes(shrinkwrapJsonPath), StandardCharsets.UTF_8);
        json = json.replaceAll("\\s+\"(?:from|resolved)\": \"http.+\",*\\r*\\n", "");
        Files.write(shrinkwrapJsonPath, json.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
    }
}

