/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.gradle.plugins.node.tasks;

import com.liferay.gradle.plugins.node.internal.util.FileUtil;
import com.liferay.gradle.plugins.node.internal.util.GradleUtil;
import com.liferay.gradle.plugins.node.tasks.ExecuteNodeScriptTask;
import com.liferay.gradle.util.Validator;
import java.io.File;
import java.util.List;
import java.util.concurrent.Callable;
import org.gradle.api.Project;
import org.gradle.api.logging.Logger;

public class ExecuteNpmTask
extends ExecuteNodeScriptTask {
    private Object _cacheDir;
    private boolean _progress = true;
    private Object _registry;

    public ExecuteNpmTask() {
        this.setCacheDir(new Callable<File>(){

            @Override
            public File call() throws Exception {
                File nodeDir = ExecuteNpmTask.this.getNodeDir();
                if (nodeDir == null) {
                    return null;
                }
                return new File(ExecuteNpmTask.this.getNodeDir(), ".cache");
            }
        });
        this.setCommand(new Callable<String>(){

            @Override
            public String call() throws Exception {
                if (ExecuteNpmTask.this.getNodeDir() == null) {
                    return "npm";
                }
                return "node";
            }
        });
        this.setScriptFile(new Callable<File>(){

            @Override
            public File call() throws Exception {
                File nodeDir = ExecuteNpmTask.this.getNodeDir();
                if (nodeDir == null) {
                    return null;
                }
                return new File(ExecuteNpmTask.this.getNodeDir(), "lib/node_modules/npm/bin/npm-cli.js");
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void executeNode() throws Exception {
        Project project = this.getProject();
        File cacheDir = this.getCacheDir();
        if (cacheDir != null && FileUtil.isChild((File)cacheDir, (File)project.getProjectDir())) {
            super.executeNode();
            return;
        }
        Class<ExecuteNpmTask> clazz = ExecuteNpmTask.class;
        synchronized (ExecuteNpmTask.class) {
            super.executeNode();
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    public File getCacheDir() {
        return GradleUtil.toFile(this.getProject(), this._cacheDir);
    }

    public String getRegistry() {
        return GradleUtil.toString((Object)this._registry);
    }

    public boolean isProgress() {
        return this._progress;
    }

    public void setCacheDir(Object cacheDir) {
        this._cacheDir = cacheDir;
    }

    public void setProgress(boolean progress) {
        this._progress = progress;
    }

    public void setRegistry(Object registry) {
        this._registry = registry;
    }

    @Override
    protected List<String> getCompleteArgs() {
        List<String> completeArgs = super.getCompleteArgs();
        File cacheDir = this.getCacheDir();
        if (cacheDir != null) {
            completeArgs.add("--cache");
            completeArgs.add(FileUtil.getAbsolutePath((File)cacheDir));
        }
        String logLevel = null;
        Logger logger = this.getLogger();
        if (logger.isTraceEnabled()) {
            logLevel = "silly";
        } else if (logger.isDebugEnabled()) {
            logLevel = "verbose";
        } else if (logger.isInfoEnabled()) {
            logLevel = "info";
        } else if (logger.isWarnEnabled()) {
            logLevel = "warn";
        } else if (logger.isErrorEnabled()) {
            logLevel = "error";
        }
        if (logLevel != null) {
            completeArgs.add("--loglevel");
            completeArgs.add(logLevel);
        }
        completeArgs.add("--progress");
        completeArgs.add(Boolean.toString(this.isProgress()));
        String registry = this.getRegistry();
        if (Validator.isNotNull((String)registry)) {
            completeArgs.add("--registry");
            completeArgs.add(registry);
        }
        return completeArgs;
    }
}

