/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.gradle.plugins.lang.builder;

import com.liferay.gradle.plugins.lang.builder.BuildLangTask;
import com.liferay.gradle.util.GradleUtil;
import java.io.File;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.Callable;
import org.gradle.api.Action;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.SourceDirectorySet;
import org.gradle.api.plugins.JavaPlugin;
import org.gradle.api.plugins.PluginContainer;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.TaskContainer;

public class LangBuilderPlugin
implements Plugin<Project> {
    public static final String BUILD_LANG_TASK_NAME = "buildLang";
    public static final String CONFIGURATION_NAME = "langBuilder";

    public void apply(Project project) {
        Configuration langBuilderConfiguration = this.addConfigurationLangBuilder(project);
        this.addTaskBuildLang(project);
        this.configureTasksBuildLang(project, langBuilderConfiguration);
    }

    protected Configuration addConfigurationLangBuilder(final Project project) {
        Configuration configuration = GradleUtil.addConfiguration((Project)project, (String)CONFIGURATION_NAME);
        configuration.setDescription("Configures Liferay Lang Builder for this project.");
        configuration.setVisible(false);
        GradleUtil.executeIfEmpty((Configuration)configuration, (Action)new Action<Configuration>(){

            public void execute(Configuration configuration) {
                LangBuilderPlugin.this.addDependenciesLangBuilder(project);
            }
        });
        return configuration;
    }

    protected void addDependenciesLangBuilder(Project project) {
        GradleUtil.addDependency((Project)project, (String)CONFIGURATION_NAME, (String)"com.liferay", (String)"com.liferay.lang.builder", (String)"latest.release");
    }

    protected BuildLangTask addTaskBuildLang(Project project) {
        final BuildLangTask buildLangTask = (BuildLangTask)GradleUtil.addTask((Project)project, (String)BUILD_LANG_TASK_NAME, BuildLangTask.class);
        buildLangTask.setDescription("Runs Liferay Lang Builder to translate language property files.");
        buildLangTask.setGroup("build");
        PluginContainer pluginContainer = project.getPlugins();
        pluginContainer.withType(JavaPlugin.class, (Action)new Action<JavaPlugin>(){

            public void execute(JavaPlugin javaPlugin) {
                LangBuilderPlugin.this.configureTaskBuildLangForJavaPlugin(buildLangTask);
            }
        });
        return buildLangTask;
    }

    protected void configureTaskBuildLangClasspath(BuildLangTask buildLangTask, FileCollection fileCollection) {
        buildLangTask.setClasspath(fileCollection);
    }

    protected void configureTaskBuildLangForJavaPlugin(final BuildLangTask buildLangTask) {
        buildLangTask.setLangDir(new Callable<File>(){

            @Override
            public File call() throws Exception {
                return new File(LangBuilderPlugin.this.getResourcesDir(buildLangTask.getProject()), "content");
            }
        });
    }

    protected void configureTasksBuildLang(Project project, final Configuration langBuilderConfiguration) {
        TaskContainer taskContainer = project.getTasks();
        taskContainer.withType(BuildLangTask.class, (Action)new Action<BuildLangTask>(){

            public void execute(BuildLangTask buildLangTask) {
                LangBuilderPlugin.this.configureTaskBuildLangClasspath(buildLangTask, (FileCollection)langBuilderConfiguration);
            }
        });
    }

    protected File getResourcesDir(Project project) {
        SourceSet sourceSet = GradleUtil.getSourceSet((Project)project, (String)"main");
        return this.getSrcDir(sourceSet.getResources());
    }

    protected File getSrcDir(SourceDirectorySet sourceDirectorySet) {
        Set srcDirs = sourceDirectorySet.getSrcDirs();
        Iterator iterator = srcDirs.iterator();
        return (File)iterator.next();
    }
}

