/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.gradle.plugins.js.module.config.generator;

import com.liferay.gradle.plugins.node.tasks.ExecuteNodeScriptTask;
import com.liferay.gradle.util.FileUtil;
import com.liferay.gradle.util.GradleUtil;
import com.liferay.gradle.util.Validator;
import groovy.lang.Closure;
import java.io.File;
import java.util.List;
import java.util.Set;
import org.gradle.api.Action;
import org.gradle.api.Project;
import org.gradle.api.file.ConfigurableFileTree;
import org.gradle.api.file.CopySpec;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.FileTreeElement;
import org.gradle.api.specs.Spec;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.SkipWhenEmpty;
import org.gradle.api.tasks.util.PatternFilterable;
import org.gradle.api.tasks.util.PatternSet;

@Deprecated
public class ConfigJSModulesTask
extends ExecuteNodeScriptTask
implements PatternFilterable {
    private Object _configVariable;
    private Object _customDefine = "Liferay.Loader";
    private boolean _ignorePath;
    private boolean _keepFileExtension;
    private boolean _lowerCase;
    private Object _moduleConfigFile;
    private Object _moduleExtension;
    private Object _moduleFormat;
    private Object _outputFile;
    private final PatternFilterable _patternFilterable = new PatternSet();
    private Object _sourceDir;

    public ConfigJSModulesTask() {
        this.include("**/*.es.js*", "**/*.soy.js*");
    }

    public ConfigJSModulesTask exclude(Closure excludeSpec) {
        this._patternFilterable.exclude(excludeSpec);
        return this;
    }

    public ConfigJSModulesTask exclude(Iterable<String> excludes) {
        this._patternFilterable.exclude(excludes);
        return this;
    }

    public ConfigJSModulesTask exclude(Spec<FileTreeElement> excludeSpec) {
        this._patternFilterable.exclude(excludeSpec);
        return this;
    }

    public ConfigJSModulesTask exclude(String ... excludes) {
        this._patternFilterable.exclude(excludes);
        return this;
    }

    public void executeNode() throws Exception {
        Project project = this.getProject();
        final File outputDir = this.getOutputDir();
        project.delete(new Object[]{this.getOutputFile(), outputDir});
        project.copy((Action)new Action<CopySpec>(){

            public void execute(CopySpec copySpec) {
                copySpec.from(new Object[]{ConfigJSModulesTask.this.getSourceFiles()});
                copySpec.into((Object)outputDir);
            }
        });
        super.executeNode();
        project.copy((Action)new Action<CopySpec>(){

            public void execute(CopySpec copySpec) {
                copySpec.from(new Object[]{outputDir});
                copySpec.into((Object)ConfigJSModulesTask.this.getSourceDir());
            }
        });
    }

    @Input
    @Optional
    public String getConfigVariable() {
        return GradleUtil.toString((Object)this._configVariable);
    }

    @Input
    @Optional
    public String getCustomDefine() {
        return GradleUtil.toString((Object)this._customDefine);
    }

    public Set<String> getExcludes() {
        return this._patternFilterable.getExcludes();
    }

    public Set<String> getIncludes() {
        return this._patternFilterable.getIncludes();
    }

    @InputFile
    @Optional
    public File getModuleConfigFile() {
        return GradleUtil.toFile((Project)this.getProject(), (Object)this._moduleConfigFile);
    }

    @Input
    @Optional
    public String getModuleExtension() {
        return GradleUtil.toString((Object)this._moduleExtension);
    }

    @Input
    @Optional
    public String getModuleFormat() {
        return GradleUtil.toString((Object)this._moduleFormat);
    }

    public File getOutputDir() {
        return new File(this.getTemporaryDir(), "files");
    }

    public File getOutputFile() {
        return GradleUtil.toFile((Project)this.getProject(), (Object)this._outputFile);
    }

    @Input
    public File getSourceDir() {
        return GradleUtil.toFile((Project)this.getProject(), (Object)this._sourceDir);
    }

    @InputFiles
    @SkipWhenEmpty
    public FileCollection getSourceFiles() {
        Project project = this.getProject();
        File sourceDir = this.getSourceDir();
        if (sourceDir == null) {
            return project.files(new Object[0]);
        }
        ConfigurableFileTree fileTree = project.fileTree((Object)sourceDir);
        return fileTree.matching(this._patternFilterable);
    }

    public ConfigJSModulesTask include(Closure includeSpec) {
        this._patternFilterable.include(includeSpec);
        return this;
    }

    public ConfigJSModulesTask include(Iterable<String> includes) {
        this._patternFilterable.include(includes);
        return this;
    }

    public ConfigJSModulesTask include(Spec<FileTreeElement> includeSpec) {
        this._patternFilterable.include(includeSpec);
        return this;
    }

    public ConfigJSModulesTask include(String ... includes) {
        this._patternFilterable.include(includes);
        return this;
    }

    @Input
    public boolean isIgnorePath() {
        return this._ignorePath;
    }

    @Input
    public boolean isKeepFileExtension() {
        return this._keepFileExtension;
    }

    @Input
    public boolean isLowerCase() {
        return this._lowerCase;
    }

    public void setConfigVariable(Object configVariable) {
        this._configVariable = configVariable;
    }

    public void setCustomDefine(Object customDefine) {
        this._customDefine = customDefine;
    }

    public ConfigJSModulesTask setExcludes(Iterable<String> excludes) {
        this._patternFilterable.setExcludes(excludes);
        return this;
    }

    public void setIgnorePath(boolean ignorePath) {
        this._ignorePath = ignorePath;
    }

    public ConfigJSModulesTask setIncludes(Iterable<String> includes) {
        this._patternFilterable.setIncludes(includes);
        return this;
    }

    public void setKeepFileExtension(boolean keepFileExtension) {
        this._keepFileExtension = keepFileExtension;
    }

    public void setLowerCase(boolean lowerCase) {
        this._lowerCase = lowerCase;
    }

    public void setModuleConfigFile(Object moduleConfigFile) {
        this._moduleConfigFile = moduleConfigFile;
    }

    public void setModuleExtension(Object moduleExtension) {
        this._moduleExtension = moduleExtension;
    }

    public void setModuleFormat(Object moduleFormat) {
        this._moduleFormat = moduleFormat;
    }

    public void setOutputFile(Object outputFile) {
        this._outputFile = outputFile;
    }

    public void setSourceDir(Object sourceDir) {
        this._sourceDir = sourceDir;
    }

    protected List<String> getCompleteArgs() {
        boolean lowerCase;
        boolean keepFileExtension;
        boolean ignorePath;
        String moduleFormat;
        String moduleExtension;
        List completeArgs = super.getCompleteArgs();
        String configVariable = this.getConfigVariable();
        if (configVariable != null) {
            completeArgs.add("--config");
            completeArgs.add(configVariable);
        }
        if ((moduleExtension = this.getModuleExtension()) != null) {
            completeArgs.add("--extension");
            completeArgs.add(moduleExtension);
        }
        if ((moduleFormat = this.getModuleFormat()) != null) {
            completeArgs.add("--format");
            completeArgs.add(moduleFormat);
        }
        if (ignorePath = this.isIgnorePath()) {
            completeArgs.add("--ignorePath");
            completeArgs.add(String.valueOf(ignorePath));
        }
        if (keepFileExtension = this.isKeepFileExtension()) {
            completeArgs.add("--keepExtension");
            completeArgs.add(String.valueOf(keepFileExtension));
        }
        if (lowerCase = this.isLowerCase()) {
            completeArgs.add("--lowerCase");
            completeArgs.add(String.valueOf(lowerCase));
        }
        completeArgs.add("--moduleConfig");
        completeArgs.add(FileUtil.getAbsolutePath((File)this.getModuleConfigFile()));
        String customDefine = this.getCustomDefine();
        if (Validator.isNotNull((String)customDefine)) {
            completeArgs.add("--namespace");
            completeArgs.add(customDefine);
        }
        completeArgs.add("--output");
        completeArgs.add(FileUtil.getAbsolutePath((File)this.getOutputFile()));
        File outputDir = this.getOutputDir();
        completeArgs.add("--moduleRoot");
        completeArgs.add(FileUtil.getAbsolutePath((File)outputDir));
        completeArgs.add(FileUtil.getAbsolutePath((File)outputDir.getParentFile()));
        return completeArgs;
    }
}

