/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.gradle.plugins.js.module.config.generator;

import com.liferay.gradle.plugins.node.tasks.ExecuteNodeTask;
import com.liferay.gradle.util.FileUtil;
import com.liferay.gradle.util.GradleUtil;
import groovy.lang.Closure;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.gradle.api.Action;
import org.gradle.api.Project;
import org.gradle.api.file.ConfigurableFileTree;
import org.gradle.api.file.CopySpec;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.FileTreeElement;
import org.gradle.api.specs.Spec;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.SkipWhenEmpty;
import org.gradle.api.tasks.util.PatternFilterable;
import org.gradle.api.tasks.util.PatternSet;
import org.gradle.util.GUtil;

public class ConfigJSModulesTask
extends ExecuteNodeTask {
    private Object _configVariable;
    private boolean _ignorePath;
    private boolean _keepFileExtension;
    private boolean _lowerCase;
    private Object _moduleConfigFile;
    private Object _moduleExtension;
    private Object _moduleFormat;
    private Object _outputFile;
    private final PatternFilterable _patternFilterable = new PatternSet();
    private Object _sourceDir;

    public ConfigJSModulesTask() {
        this.dependsOn(new Object[]{"downloadLfrModuleConfigGenerator"});
        this.include("**/*.es.js");
    }

    public ConfigJSModulesTask exclude(Closure<?> closure) {
        this._patternFilterable.exclude(closure);
        return this;
    }

    public ConfigJSModulesTask exclude(Iterable<String> excludes) {
        this._patternFilterable.exclude(excludes);
        return this;
    }

    public ConfigJSModulesTask exclude(Spec<FileTreeElement> spec) {
        this._patternFilterable.exclude(spec);
        return this;
    }

    public ConfigJSModulesTask exclude(String ... excludes) {
        this._patternFilterable.exclude(excludes);
        return this;
    }

    public void executeNode() {
        Project project = this.getProject();
        final File outputDir = this.getOutputDir();
        project.delete(new Object[]{this.getOutputFile(), outputDir});
        project.copy((Action)new Action<CopySpec>(){

            public void execute(CopySpec copySpec) {
                copySpec.from(new Object[]{ConfigJSModulesTask.this.getSourceFiles()});
                copySpec.into((Object)outputDir);
            }
        });
        this.setArgs(this.getCompleteArgs());
        super.executeNode();
        project.copy((Action)new Action<CopySpec>(){

            public void execute(CopySpec copySpec) {
                copySpec.from(new Object[]{outputDir});
                copySpec.into((Object)ConfigJSModulesTask.this.getSourceDir());
            }
        });
    }

    @Input
    @Optional
    public String getConfigVariable() {
        return GradleUtil.toString((Object)this._configVariable);
    }

    public Set<String> getExcludes() {
        return this._patternFilterable.getExcludes();
    }

    public Set<String> getIncludes() {
        return this._patternFilterable.getIncludes();
    }

    @InputFile
    @Optional
    public File getModuleConfigFile() {
        return GradleUtil.toFile((Project)this.getProject(), (Object)this._moduleConfigFile);
    }

    @Input
    @Optional
    public String getModuleExtension() {
        return GradleUtil.toString((Object)this._moduleExtension);
    }

    @Input
    @Optional
    public String getModuleFormat() {
        return GradleUtil.toString((Object)this._moduleFormat);
    }

    @OutputDirectory
    public File getOutputDir() {
        return new File(this.getTemporaryDir(), "files");
    }

    @OutputFile
    public File getOutputFile() {
        return GradleUtil.toFile((Project)this.getProject(), (Object)this._outputFile);
    }

    public File getSourceDir() {
        return GradleUtil.toFile((Project)this.getProject(), (Object)this._sourceDir);
    }

    @InputFiles
    @SkipWhenEmpty
    public FileCollection getSourceFiles() {
        Project project = this.getProject();
        if (this._sourceDir == null) {
            return project.files(new Object[0]);
        }
        ConfigurableFileTree fileTree = project.fileTree(this._sourceDir);
        return fileTree.matching(this._patternFilterable);
    }

    public ConfigJSModulesTask include(Closure<?> closure) {
        this._patternFilterable.include(closure);
        return this;
    }

    public ConfigJSModulesTask include(Iterable<String> includes) {
        this._patternFilterable.include(includes);
        return this;
    }

    public ConfigJSModulesTask include(Spec<FileTreeElement> spec) {
        this._patternFilterable.include(spec);
        return this;
    }

    public ConfigJSModulesTask include(String ... includes) {
        this._patternFilterable.include(includes);
        return this;
    }

    @Input
    public boolean isIgnorePath() {
        return this._ignorePath;
    }

    @Input
    public boolean isKeepFileExtension() {
        return this._keepFileExtension;
    }

    @Input
    public boolean isLowerCase() {
        return this._lowerCase;
    }

    public void setConfigVariable(Object configVariable) {
        this._configVariable = configVariable;
    }

    public ConfigJSModulesTask setExcludes(Iterable<String> excludes) {
        this._patternFilterable.setExcludes(excludes);
        return this;
    }

    public void setIgnorePath(boolean ignorePath) {
        this._ignorePath = ignorePath;
    }

    public ConfigJSModulesTask setIncludes(Iterable<String> includes) {
        this._patternFilterable.setIncludes(includes);
        return this;
    }

    public void setKeepFileExtension(boolean keepFileExtension) {
        this._keepFileExtension = keepFileExtension;
    }

    public void setLowerCase(boolean lowerCase) {
        this._lowerCase = lowerCase;
    }

    public void setModuleConfigFile(Object moduleConfigFile) {
        this._moduleConfigFile = moduleConfigFile;
    }

    public void setModuleExtension(Object moduleExtension) {
        this._moduleExtension = moduleExtension;
    }

    public void setModuleFormat(Object moduleFormat) {
        this._moduleFormat = moduleFormat;
    }

    public void setOutputFile(Object outputFile) {
        this._outputFile = outputFile;
    }

    public void setSourceDir(Object sourceDir) {
        this._sourceDir = sourceDir;
    }

    protected List<Object> getCompleteArgs() {
        boolean lowerCase;
        boolean keepFileExtension;
        boolean ignorePath;
        String moduleFormat;
        String moduleExtension;
        ArrayList<Object> completeArgs = new ArrayList<Object>();
        File scriptFile = new File(this.getNodeDir(), "node_modules/lfr-module-config-generator/bin/index.js");
        completeArgs.add(FileUtil.getAbsolutePath((File)scriptFile));
        GUtil.addToCollection(completeArgs, (Iterable[])new Iterable[]{this.getArgs()});
        String configVariable = this.getConfigVariable();
        if (configVariable != null) {
            completeArgs.add("--config");
            completeArgs.add(configVariable);
        }
        if ((moduleExtension = this.getModuleExtension()) != null) {
            completeArgs.add("--extension");
            completeArgs.add(moduleExtension);
        }
        if ((moduleFormat = this.getModuleFormat()) != null) {
            completeArgs.add("--format");
            completeArgs.add(moduleFormat);
        }
        if (ignorePath = this.isIgnorePath()) {
            completeArgs.add("--ignorePath");
            completeArgs.add(ignorePath);
        }
        if (keepFileExtension = this.isKeepFileExtension()) {
            completeArgs.add("--keepExtension");
            completeArgs.add(keepFileExtension);
        }
        if (lowerCase = this.isLowerCase()) {
            completeArgs.add("--lowerCase");
            completeArgs.add(lowerCase);
        }
        completeArgs.add("--moduleConfig");
        completeArgs.add(FileUtil.getAbsolutePath((File)this.getModuleConfigFile()));
        completeArgs.add("--output");
        completeArgs.add(FileUtil.getAbsolutePath((File)this.getOutputFile()));
        File outputDir = this.getOutputDir();
        completeArgs.add("--moduleRoot");
        completeArgs.add(FileUtil.getAbsolutePath((File)outputDir));
        completeArgs.add(FileUtil.getAbsolutePath((File)outputDir.getParentFile()));
        return completeArgs;
    }
}

