/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.gradle.plugins.dependency.checker;

import com.liferay.gradle.plugins.dependency.checker.DependencyCheckerException;
import com.liferay.gradle.plugins.dependency.checker.internal.DependencyChecker;
import com.liferay.gradle.plugins.dependency.checker.internal.DependencyKey;
import com.liferay.gradle.plugins.dependency.checker.internal.MaxAgeDependencyCheckerImpl;
import com.liferay.gradle.util.GradleUtil;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.gradle.StartParameter;
import org.gradle.api.GradleException;
import org.gradle.api.Project;
import org.gradle.api.UncheckedIOException;
import org.gradle.api.invocation.Gradle;
import org.gradle.api.logging.Logger;
import org.gradle.api.plugins.ExtensionAware;
import org.gradle.util.ConfigureUtil;

public class DependencyCheckerExtension {
    private static final Collection<String> _dependencyKeyMandatoryKeys = Arrays.asList("configuration", "group", "name");
    private final Map<DependencyKey, DependencyChecker> _dependencyCheckers = new HashMap<DependencyKey, DependencyChecker>();
    private boolean _ignoreFailures;
    private final Project _project;

    public DependencyCheckerExtension(Project project) {
        this._ignoreFailures = GradleUtil.getProperty((ExtensionAware)project, (String)"dependencyCheckerIgnoreFailures", (boolean)true);
        this._project = project;
    }

    public void check(String configuration, String group, String name, String version) {
        Gradle gradle = this._project.getGradle();
        Logger logger = this._project.getLogger();
        StartParameter startParameter = gradle.getStartParameter();
        if (startParameter.isOffline()) {
            if (logger.isWarnEnabled()) {
                logger.warn("Build is offline, dependency check disabled");
            }
            return;
        }
        DependencyKey dependencyKey = new DependencyKey();
        dependencyKey.setConfiguration(configuration);
        dependencyKey.setGroup(group);
        dependencyKey.setName(name);
        DependencyChecker dependencyChecker = this._dependencyCheckers.get(dependencyKey);
        if (dependencyChecker == null) {
            if (logger.isDebugEnabled()) {
                logger.debug("No dependency checkers are defined for \"{}:{}:{}\" in configuration \"{}\"", new Object[]{group, name, version, configuration});
            }
            return;
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Checking dependency \"{}:{}:{}\" in configuration \"{}\"", new Object[]{group, name, version, configuration});
        }
        try {
            dependencyChecker.check(group, name, version);
        }
        catch (Exception exception) {
            if (!this.isIgnoreFailures()) {
                if (exception instanceof IOException) {
                    throw new UncheckedIOException((Throwable)exception);
                }
                if (exception instanceof RuntimeException) {
                    throw (RuntimeException)exception;
                }
                throw new GradleException(exception.getMessage(), (Throwable)exception);
            }
            if (exception instanceof DependencyCheckerException) {
                System.out.println(exception.getMessage());
            }
            logger.error("Unable to check dependency '" + group + ":" + name + ":" + version + "' in configuration '" + configuration + "'", (Throwable)exception);
        }
    }

    public boolean isIgnoreFailures() {
        return this._ignoreFailures;
    }

    public void maxAge(Map<?, ?> args) {
        this._add(new MaxAgeDependencyCheckerImpl(this._project.getLogger()), args, "maxAge", "throwError");
    }

    public void setIgnoreFailures(boolean ignoreFailures) {
        this._ignoreFailures = ignoreFailures;
    }

    private DependencyChecker _add(DependencyChecker dependencyChecker, Map<?, ?> args, String ... mandatoryKeys) {
        Map<Object, Object> dependencyKeyArgs = this._extractArgs(args, _dependencyKeyMandatoryKeys);
        DependencyKey dependencyKey = (DependencyKey)ConfigureUtil.configureByMap(dependencyKeyArgs, (Object)new DependencyKey(), _dependencyKeyMandatoryKeys);
        dependencyChecker = (DependencyChecker)ConfigureUtil.configureByMap(args, (Object)dependencyChecker, Arrays.asList(mandatoryKeys));
        this._dependencyCheckers.put(dependencyKey, dependencyChecker);
        return dependencyChecker;
    }

    private Map<Object, Object> _extractArgs(Map<?, ?> args, Collection<?> keys) {
        HashMap<Object, Object> extractedArgs = new HashMap<Object, Object>();
        for (Object key : keys) {
            if (!args.containsKey(key)) continue;
            Object value = args.remove(key);
            extractedArgs.put(key, value);
        }
        return extractedArgs;
    }
}

