/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.gradle.plugins.db.support;

import com.liferay.gradle.plugins.db.support.internal.util.GradleUtil;
import com.liferay.gradle.plugins.db.support.tasks.BaseDBSupportTask;
import com.liferay.gradle.plugins.db.support.tasks.CleanServiceBuilderTask;
import com.liferay.gradle.util.OSGiUtil;
import java.util.concurrent.Callable;
import org.gradle.api.Action;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.DependencySet;
import org.gradle.api.file.FileCollection;
import org.gradle.api.plugins.BasePlugin;
import org.gradle.api.plugins.PluginContainer;
import org.gradle.api.tasks.TaskContainer;

public class DBSupportPlugin
implements Plugin<Project> {
    public static final String CLEAN_SERVICE_BUILDER_TASK_NAME = "cleanServiceBuilder";
    public static final String CONFIGURATION_NAME = "dbSupport";
    public static final String TOOL_CONFIGURATION_NAME = "dbSupportTool";

    public void apply(Project project) {
        Configuration dbSupportConfiguration = this._addConfigurationDBSupport(project);
        Configuration dbSupportToolConfiguration = this._addConfigurationDBSupportTool(project);
        this._addTaskCleanServiceBuilder(project);
        this._configureTasksBaseDBSupport(project, (FileCollection)project.files(new Object[]{dbSupportConfiguration, dbSupportToolConfiguration}));
    }

    private Configuration _addConfigurationDBSupport(Project project) {
        Configuration configuration = GradleUtil.addConfiguration((Project)project, (String)CONFIGURATION_NAME);
        configuration.setDescription("Configures the additional classpath of the DB Support tasks.");
        configuration.setVisible(false);
        return configuration;
    }

    private Configuration _addConfigurationDBSupportTool(final Project project) {
        Configuration configuration = GradleUtil.addConfiguration((Project)project, (String)TOOL_CONFIGURATION_NAME);
        configuration.defaultDependencies((Action)new Action<DependencySet>(){

            public void execute(DependencySet dependencySet) {
                DBSupportPlugin.this._addDependenciesDBSupportTool(project);
            }
        });
        configuration.setDescription("Configures Liferay DB Support for this project.");
        configuration.setVisible(false);
        return configuration;
    }

    private void _addDependenciesDBSupportTool(Project project) {
        GradleUtil.addDependency((Project)project, (String)TOOL_CONFIGURATION_NAME, (String)"com.liferay", (String)"com.liferay.portal.tools.db.support", (String)"latest.release");
    }

    private CleanServiceBuilderTask _addTaskCleanServiceBuilder(final Project project) {
        CleanServiceBuilderTask cleanServiceBuilderTask = (CleanServiceBuilderTask)GradleUtil.addTask((Project)project, (String)CLEAN_SERVICE_BUILDER_TASK_NAME, CleanServiceBuilderTask.class);
        cleanServiceBuilderTask.setDescription("Cleans the Liferay database from the Service Builder tables and rows of a module.");
        cleanServiceBuilderTask.setGroup("build");
        cleanServiceBuilderTask.setServletContextName(new Callable<String>(){

            @Override
            public String call() throws Exception {
                PluginContainer pluginContainer = project.getPlugins();
                if (pluginContainer.hasPlugin(BasePlugin.class)) {
                    return OSGiUtil.getBundleSymbolicName((Project)project);
                }
                return null;
            }
        });
        cleanServiceBuilderTask.setServiceXmlFile("service.xml");
        return cleanServiceBuilderTask;
    }

    private void _configureTasksBaseDBSupport(Project project, final FileCollection classpath) {
        TaskContainer taskContainer = project.getTasks();
        taskContainer.withType(BaseDBSupportTask.class, (Action)new Action<BaseDBSupportTask>(){

            public void execute(BaseDBSupportTask baseDBSupportTask) {
                baseDBSupportTask.setClasspath(classpath);
            }
        });
    }
}

