/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.gradle.plugins.css.builder;

import com.liferay.gradle.plugins.css.builder.BuildCSSTask;
import com.liferay.gradle.util.GradleUtil;
import com.liferay.gradle.util.copy.StripPathSegmentsAction;
import groovy.lang.Closure;
import java.io.File;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.Callable;
import org.gradle.api.Action;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.FileTree;
import org.gradle.api.file.SourceDirectorySet;
import org.gradle.api.plugins.JavaPlugin;
import org.gradle.api.plugins.PluginContainer;
import org.gradle.api.plugins.WarPlugin;
import org.gradle.api.plugins.WarPluginConvention;
import org.gradle.api.tasks.Copy;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.TaskContainer;

public class CSSBuilderPlugin
implements Plugin<Project> {
    public static final String BUILD_CSS_TASK_NAME = "buildCSS";
    public static final String CSS_BUILDER_CONFIGURATION_NAME = "cssBuilder";
    public static final String EXPAND_PORTAL_COMMON_CSS_TASK_NAME = "expandPortalCommonCSS";
    public static final String PORTAL_COMMON_CSS_CONFIGURATION_NAME = "portalCommonCSS";

    public void apply(Project project) {
        Configuration cssBuilderConfiguration = this.addConfigurationCSSBuilder(project);
        Configuration portalCommonCSSConfiguration = this.addConfigurationPortalCommonCSS(project);
        this.addTaskBuildCSS(project);
        Copy expandPortalCommonCSSTask = this.addTaskExpandPortalCommonCSS(project, portalCommonCSSConfiguration);
        this.configureTasksBuildCSS(project, cssBuilderConfiguration, expandPortalCommonCSSTask);
    }

    protected Configuration addConfigurationCSSBuilder(final Project project) {
        Configuration configuration = GradleUtil.addConfiguration((Project)project, (String)CSS_BUILDER_CONFIGURATION_NAME);
        configuration.setDescription("Configures Liferay CSS Builder for this project.");
        configuration.setVisible(false);
        GradleUtil.executeIfEmpty((Configuration)configuration, (Action)new Action<Configuration>(){

            public void execute(Configuration configuration) {
                CSSBuilderPlugin.this.addDependenciesCSSBuilder(project);
            }
        });
        return configuration;
    }

    protected Configuration addConfigurationPortalCommonCSS(final Project project) {
        Configuration configuration = GradleUtil.addConfiguration((Project)project, (String)PORTAL_COMMON_CSS_CONFIGURATION_NAME);
        configuration.setDescription("Configures com.liferay.frontend.common.css for compiling CSS files.");
        configuration.setTransitive(false);
        configuration.setVisible(false);
        GradleUtil.executeIfEmpty((Configuration)configuration, (Action)new Action<Configuration>(){

            public void execute(Configuration configuration) {
                CSSBuilderPlugin.this.addDependenciesPortalCommonCSS(project);
            }
        });
        return configuration;
    }

    protected void addDependenciesCSSBuilder(Project project) {
        GradleUtil.addDependency((Project)project, (String)CSS_BUILDER_CONFIGURATION_NAME, (String)"com.liferay", (String)"com.liferay.css.builder", (String)"latest.release");
    }

    protected void addDependenciesPortalCommonCSS(Project project) {
        GradleUtil.addDependency((Project)project, (String)PORTAL_COMMON_CSS_CONFIGURATION_NAME, (String)"com.liferay", (String)"com.liferay.frontend.common.css", (String)"latest.release", (boolean)false);
    }

    protected BuildCSSTask addTaskBuildCSS(Project project) {
        final BuildCSSTask buildCSSTask = (BuildCSSTask)GradleUtil.addTask((Project)project, (String)BUILD_CSS_TASK_NAME, BuildCSSTask.class);
        buildCSSTask.setDescription("Build CSS files.");
        buildCSSTask.setGroup("build");
        PluginContainer pluginContainer = project.getPlugins();
        pluginContainer.withType(JavaPlugin.class, (Action)new Action<JavaPlugin>(){

            public void execute(JavaPlugin javaPlugin) {
                CSSBuilderPlugin.this.configureTaskBuildCSSForJavaPlugin(buildCSSTask);
            }
        });
        pluginContainer.withType(WarPlugin.class, (Action)new Action<WarPlugin>(){

            public void execute(WarPlugin warPlugin) {
                CSSBuilderPlugin.this.configureTaskBuildCSSForWarPlugin(buildCSSTask);
            }
        });
        return buildCSSTask;
    }

    protected Copy addTaskExpandPortalCommonCSS(final Project project, final Configuration portalCommonCSSConfiguration) {
        Copy copy = (Copy)GradleUtil.addTask((Project)project, (String)EXPAND_PORTAL_COMMON_CSS_TASK_NAME, Copy.class);
        copy.eachFile((Action)new StripPathSegmentsAction(2));
        Closure<Void> closure = new Closure<Void>(null){

            public FileTree doCall() {
                return project.zipTree((Object)portalCommonCSSConfiguration.getSingleFile());
            }
        };
        copy.from(new Object[]{closure});
        copy.include(new String[]{"META-INF/resources/**"});
        copy.into((Object)new File(project.getBuildDir(), "portal-common-css"));
        copy.setIncludeEmptyDirs(false);
        return copy;
    }

    protected void configureTaskBuildCSSClasspath(BuildCSSTask buildCSSTask, Configuration cssBuilderConfiguration) {
        buildCSSTask.setClasspath((FileCollection)cssBuilderConfiguration);
    }

    protected void configureTaskBuildCSSDependsOn(BuildCSSTask buildCSSTask, final Copy expandPortalCommonCSSTask) {
        Closure<Task> closure = new Closure<Task>(null){

            public Task doCall(BuildCSSTask buildCSSTask) {
                FileCollection cssFiles = buildCSSTask.getCSSFiles();
                File portalCommonDir = buildCSSTask.getPortalCommonDir();
                if (!cssFiles.isEmpty() && portalCommonDir.equals(expandPortalCommonCSSTask.getDestinationDir())) {
                    return expandPortalCommonCSSTask;
                }
                return null;
            }
        };
        buildCSSTask.dependsOn(new Object[]{closure});
    }

    protected void configureTaskBuildCSSForJavaPlugin(final BuildCSSTask buildCSSTask) {
        buildCSSTask.setDocrootDir(new Callable<File>(){

            @Override
            public File call() throws Exception {
                return CSSBuilderPlugin.this.getResourcesDir(buildCSSTask.getProject());
            }
        });
        Task processResourcesTask = GradleUtil.getTask((Project)buildCSSTask.getProject(), (String)"processResources");
        processResourcesTask.dependsOn(new Object[]{buildCSSTask});
    }

    protected void configureTaskBuildCSSForWarPlugin(final BuildCSSTask buildCSSTask) {
        buildCSSTask.setDocrootDir(new Callable<File>(){

            @Override
            public File call() throws Exception {
                return CSSBuilderPlugin.this.getWebAppDir(buildCSSTask.getProject());
            }
        });
    }

    protected void configureTaskBuildCSSPortalCommonDir(BuildCSSTask buildCSSTask, final Copy expandPortalCommonCSSTask) {
        buildCSSTask.setPortalCommonDir(new Callable<File>(){

            @Override
            public File call() throws Exception {
                return expandPortalCommonCSSTask.getDestinationDir();
            }
        });
    }

    protected void configureTasksBuildCSS(Project project, final Configuration cssBuilderConfiguration, final Copy expandPortalCommonCSSTask) {
        TaskContainer taskContainer = project.getTasks();
        taskContainer.withType(BuildCSSTask.class, (Action)new Action<BuildCSSTask>(){

            public void execute(BuildCSSTask buildCSSTask) {
                CSSBuilderPlugin.this.configureTaskBuildCSSClasspath(buildCSSTask, cssBuilderConfiguration);
                CSSBuilderPlugin.this.configureTaskBuildCSSDependsOn(buildCSSTask, expandPortalCommonCSSTask);
                CSSBuilderPlugin.this.configureTaskBuildCSSPortalCommonDir(buildCSSTask, expandPortalCommonCSSTask);
            }
        });
    }

    protected File getResourcesDir(Project project) {
        SourceSet sourceSet = GradleUtil.getSourceSet((Project)project, (String)"main");
        return this.getSrcDir(sourceSet.getResources());
    }

    protected File getSrcDir(SourceDirectorySet sourceDirectorySet) {
        Set srcDirs = sourceDirectorySet.getSrcDirs();
        Iterator iterator = srcDirs.iterator();
        return (File)iterator.next();
    }

    protected File getWebAppDir(Project project) {
        WarPluginConvention warPluginConvention = (WarPluginConvention)GradleUtil.getConvention((Project)project, WarPluginConvention.class);
        return warPluginConvention.getWebAppDir();
    }
}

