/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.gradle.plugins.app.docker;

import com.liferay.gradle.plugins.app.docker.internal.util.ExecStandardOutputCallable;
import com.liferay.gradle.util.GUtil;
import com.liferay.gradle.util.GradleUtil;
import groovy.lang.Closure;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import org.gradle.api.Project;
import org.gradle.api.specs.AndSpec;
import org.gradle.api.specs.Spec;
import org.gradle.util.CollectionUtils;

public class AppDockerExtension {
    private Object _imageName;
    private final List<Object> _imageTags = new ArrayList<Object>();
    private Object _imageUser;
    private Object _inputDir;
    private AndSpec<Project> _onlyIfSpec = new AndSpec();
    private final Project _project;
    private final Set<Project> _subprojects;

    public AppDockerExtension(Project project) {
        this._project = project;
        this._imageName = new Callable<String>(){

            @Override
            public String call() throws Exception {
                return AppDockerExtension.this._project.getName();
            }
        };
        this._inputDir = this._project.getName() + "-docker";
        this._imageUser = new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                return AppDockerExtension.this._project.getGroup();
            }
        };
        this._subprojects = CollectionUtils.filter((Set)this._project.getSubprojects(), (Spec)new Spec<Project>(){

            public boolean isSatisfiedBy(Project project) {
                Set subprojects = project.getSubprojects();
                return subprojects.isEmpty();
            }
        });
        this._imageTags.add(new ExecStandardOutputCallable(this._project, Collections.singletonMap("TZ", "UTC"), "git", "show", "--date=format-local:%Y%m%dT%H%M%SZ", "--format=%cd", "--no-patch", "--quiet", "HEAD"));
        this._imageTags.add(new ExecStandardOutputCallable(this._project, "git", "rev-parse", "HEAD"));
    }

    public String getImageName() {
        return GradleUtil.toString((Object)this._imageName);
    }

    public List<Object> getImageTags() {
        return this._imageTags;
    }

    public String getImageUser() {
        return GradleUtil.toString((Object)this._imageUser);
    }

    public File getInputDir() {
        return GradleUtil.toFile((Project)this._project, (Object)this._inputDir);
    }

    public Spec<Project> getOnlyIf() {
        return this._onlyIfSpec;
    }

    public Set<Project> getSubprojects() {
        return this._subprojects;
    }

    public AppDockerExtension imageTags(Iterable<?> imageTags) {
        GUtil.addToCollection(this._imageTags, imageTags);
        return this;
    }

    public AppDockerExtension imageTags(Object ... imageTags) {
        return this.imageTags(Arrays.asList(imageTags));
    }

    public AppDockerExtension onlyIf(Closure<Boolean> onlyIfClosure) {
        this._onlyIfSpec = this._onlyIfSpec.and(onlyIfClosure);
        return this;
    }

    public AppDockerExtension onlyIf(Spec<Project> onlyIfSpec) {
        this._onlyIfSpec = this._onlyIfSpec.and(onlyIfSpec);
        return this;
    }

    public void setImageName(Object imageName) {
        this._imageName = imageName;
    }

    public void setImageTags(Iterable<?> imageTags) {
        this._imageTags.clear();
        this.imageTags(imageTags);
    }

    public void setImageTags(Object ... imageTags) {
        this.setImageTags(Arrays.asList(imageTags));
    }

    public void setImageUser(Object imageUser) {
        this._imageUser = imageUser;
    }

    public void setInputDir(Object inputDir) {
        this._inputDir = inputDir;
    }

    public void setOnlyIf(Closure<Boolean> onlyIfClosure) {
        this._onlyIfSpec = new AndSpec();
        this._onlyIfSpec.and(onlyIfClosure);
    }

    public void setOnlyIf(Spec<Project> onlyIfSpec) {
        this._onlyIfSpec = new AndSpec(new Spec[]{onlyIfSpec});
    }

    public void setSubprojects(Iterable<Project> subprojects) {
        this._subprojects.clear();
        this.subprojects(subprojects);
    }

    public void setSubprojects(Project ... subprojects) {
        this.setSubprojects(Arrays.asList(subprojects));
    }

    public AppDockerExtension subprojects(Iterable<Project> subprojects) {
        GUtil.addToCollection(this._subprojects, subprojects);
        return this;
    }

    public AppDockerExtension subprojects(Project ... subprojects) {
        return this.subprojects(Arrays.asList(subprojects));
    }
}

