/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.frontend.theme.contributor.extender.internal;

import com.liferay.frontend.theme.contributor.extender.BundleWebResources;
import com.liferay.frontend.theme.contributor.extender.internal.BundleWebResourcesImpl;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.servlet.PortalWebResources;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.MapUtil;
import java.net.URL;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletContext;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

@Component(immediate=true, service={})
public class ThemeContributorExtender
implements ServiceTrackerCustomizer<ServletContext, Collection<ServiceRegistration<?>>> {
    private BundleContext _bundleContext;
    private ServiceTracker<ServletContext, Collection<ServiceRegistration<?>>> _serviceTracker;

    public Collection<ServiceRegistration<?>> addingService(ServiceReference<ServletContext> serviceReference) {
        Bundle bundle = serviceReference.getBundle();
        Dictionary headers = bundle.getHeaders("");
        String type = (String)headers.get("Liferay-Theme-Contributor-Type");
        if (type == null) {
            return null;
        }
        Map.Entry<List<String>, List<String>> entry = ThemeContributorExtender._scanBundleWebResources(bundle);
        if (entry == null) {
            return null;
        }
        ArrayList serviceRegistrations = new ArrayList();
        ServletContext servletContext = (ServletContext)this._bundleContext.getService(serviceReference);
        Dictionary properties = MapUtil.singletonDictionary((Object)"service.ranking", (Object)GetterUtil.getInteger((String)((String)headers.get("Liferay-Theme-Contributor-Weight"))));
        serviceRegistrations.add(this._bundleContext.registerService(PortalWebResources.class.getName(), (Object)new ThemeContributorPortalWebResources(bundle, servletContext), properties));
        serviceRegistrations.add(this._bundleContext.registerService(BundleWebResources.class, (Object)new BundleWebResourcesImpl(servletContext.getContextPath(), (Collection<String>)entry.getKey(), (Collection<String>)entry.getValue()), properties));
        return serviceRegistrations;
    }

    public void modifiedService(ServiceReference<ServletContext> serviceReference, Collection<ServiceRegistration<?>> service) {
    }

    public void removedService(ServiceReference<ServletContext> serviceReference, Collection<ServiceRegistration<?>> serviceRegistrations) {
        for (ServiceRegistration<?> serviceRegistration : serviceRegistrations) {
            serviceRegistration.unregister();
        }
        this._bundleContext.ungetService(serviceReference);
    }

    @Activate
    protected void activate(BundleContext bundleContext) throws InvalidSyntaxException {
        this._bundleContext = bundleContext;
        this._serviceTracker = new ServiceTracker(bundleContext, bundleContext.createFilter(StringBundler.concat((String[])new String[]{"(&(objectClass=", ServletContext.class.getName(), ")(osgi.web.symbolicname=*))"})), (ServiceTrackerCustomizer)this);
        this._serviceTracker.open();
    }

    @Deactivate
    protected void deactivate() {
        this._serviceTracker.close();
    }

    private static Map.Entry<List<String>, List<String>> _scanBundleWebResources(Bundle bundle) {
        ArrayList<String> cssResourcePaths = new ArrayList<String>();
        Enumeration cssEntries = bundle.findEntries("/META-INF/resources", "*.css", true);
        if (cssEntries != null) {
            while (cssEntries.hasMoreElements()) {
                int index;
                URL url = (URL)cssEntries.nextElement();
                String path = url.getFile();
                if ("_".equals(Character.valueOf((path = path.substring("/META-INF/resources".length())).charAt((index = path.lastIndexOf(47)) + 1))) || path.endsWith("_rtl.css")) continue;
                cssResourcePaths.add(path);
            }
        }
        ArrayList<String> jsResourcePaths = new ArrayList<String>();
        Enumeration jsEntries = bundle.findEntries("/META-INF/resources", "*.js", true);
        if (jsEntries != null) {
            while (jsEntries.hasMoreElements()) {
                URL url = (URL)jsEntries.nextElement();
                String path = url.getFile();
                jsResourcePaths.add(path.substring("/META-INF/resources".length()));
            }
        }
        if (cssResourcePaths.isEmpty() && jsResourcePaths.isEmpty()) {
            return null;
        }
        return new AbstractMap.SimpleImmutableEntry<List<String>, List<String>>(cssResourcePaths, jsResourcePaths);
    }

    private static class ThemeContributorPortalWebResources
    implements PortalWebResources {
        private final Bundle _bundle;
        private final ServletContext _servletContext;

        public String getContextPath() {
            return this._servletContext.getContextPath();
        }

        public long getLastModified() {
            return this._bundle.getLastModified();
        }

        public String getResourceType() {
            return "theme_contributor";
        }

        public ServletContext getServletContext() {
            return this._servletContext;
        }

        private ThemeContributorPortalWebResources(Bundle bundle, ServletContext servletContext) {
            this._bundle = bundle;
            this._servletContext = servletContext;
        }
    }
}

