Liferay.Loader.define("frontend-theme-classic-style-guide-sample-web@1.0.8/js/App", ['module', 'exports', 'require', '@frontend-taglib-clay$clayui/layout', 'frontend-js-react-web$classnames', 'frontend-js-react-web$react', '../css/main.scss', '../css/tokens.scss'], function (module, exports, require) {
  var define = undefined;
  var global = window;
  {
    function _typeof(obj) {
      "@babel/helpers - typeof";
      if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") {
        _typeof = function _typeof(obj) {
          return typeof obj;
        };
      } else {
        _typeof = function _typeof(obj) {
          return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj;
        };
      }return _typeof(obj);
    }

    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports["default"] = App;

    var _layout = _interopRequireDefault(require("@frontend-taglib-clay$clayui/layout"));

    var _classnames = _interopRequireDefault(require("frontend-js-react-web$classnames"));

    var _react = _interopRequireWildcard(require("frontend-js-react-web$react"));

    require("../css/main.scss");

    require("../css/tokens.scss");

    function _getRequireWildcardCache() {
      if (typeof WeakMap !== "function") return null;var cache = new WeakMap();_getRequireWildcardCache = function _getRequireWildcardCache() {
        return cache;
      };return cache;
    }

    function _interopRequireWildcard(obj) {
      if (obj && obj.__esModule) {
        return obj;
      }if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") {
        return { "default": obj };
      }var cache = _getRequireWildcardCache();if (cache && cache.has(obj)) {
        return cache.get(obj);
      }var newObj = {};var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor;for (var key in obj) {
        if (Object.prototype.hasOwnProperty.call(obj, key)) {
          var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null;if (desc && (desc.get || desc.set)) {
            Object.defineProperty(newObj, key, desc);
          } else {
            newObj[key] = obj[key];
          }
        }
      }newObj["default"] = obj;if (cache) {
        cache.set(obj, newObj);
      }return newObj;
    }

    function _interopRequireDefault(obj) {
      return obj && obj.__esModule ? obj : { "default": obj };
    }

    function _slicedToArray(arr, i) {
      return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _nonIterableRest();
    }

    function _nonIterableRest() {
      throw new TypeError("Invalid attempt to destructure non-iterable instance");
    }

    function _iterableToArrayLimit(arr, i) {
      if (!(Symbol.iterator in Object(arr) || Object.prototype.toString.call(arr) === "[object Arguments]")) {
        return;
      }var _arr = [];var _n = true;var _d = false;var _e = undefined;try {
        for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) {
          _arr.push(_s.value);if (i && _arr.length === i) break;
        }
      } catch (err) {
        _d = true;_e = err;
      } finally {
        try {
          if (!_n && _i["return"] != null) _i["return"]();
        } finally {
          if (_d) throw _e;
        }
      }return _arr;
    }

    function _arrayWithHoles(arr) {
      if (Array.isArray(arr)) return arr;
    }

    var BORDERS = ['border-radius', 'border-radius-sm', 'border-radius-lg', 'border-radius-rounded', 'border-radius-circle', 'border-radius-pill'];
    var DISPLAYS = ['display-1', 'display-2', 'display-3', 'display-4'];
    var FONT_FAMILIES = ['font-family-sans-serif', 'font-family-monospace', 'font-family-base'];
    var FONT_WEIGHTS = ['font-weight-lighter', 'font-weight-light', 'font-weight-normal', 'font-weight-semi-bold', 'font-weight-bold', 'font-weight-bolder'];
    var GRAYS = ['white', 'gray-100', 'gray-200', 'gray-300', 'gray-400', 'gray-500', 'gray-600', 'gray-700', 'gray-800', 'gray-900', 'black', 'transparent'];
    var HEADINGS = ['h1', 'h2', 'h3', 'h4', 'h5', 'h6'];
    var SAMPLE_TEXT = 'The quick brown fox jumps over the lazy dog';
    var SHADOWS = ['shadow', 'shadow-sm', 'shadow-lg'];
    var SPACERS = ['spacer-1', 'spacer-2', 'spacer-3', 'spacer-4', 'spacer-5', 'spacer-6', 'spacer-7', 'spacer-8', 'spacer-9', 'spacer-10'];
    var RATIOS = ['aspect-ratio', 'aspect-ratio-16-to-9', 'aspect-ratio-8-to-3', 'aspect-ratio-4-to-3'];
    var THEME_COLORS = ['primary', 'secondary', 'success', 'info', 'warning', 'danger', 'light', 'lighter', 'gray', 'dark'];

    var TokenGroup = function TokenGroup(_ref) {
      var children = _ref.children,
          group = _ref.group,
          md = _ref.md,
          title = _ref.title;
      return _react["default"].createElement(_layout["default"].Col, {
        className: 'token-group token-group-' + group,
        md: md,
        size: !md && '12'
      }, title && _react["default"].createElement("h2", null, title), children && _react["default"].createElement("div", {
        className: "token-items"
      }, children));
    };

    var TokenItem = function TokenItem(_ref2) {
      var children = _ref2.children,
          label = _ref2.label,
          sample = _ref2.sample;
      return _react["default"].createElement("div", {
        className: "token-item"
      }, _react["default"].createElement("span", {
        className: (0, _classnames["default"])('token-sample', sample)
      }, children), (label || sample) && _react["default"].createElement("span", {
        className: "token-label"
      }, label || sample));
    };

    function App() {
      var _useState = (0, _react.useState)(false),
          _useState2 = _slicedToArray(_useState, 2),
          fade = _useState2[0],
          setFade = _useState2[1];

      var _useState3 = (0, _react.useState)(false),
          _useState4 = _slicedToArray(_useState3, 2),
          collapse = _useState4[0],
          setCollapse = _useState4[1];

      return _react["default"].createElement("div", {
        className: "ccp"
      }, _react["default"].createElement(_layout["default"].ContainerFluid, null, _react["default"].createElement(_layout["default"].Row, null, _react["default"].createElement(_layout["default"].Col, null, _react["default"].createElement("h1", null, Liferay.Language.get('style-guide-sample'))), _react["default"].createElement(TokenGroup, {
        group: "colors",
        title: Liferay.Language.get('grays')
      }, GRAYS.map(function (item) {
        return _react["default"].createElement(TokenItem, {
          key: item,
          label: item,
          sample: "bg-".concat(item)
        });
      })), _react["default"].createElement(TokenGroup, {
        group: "colors",
        title: Liferay.Language.get('theme-colors')
      }, THEME_COLORS.map(function (item) {
        return _react["default"].createElement(TokenItem, {
          key: item,
          label: item,
          sample: "bg-".concat(item)
        });
      })), _react["default"].createElement(TokenGroup, {
        group: "spacers",
        md: "4",
        title: Liferay.Language.get('spacers')
      }, SPACERS.map(function (item) {
        return _react["default"].createElement(TokenItem, {
          key: item,
          label: item,
          sample: item.replace('spacer', 'pr')
        });
      })), _react["default"].createElement(TokenGroup, {
        group: "borders",
        md: "4",
        title: Liferay.Language.get('borders')
      }, BORDERS.map(function (item) {
        return _react["default"].createElement(TokenItem, {
          key: item,
          label: item,
          sample: item.replace('border-radius', 'rounded')
        });
      })), _react["default"].createElement(TokenGroup, {
        group: "shadows",
        md: "4",
        title: Liferay.Language.get('box-shadow')
      }, SHADOWS.map(function (item) {
        return _react["default"].createElement(TokenItem, {
          key: item,
          sample: item
        });
      })), _react["default"].createElement(TokenGroup, {
        group: "ratios",
        md: "4",
        title: Liferay.Language.get('aspect-ratios')
      }, RATIOS.map(function (item) {
        return _react["default"].createElement(TokenItem, {
          key: item,
          label: item
        }, _react["default"].createElement("span", {
          className: (0, _classnames["default"])('aspect-ratio', item)
        }));
      })), _react["default"].createElement(TokenGroup, {
        group: "transitions",
        md: "4",
        title: Liferay.Language.get('transitions')
      }, _react["default"].createElement("label", {
        className: "token-item"
      }, _react["default"].createElement("span", {
        className: "token-sample"
      }, _react["default"].createElement("span", {
        className: (0, _classnames["default"])('fade', {
          show: !fade
        })
      })), _react["default"].createElement("span", {
        className: "token-label"
      }, "transition-fade"), _react["default"].createElement("input", {
        onChange: function onChange() {
          return setFade(!fade);
        },
        type: "checkbox",
        value: fade
      })), _react["default"].createElement("label", {
        className: "token-item"
      }, _react["default"].createElement("span", {
        className: "token-sample"
      }, _react["default"].createElement("span", {
        className: (0, _classnames["default"])('collapsing', {
          show: !collapse
        })
      })), _react["default"].createElement("span", {
        className: "token-label"
      }, "transition-collapse"), _react["default"].createElement("input", {
        onChange: function onChange() {
          return setCollapse(!collapse);
        },
        type: "checkbox",
        value: collapse
      }))), _react["default"].createElement(TokenGroup, {
        group: "texts",
        md: "4",
        title: Liferay.Language.get('font-families')
      }, FONT_FAMILIES.map(function (item) {
        return _react["default"].createElement(TokenItem, {
          key: item,
          sample: item
        }, SAMPLE_TEXT);
      })), _react["default"].createElement(TokenGroup, {
        group: "texts",
        md: "6",
        title: Liferay.Language.get('font-weights')
      }, FONT_WEIGHTS.map(function (item) {
        return _react["default"].createElement(TokenItem, {
          key: item,
          sample: item
        }, SAMPLE_TEXT);
      })), _react["default"].createElement(TokenGroup, {
        group: "texts",
        md: "6",
        title: Liferay.Language.get('headings')
      }, HEADINGS.map(function (item) {
        return _react["default"].createElement(TokenItem, {
          key: item,
          sample: item
        }, SAMPLE_TEXT);
      })), _react["default"].createElement(TokenGroup, {
        group: "texts",
        title: Liferay.Language.get('displays')
      }, DISPLAYS.map(function (item) {
        return _react["default"].createElement(TokenItem, {
          key: item,
          sample: item
        }, SAMPLE_TEXT);
      })), _react["default"].createElement(TokenGroup, {
        group: "texts",
        title: Liferay.Language.get('others')
      }, _react["default"].createElement(TokenItem, {
        sample: "lead"
      }, SAMPLE_TEXT), _react["default"].createElement(TokenItem, {
        sample: "muted"
      }, SAMPLE_TEXT), _react["default"].createElement(TokenItem, {
        label: "blockquote"
      }, _react["default"].createElement("span", {
        className: "blockquote"
      }, SAMPLE_TEXT), _react["default"].createElement("span", {
        className: "blockquote-footer"
      }, "Liferay")), _react["default"].createElement(TokenItem, {
        label: "separator"
      }, _react["default"].createElement("hr", null))))));
    }
    //# sourceMappingURL=App.js.map
  }
});
//# sourceMappingURL=App.js.map