Liferay.Loader.define("frontend-js-web@4.0.29/liferay/util/get_crop_region.es", ['module', 'exports', 'require', 'frontend-js-metal-web$metal'], function (module, exports, require) {
  var define = undefined;
  Object.defineProperty(exports, "__esModule", {
    value: true
  });
  exports["default"] = getCropRegion;

  var _metal = require("frontend-js-metal-web$metal");

  /**
   * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
   *
   * This library is free software; you can redistribute it and/or modify it under
   * the terms of the GNU Lesser General Public License as published by the Free
   * Software Foundation; either version 2.1 of the License, or (at your option)
   * any later version.
   *
   * This library is distributed in the hope that it will be useful, but WITHOUT
   * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
   * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
   * details.
   */

  /**
   * Returns dimensions and coordinates representing a cropped region
   * @param {!Element} imagePreview Image that will be cropped
   * @param {!Object} region Object representing the coordinates which should be
   * cropped
   * @return {!Object} Object representing dimensions and coordinates of the
   * cropped image
   * @review
   */
  function getCropRegion(imagePreview, region) {
    if (!(0, _metal.isObject)(imagePreview) || (0, _metal.isObject)(imagePreview) && imagePreview.tagName !== 'IMG') {
      throw new TypeError('Parameter imagePreview must be an image');
    }

    if (!(0, _metal.isObject)(region)) {
      throw new TypeError('Parameter region must be an object');
    }

    var scaleX = imagePreview.naturalWidth / imagePreview.offsetWidth;
    var scaleY = imagePreview.naturalHeight / imagePreview.offsetHeight;
    var height = region.height ? region.height * scaleY : imagePreview.naturalHeight;
    var width = region.width ? region.width * scaleX : imagePreview.naturalWidth;
    var x = region.x ? Math.max(region.x * scaleX, 0) : 0;
    var y = region.y ? Math.max(region.y * scaleY, 0) : 0;
    return {
      height: height,
      width: width,
      x: x,
      y: y
    };
  }
  //# sourceMappingURL=get_crop_region.es.js.map
});
//# sourceMappingURL=get_crop_region.es.js.map