Liferay.Loader.define("frontend-js-web@4.0.29/liferay/util/format_xml.es", ['module', 'exports', 'require', 'frontend-js-metal-web$metal'], function (module, exports, require) {
  var define = undefined;
  Object.defineProperty(exports, "__esModule", {
    value: true
  });
  exports["default"] = formatXML;

  var _metal = require("frontend-js-metal-web$metal");

  function ownKeys(object, enumerableOnly) {
    var keys = Object.keys(object);if (Object.getOwnPropertySymbols) {
      var symbols = Object.getOwnPropertySymbols(object);if (enumerableOnly) symbols = symbols.filter(function (sym) {
        return Object.getOwnPropertyDescriptor(object, sym).enumerable;
      });keys.push.apply(keys, symbols);
    }return keys;
  }

  function _objectSpread(target) {
    for (var i = 1; i < arguments.length; i++) {
      var source = arguments[i] != null ? arguments[i] : {};if (i % 2) {
        ownKeys(Object(source), true).forEach(function (key) {
          _defineProperty(target, key, source[key]);
        });
      } else if (Object.getOwnPropertyDescriptors) {
        Object.defineProperties(target, Object.getOwnPropertyDescriptors(source));
      } else {
        ownKeys(Object(source)).forEach(function (key) {
          Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key));
        });
      }
    }return target;
  }

  function _defineProperty(obj, key, value) {
    if (key in obj) {
      Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true });
    } else {
      obj[key] = value;
    }return obj;
  }

  var NEW_LINE = '\r\n';
  var REGEX_CDATA = /<!\[CDATA\[[\0-\uFFFF]*?\]\]>/g;
  var REGEX_DECLARATIVE_CLOSE = /-->|\]>/;
  var REGEX_DECLARATIVE_OPEN = /<!/;
  var REGEX_DIRECTIVE = /<\?/;
  var REGEX_DOCTYPE = /!DOCTYPE/;
  var REGEX_ELEMENT = /^<\w/;
  var REGEX_ELEMENT_CLOSE = /^<\/\w/;
  var REGEX_ELEMENT_NAMESPACED = /^<[\w:\-.,]+/;
  var REGEX_ELEMENT_NAMESPACED_CLOSE = /^<\/[\w:\-.,]+/;
  var REGEX_ELEMENT_OPEN = /<\w/;
  var REGEX_NAMESPACE_XML = /xmlns(?::|=)/g;
  var REGEX_NAMESPACE_XML_ATTR = /\s*(xmlns)(:|=)/g;
  var REGEX_TAG_CLOSE = /<\//;
  var REGEX_TAG_OPEN = /</g;
  var REGEX_TAG_SINGLE_CLOSE = /\/>/;
  var REGEX_WHITESPACE_BETWEEN_TAGS = />\s+</g;
  var STR_BLANK = '';
  var STR_TOKEN = '~::~';
  var STR_TOKEN_CDATA = '<' + STR_TOKEN + 'CDATA' + STR_TOKEN + '>';
  var REGEX_TOKEN_CDATA = new RegExp(STR_TOKEN_CDATA, 'g');
  var TAG_INDENT = '\t';
  var DEFAULT_OPTIONS = {
    newLine: NEW_LINE,
    tagIndent: TAG_INDENT
  };
  /**
   * Returns a formatted XML
   * @param {!String} content String to format
   * @param {Object} options Optional parameter that can accept provided options
   * @return {!String} Formatted content
   */

  function formatXML(content) {
    var options = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};

    var _DEFAULT_OPTIONS$opti = _objectSpread({}, DEFAULT_OPTIONS, {}, options),
        newLine = _DEFAULT_OPTIONS$opti.newLine,
        tagIndent = _DEFAULT_OPTIONS$opti.tagIndent;

    if (!(0, _metal.isString)(content)) {
      throw new TypeError('Parameter content must be a string');
    }

    var cdata = [];
    content = content.trim();
    content = content.replace(REGEX_CDATA, function (match) {
      cdata.push(match);
      return STR_TOKEN_CDATA;
    });
    content = content.replace(REGEX_WHITESPACE_BETWEEN_TAGS, '><');
    content = content.replace(REGEX_TAG_OPEN, STR_TOKEN + '<');
    content = content.replace(REGEX_NAMESPACE_XML_ATTR, STR_TOKEN + '$1$2');
    content = content.replace(REGEX_TOKEN_CDATA, function () {
      return cdata.shift();
    });
    var commentCounter = 0;
    var inComment = false;
    var items = content.split(STR_TOKEN);
    var level = 0;
    var result = '';
    items.forEach(function (item, index) {
      if (REGEX_CDATA.test(item)) {
        result += indent(level, newLine, tagIndent) + item;
      } else if (REGEX_DECLARATIVE_OPEN.test(item)) {
        result += indent(level, newLine, tagIndent) + item;
        commentCounter++;
        inComment = true;

        if (REGEX_DECLARATIVE_CLOSE.test(item) || REGEX_DOCTYPE.test(item)) {
          commentCounter--;
          inComment = commentCounter !== 0;
        }
      } else if (REGEX_DECLARATIVE_CLOSE.test(item)) {
        result += item;
        commentCounter--;
        inComment = commentCounter !== 0;
      } else if (REGEX_ELEMENT.exec(items[index - 1]) && REGEX_ELEMENT_CLOSE.exec(item) && REGEX_ELEMENT_NAMESPACED.exec(items[index - 1]) == REGEX_ELEMENT_NAMESPACED_CLOSE.exec(item)[0].replace('/', STR_BLANK)) {
        result += item;

        if (!inComment) {
          --level;
        }
      } else if (REGEX_ELEMENT_OPEN.test(item) && !REGEX_TAG_CLOSE.test(item) && !REGEX_TAG_SINGLE_CLOSE.test(item)) {
        if (inComment) {
          result += item;
        } else {
          result += indent(level++, newLine, tagIndent) + item;
        }
      } else if (REGEX_ELEMENT_OPEN.test(item) && REGEX_TAG_CLOSE.test(item)) {
        if (inComment) {
          result += item;
        } else {
          result += indent(level, newLine, tagIndent) + item;
        }
      } else if (REGEX_TAG_CLOSE.test(item)) {
        if (inComment) {
          result += item;
        } else {
          result += indent(--level, newLine, tagIndent) + item;
        }
      } else if (REGEX_TAG_SINGLE_CLOSE.test(item)) {
        if (inComment) {
          result += item;
        } else {
          result += indent(level, newLine, tagIndent) + item;
        }
      } else if (REGEX_DIRECTIVE.test(item)) {
        result += indent(level, newLine, tagIndent) + item;
      } else if (REGEX_NAMESPACE_XML) {
        result += indent(level, newLine, tagIndent) + item;
      } else {
        result += item;
      }

      if (new RegExp('^' + newLine).test(result)) {
        result = result.slice(newLine.length);
      }
    });
    return result;
  }
  /**
   * Returns a string for starting a new line at the specified indent level
   * @param {number} level The level of indentation
   * @return {String} Return a string for starting a new line at the specified indent level
   */

  function indent(level, newLine, tagIndent) {
    return newLine + new Array(level + 1).join(tagIndent);
  }
  //# sourceMappingURL=format_xml.es.js.map
});
//# sourceMappingURL=format_xml.es.js.map