Liferay.Loader.define("frontend-js-web@4.0.29/liferay/util/form/post_form.es", ['module', 'exports', 'require', 'frontend-js-metal-web$metal', 'frontend-js-metal-web$metal-dom', './set_form_values.es'], function (module, exports, require) {
  var define = undefined;
  Object.defineProperty(exports, "__esModule", {
    value: true
  });
  exports["default"] = postForm;

  var _metal = require("frontend-js-metal-web$metal");

  var _metalDom = _interopRequireDefault(require("frontend-js-metal-web$metal-dom"));

  var _set_form_values = _interopRequireDefault(require("./set_form_values.es"));

  function _interopRequireDefault(obj) {
    return obj && obj.__esModule ? obj : { "default": obj };
  }

  /**
   * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
   *
   * This library is free software; you can redistribute it and/or modify it under
   * the terms of the GNU Lesser General Public License as published by the Free
   * Software Foundation; either version 2.1 of the License, or (at your option)
   * any later version.
   *
   * This library is distributed in the hope that it will be useful, but WITHOUT
   * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
   * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
   * details.
   */

  /**
   * Submits the form, with optional setting of form elements.
   * @param {!Element|!string} form The form DOM element or the selector
   * @param {Object=} options An object containing optional settings:
   * - `url` : a string containing form action url
   * - `data` : an object containing form elements keys and values, to be set
   * before submission
   * @review
   */
  function postForm(form, options) {
    form = _metalDom["default"].toElement(form);

    if (form && form.nodeName === 'FORM') {
      form.setAttribute('method', 'post');

      if ((0, _metal.isObject)(options)) {
        var data = options.data,
            url = options.url;

        if ((0, _metal.isObject)(data)) {
          (0, _set_form_values["default"])(form, data);
        } else {
          return;
        }

        if (!(0, _metal.isDef)(url)) {
          submitForm(form);
        } else if ((0, _metal.isString)(url)) {
          submitForm(form, url);
        }
      } else {
        submitForm(form);
      }
    }
  }
  //# sourceMappingURL=post_form.es.js.map
});
//# sourceMappingURL=post_form.es.js.map