Liferay.Loader.define("frontend-js-web@4.0.29/liferay/toast/commands/OpenToast.es", ['module', 'exports', 'require', '@frontend-taglib-clay$clayui/alert', 'frontend-js-react-web', 'frontend-js-metal-web$metal-dom', 'frontend-js-react-web$react', 'frontend-js-react-web$react-dom'], function (module, exports, require) {
  var define = undefined;
  Object.defineProperty(exports, "__esModule", {
    value: true
  });
  exports.openToast = openToast;
  exports["default"] = void 0;

  var _alert = _interopRequireDefault(require("@frontend-taglib-clay$clayui/alert"));

  var _frontendJsReactWeb = require("frontend-js-react-web");

  var _metalDom = require("frontend-js-metal-web$metal-dom");

  var _react = _interopRequireDefault(require("frontend-js-react-web$react"));

  var _reactDom = require("frontend-js-react-web$react-dom");

  function _interopRequireDefault(obj) {
    return obj && obj.__esModule ? obj : { "default": obj };
  }

  function _extends() {
    _extends = Object.assign || function (target) {
      for (var i = 1; i < arguments.length; i++) {
        var source = arguments[i];for (var key in source) {
          if (Object.prototype.hasOwnProperty.call(source, key)) {
            target[key] = source[key];
          }
        }
      }return target;
    };return _extends.apply(this, arguments);
  }

  var DEFAULT_ALERT_CONTAINER_ID = 'ToastAlertContainer';
  var DEFAULT_RENDER_DATA = {
    portletId: 'UNKNOWN_PORTLET_ID'
  };
  var DEFAULT_TOAST_TYPE_TITLES = {
    danger: Liferay.Language.get('error'),
    info: Liferay.Language.get('info'),
    success: Liferay.Language.get('success'),
    warning: Liferay.Language.get('warning')
  };
  var TOAST_AUTO_CLOSE_INTERVAL = 5000;
  var TPL_ALERT_CONTAINER = "\n\t<div class=\"alert-container container\">\n\t\t<div class=\"alert-notifications alert-notifications-fixed\" id=".concat(DEFAULT_ALERT_CONTAINER_ID, "></div>\n\t</div>\n");

  var getRootElement = function getRootElement(_ref) {
    var container = _ref.container,
        containerId = _ref.containerId;

    if (container || containerId) {
      container = container || document.getElementById(containerId);

      if (container) {
        var child = document.createElement('div');
        container.appendChild(child);
        return child;
      }
    }

    var alertFixed = document.getElementById(DEFAULT_ALERT_CONTAINER_ID);

    if (!alertFixed) {
      alertFixed = (0, _metalDom.buildFragment)(TPL_ALERT_CONTAINER).querySelector('.alert-container.container');
      alertFixed = document.body.appendChild(alertFixed);
    } // Creates a fragment to prevent React from unmounting the alert container


    container = document.createElement('div');
    container.className = 'mb-3';
    var fragmentContainer = document.querySelector(".alert-notifications.alert-notifications-fixed");
    fragmentContainer.appendChild(container);
    return container;
  };
  /**
   * Function that implements the Toast pattern, which allows to present feedback
   * to user actions as a toast message in the lower left corner of the page
   *
   * @param {number|boolean} autoClose Flag to indicate alert should automatically call onClose.
   * It also accepts a duration (in ms) which indicates how long to wait. If true is passed in, the
   * timeout will be 10000ms. See https://clayui.com/docs/components/alert.html for more details.
   * @param {HTMLElement} container Target element where the toast React component should be mounted.
   * @param {string} containerId The id of the element where the toast React component should be mounted.
   * @param {string|HTML} message The message to show in the toast notification
   * @param {string|HTML} title The title associated with the message
   * @param {string} displayType The displayType of notification to show. It can be one of the
   * following: 'danger', 'info', 'success', 'warning'
   * @return {ClayToast} The Alert toast created
   * @review
   */

  function openToast(_ref2) {
    var _ref2$autoClose = _ref2.autoClose,
        autoClose = _ref2$autoClose === void 0 ? TOAST_AUTO_CLOSE_INTERVAL : _ref2$autoClose,
        container = _ref2.container,
        containerId = _ref2.containerId,
        _ref2$message = _ref2.message,
        message = _ref2$message === void 0 ? '' : _ref2$message,
        _ref2$onClick = _ref2.onClick,
        _onClick = _ref2$onClick === void 0 ? function () {} : _ref2$onClick,
        _ref2$onClose = _ref2.onClose,
        onClose = _ref2$onClose === void 0 ? function () {} : _ref2$onClose,
        _ref2$renderData = _ref2.renderData,
        renderData = _ref2$renderData === void 0 ? DEFAULT_RENDER_DATA : _ref2$renderData,
        title = _ref2.title,
        _ref2$toastProps = _ref2.toastProps,
        toastProps = _ref2$toastProps === void 0 ? {} : _ref2$toastProps,
        _ref2$type = _ref2.type,
        type = _ref2$type === void 0 ? 'success' : _ref2$type,
        variant = _ref2.variant;

    var rootElement = getRootElement({
      container: container,
      containerId: containerId
    });
    (0, _reactDom.unmountComponentAtNode)(rootElement);

    var onCloseFn = function onCloseFn(event) {
      if (onClose) {
        onClose({
          event: event
        });
      }

      if (!event || !event.defaultPrevented) {
        if (!container || !containerId) {
          rootElement.parentNode.removeChild(rootElement);
        }

        (0, _reactDom.unmountComponentAtNode)(rootElement);
      }
    };

    var titleHTML = title === undefined ? DEFAULT_TOAST_TYPE_TITLES[type] : title;

    if (titleHTML) {
      titleHTML = titleHTML.replace(/:$/, '');
      titleHTML = "<strong class=\"lead\">".concat(titleHTML, ":</strong>");
    } else {
      titleHTML = '';
    }

    (0, _frontendJsReactWeb.render)(_react["default"].createElement(_alert["default"], _extends({
      autoClose: autoClose,
      displayType: type,
      onClick: function onClick(event) {
        return _onClick({
          event: event,
          onClose: onCloseFn
        });
      },
      onClose: onCloseFn,
      variant: variant
    }, toastProps), _react["default"].createElement("div", {
      dangerouslySetInnerHTML: {
        __html: "".concat(titleHTML).concat(message)
      }
    })), renderData, rootElement);
  }

  var _default = openToast;
  exports["default"] = _default;
  //# sourceMappingURL=OpenToast.es.js.map
});
//# sourceMappingURL=OpenToast.es.js.map