Liferay.Loader.define("frontend-js-web@3.0.53/liferay/toast/commands/OpenToast.es", ['module', 'exports', 'require', 'frontend-taglib-clay$clay-alert', 'frontend-js-metal-web$metal-dom'], function (module, exports, require) {
  var define = undefined;
  Object.defineProperty(exports, "__esModule", {
    value: true
  });
  exports.openToast = openToast;
  exports["default"] = void 0;

  var _clayAlert = require("frontend-taglib-clay$clay-alert");

  var _metalDom = _interopRequireDefault(require("frontend-js-metal-web$metal-dom"));

  function _interopRequireDefault(obj) {
    return obj && obj.__esModule ? obj : { "default": obj };
  }

  function ownKeys(object, enumerableOnly) {
    var keys = Object.keys(object);if (Object.getOwnPropertySymbols) {
      var symbols = Object.getOwnPropertySymbols(object);if (enumerableOnly) symbols = symbols.filter(function (sym) {
        return Object.getOwnPropertyDescriptor(object, sym).enumerable;
      });keys.push.apply(keys, symbols);
    }return keys;
  }

  function _objectSpread(target) {
    for (var i = 1; i < arguments.length; i++) {
      var source = arguments[i] != null ? arguments[i] : {};if (i % 2) {
        ownKeys(Object(source), true).forEach(function (key) {
          _defineProperty(target, key, source[key]);
        });
      } else if (Object.getOwnPropertyDescriptors) {
        Object.defineProperties(target, Object.getOwnPropertyDescriptors(source));
      } else {
        ownKeys(Object(source)).forEach(function (key) {
          Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key));
        });
      }
    }return target;
  }

  function _defineProperty(obj, key, value) {
    if (key in obj) {
      Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true });
    } else {
      obj[key] = value;
    }return obj;
  }

  /**
   * Function that implements the Toast pattern, which allows to present feedback
   * to user actions as a toast message in the lower left corner of the page
   *
   * @param {string} message The message to show in the toast notification
   * @param {string} title The title associated with the message
   * @param {string} type The type of notification to show. It can be one of the
   * following: 'danger', 'info', 'success', 'warning'
   * @return {ClayToast} The Alert toast created
   * @review
   */
  function openToast() {
    var _ref = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {},
        _ref$events = _ref.events,
        events = _ref$events === void 0 ? {} : _ref$events,
        _ref$message = _ref.message,
        message = _ref$message === void 0 ? '' : _ref$message,
        _ref$title = _ref.title,
        title = _ref$title === void 0 ? Liferay.Language.get('success') : _ref$title,
        _ref$type = _ref.type,
        type = _ref$type === void 0 ? 'success' : _ref$type;

    var alertContainer = document.getElementById('alertContainer');

    if (!alertContainer) {
      alertContainer = document.createElement('div');
      alertContainer.id = 'alertContainer';

      _metalDom["default"].addClasses(alertContainer, 'alert-notifications alert-notifications-fixed');

      _metalDom["default"].enterDocument(alertContainer);
    } else {
      _metalDom["default"].removeChildren(alertContainer);
    }

    var mergedEvents = _objectSpread({
      disposed: function disposed() {
        if (!alertContainer.hasChildNodes()) {
          _metalDom["default"].exitDocument(alertContainer);
        }
      }
    }, events);

    var clayToast = new _clayAlert.ClayToast({
      autoClose: true,
      destroyOnHide: true,
      events: mergedEvents,
      message: message,
      spritemap: themeDisplay.getPathThemeImages() + '/lexicon/icons.svg',
      style: type,
      title: title
    }, alertContainer);

    _metalDom["default"].removeClasses(clayToast.element, 'show');

    requestAnimationFrame(function () {
      _metalDom["default"].addClasses(clayToast.element, 'show');
    });
    return clayToast;
  }

  var _default = openToast;
  exports["default"] = _default;
  //# sourceMappingURL=OpenToast.es.js.map
});
//# sourceMappingURL=OpenToast.es.js.map