Liferay.Loader.define("frontend-js-web@3.0.53/liferay/modal/components/SimpleInputModal.es", ['module', 'exports', 'require', 'frontend-js-metal-web$metal', 'frontend-js-metal-web$metal-soy', 'frontend-js-metal-web$metal-state', './../../util/fetch.es', '../../compat/modal/Modal.es', '../../PortletBase.es', './SimpleInputModal.soy'], function (module, exports, require) {
  var define = undefined;
  Object.defineProperty(exports, "__esModule", {
    value: true
  });
  exports["default"] = exports.SimpleInputModal = void 0;

  var _metal = require("frontend-js-metal-web$metal");

  var _metalSoy = _interopRequireDefault(require("frontend-js-metal-web$metal-soy"));

  var _metalState = require("frontend-js-metal-web$metal-state");

  var _fetch = _interopRequireDefault(require("./../../util/fetch.es"));

  require("../../compat/modal/Modal.es");

  var _PortletBase2 = _interopRequireDefault(require("../../PortletBase.es"));

  var _SimpleInputModal = _interopRequireDefault(require("./SimpleInputModal.soy"));

  function _interopRequireDefault(obj) {
    return obj && obj.__esModule ? obj : { "default": obj };
  }

  function _typeof(obj) {
    "@babel/helpers - typeof";
    if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") {
      _typeof = function _typeof(obj) {
        return typeof obj;
      };
    } else {
      _typeof = function _typeof(obj) {
        return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj;
      };
    }return _typeof(obj);
  }

  function ownKeys(object, enumerableOnly) {
    var keys = Object.keys(object);if (Object.getOwnPropertySymbols) {
      var symbols = Object.getOwnPropertySymbols(object);if (enumerableOnly) symbols = symbols.filter(function (sym) {
        return Object.getOwnPropertyDescriptor(object, sym).enumerable;
      });keys.push.apply(keys, symbols);
    }return keys;
  }

  function _objectSpread(target) {
    for (var i = 1; i < arguments.length; i++) {
      var source = arguments[i] != null ? arguments[i] : {};if (i % 2) {
        ownKeys(Object(source), true).forEach(function (key) {
          _defineProperty(target, key, source[key]);
        });
      } else if (Object.getOwnPropertyDescriptors) {
        Object.defineProperties(target, Object.getOwnPropertyDescriptors(source));
      } else {
        ownKeys(Object(source)).forEach(function (key) {
          Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key));
        });
      }
    }return target;
  }

  function _defineProperty(obj, key, value) {
    if (key in obj) {
      Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true });
    } else {
      obj[key] = value;
    }return obj;
  }

  function _classCallCheck(instance, Constructor) {
    if (!(instance instanceof Constructor)) {
      throw new TypeError("Cannot call a class as a function");
    }
  }

  function _defineProperties(target, props) {
    for (var i = 0; i < props.length; i++) {
      var descriptor = props[i];descriptor.enumerable = descriptor.enumerable || false;descriptor.configurable = true;if ("value" in descriptor) descriptor.writable = true;Object.defineProperty(target, descriptor.key, descriptor);
    }
  }

  function _createClass(Constructor, protoProps, staticProps) {
    if (protoProps) _defineProperties(Constructor.prototype, protoProps);if (staticProps) _defineProperties(Constructor, staticProps);return Constructor;
  }

  function _possibleConstructorReturn(self, call) {
    if (call && (_typeof(call) === "object" || typeof call === "function")) {
      return call;
    }return _assertThisInitialized(self);
  }

  function _assertThisInitialized(self) {
    if (self === void 0) {
      throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
    }return self;
  }

  function _getPrototypeOf(o) {
    _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) {
      return o.__proto__ || Object.getPrototypeOf(o);
    };return _getPrototypeOf(o);
  }

  function _inherits(subClass, superClass) {
    if (typeof superClass !== "function" && superClass !== null) {
      throw new TypeError("Super expression must either be null or a function");
    }subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } });if (superClass) _setPrototypeOf(subClass, superClass);
  }

  function _setPrototypeOf(o, p) {
    _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) {
      o.__proto__ = p;return o;
    };return _setPrototypeOf(o, p);
  }

  /**
   * Manipulates small amounts of data with a form shown inside a modal.
   */
  var SimpleInputModal = /*#__PURE__*/function (_PortletBase) {
    _inherits(SimpleInputModal, _PortletBase);

    function SimpleInputModal() {
      _classCallCheck(this, SimpleInputModal);

      return _possibleConstructorReturn(this, _getPrototypeOf(SimpleInputModal).apply(this, arguments));
    }

    _createClass(SimpleInputModal, [{
      key: "attached",

      /**
       * @inheritDoc
       */
      value: function attached() {
        this.addListener('formSubmit', this._defaultFormSubmit.bind(this), true);
      }
      /**
       * @inheritDoc
       */

    }, {
      key: "rendered",
      value: function rendered() {
        var _this = this;

        requestAnimationFrame(function () {
          _this.refs.modal.refs.mainField.focus();
        });
      }
      /**
       * The default event listener for form submission.
       *
       * @param {Event} event The event to listen for.
       * @private
       */

    }, {
      key: "_defaultFormSubmit",
      value: function _defaultFormSubmit(event) {
        var _this2 = this;

        (0, _fetch["default"])(this.formSubmitURL, {
          body: new FormData(event.form),
          method: 'POST'
        }).then(function (response) {
          return response.json();
        }).then(function (responseContent) {
          if (responseContent.error) {
            _this2._loadingResponse = false;

            _this2._handleFormError(responseContent);
          } else {
            _this2._handleFormSuccess(responseContent);
          }
        })["catch"](function (response) {
          _this2._handleFormError(response);
        });
        this._loadingResponse = true;
      }
      /**
       * Callback executed when the <code>SimpleInputModal</code> Cancel button
       * has been clicked.
       *
       * @private
       */

    }, {
      key: "_handleCancelButtonClick",
      value: function _handleCancelButtonClick() {
        this.emit('cancelButtonClicked');
      }
      /**
       * Callback executed when the <code>SimpleInputModal</code> form has been
       * submitted and it receives a server error as a response. It emits a form
       * error event with the error message received.
       *
       * @param {{error: string}} responseContent The error response as a string.
       * @private
       */

    }, {
      key: "_handleFormError",
      value: function _handleFormError(responseContent) {
        this._errorMessage = responseContent.error || '';
        this.emit('formError', {
          errorMessage: this._errorMessage
        });
      }
      /**
       * Callback executed when the <code>SimpleInputModal</code> form has been
       * submitted. It prevents the default behavior and sends this form using a
       * fetch request.
       *
       * @param {Event} event The default behavior for the submission event to
       *        prevent.
       * @private
       */

    }, {
      key: "_handleFormSubmit",
      value: function _handleFormSubmit(event) {
        event.preventDefault();
        this.emit('formSubmit', {
          form: this.refs.modal.refs.form
        });
      }
      /**
       * Callback executed when the <code>SimpleInputModal</code> form has been
       * submitted successfully. It emits a form success event with the redirect
       * URL received.
       *
       * @param {{redirectURL: string}} responseContent The redirect URL as a
       *        string.
       * @private
       */

    }, {
      key: "_handleFormSuccess",
      value: function _handleFormSuccess(responseContent) {
        this.emit('formSuccess', _objectSpread({}, responseContent, {
          redirectURL: responseContent.redirectURL || ''
        }));
      }
      /**
       * Callback executed when the modal visibility property changes.
       *
       * @private
       */

    }, {
      key: "_handleModalVisibleChanged",
      value: function _handleModalVisibleChanged() {
        this.emit('dialogHidden');
      }
    }]);

    return SimpleInputModal;
  }(_PortletBase2["default"]);
  /**
   * State definition.
   *
   * @static
   * @type {!Object}
   */

  exports.SimpleInputModal = SimpleInputModal;
  SimpleInputModal.STATE = {
    /**
     * Form error message returned by the server.
     *
     * @default ''
     * @instance
     * @memberOf SimpleInputModal
     * @private
     * @type {!string}
     */
    _errorMessage: _metalState.Config.string().internal().value(''),

    /**
     * Flag that checks whether a server response must be detected after a form
     * submission.
     *
     * @default false
     * @instance
     * @memberOf SimpleInputModal
     * @private
     * @type {boolean}
     */
    _loadingResponse: _metalState.Config.bool().internal().value(false),

    /**
     * Optional ClayAlert in SimpleInputModal
     *
     * @default undefined
     * @instance
     * @memberOf SimpleInputModal
     * @type {!object}
     */
    alert: _metalState.Config.shapeOf({
      message: _metalState.Config.string(),
      style: _metalState.Config.string(),
      title: _metalState.Config.string()
    }),

    /**
     * Label for the optional checkbox.
     *
     * @default ''
     * @instance
     * @memberOf SimpleInputModal
     * @type {string}
     */
    checkboxFieldLabel: _metalState.Config.setter(function (checkboxFieldLabel) {
      return (0, _metal.isString)(checkboxFieldLabel) && checkboxFieldLabel ? _metalSoy["default"].toIncDom(checkboxFieldLabel) : '';
    }).string().value(''),

    /**
     * Name for the optional checkbox.
     *
     * @default ''
     * @instance
     * @memberOf SimpleInputModal
     * @type {string}
     */
    checkboxFieldName: _metalState.Config.string().value(''),

    /**
     * Initial value for the optional checkbox.
     *
     * @default false
     * @instance
     * @memberOf SimpleInputModal
     * @type {boolean}
     */
    checkboxFieldValue: _metalState.Config.bool().value(false),

    /**
     * Modal window title.
     *
     * @default undefined
     * @instance
     * @memberOf SimpleInputModal
     * @type {!string}
     */
    dialogTitle: _metalState.Config.string().required(),

    /**
     * Adds a hidden bogus input when necessary to work around some form data +
     * Ajax formatting issues. See {@link
     * https://issues.liferay.com/browse/LPS-86960|LPS-86960} for more details.
     *
     * @default false
     * @instance
     * @memberOf SimpleInputModal
     * @type {!string}
     */
    fixFormData: _metalState.Config.bool().value(false),

    /**
     * URL where the form will be submitted.
     *
     * @default undefined
     * @instance
     * @memberOf SimpleInputModal
     * @type {!string}
     */
    formSubmitURL: _metalState.Config.string().required(),

    /**
     * Autogenerated ID provided by templates.
     *
     * @default ''
     * @instance
     * @memberOf SimpleInputModal
     * @type {string}
     */
    id: _metalState.Config.string().value(''),

    /**
     * Name for the hidden ID field.
     *
     * @default ''
     * @instance
     * @memberOf SimpleInputModal
     * @type {string}
     */
    idFieldName: _metalState.Config.string().value(''),

    /**
     * Value for the hidden ID field.
     *
     * @default ''
     * @instance
     * @memberOf SimpleInputModal
     * @type {string}
     */
    idFieldValue: _metalState.Config.string().value(''),

    /**
     * Label for the main field.
     *
     * @default undefined
     * @instance
     * @memberOf SimpleInputModal
     * @type {!string}
     */
    mainFieldLabel: _metalState.Config.setter(function (mainFieldLabel) {
      return _metalSoy["default"].toIncDom(mainFieldLabel);
    }).string().required(),

    /**
     * Name for the main field.
     *
     * @default undefined
     * @instance
     * @memberOf SimpleInputModal
     * @type {!string}
     */
    mainFieldName: _metalState.Config.string().required(),

    /**
     * Placeholder for the main field.
     *
     * @default ''
     * @instance
     * @memberOf SimpleInputModal
     * @type {string}
     */
    mainFieldPlaceholder: _metalState.Config.string().value(''),

    /**
     * Initial value for the main field.
     *
     * @default ''
     * @instance
     * @memberOf SimpleInputModal
     * @type {string}
     */
    mainFieldValue: _metalState.Config.string().value(''),

    /**
     * Namespace that will be prepended to field names.
     *
     * @default undefined
     * @instance
     * @memberOf SimpleInputModal
     * @type {!string}
     */
    namespace: _metalState.Config.string().required(),

    /**
     * URL for the portal icons being used.
     *
     * @default undefined
     * @instance
     * @memberOf SimpleInputModal
     * @type {!string}
     */
    spritemap: _metalState.Config.string().required()
  };

  _metalSoy["default"].register(SimpleInputModal, _SimpleInputModal["default"]);

  var _default = SimpleInputModal;
  exports["default"] = _default;
  //# sourceMappingURL=SimpleInputModal.es.js.map
});
//# sourceMappingURL=SimpleInputModal.es.js.map