Liferay.Loader.define("frontend-js-web@3.0.53/liferay/debounce/debounce.es", ['module', 'exports', 'require'], function (module, exports, require) {
  var define = undefined;
  Object.defineProperty(exports, "__esModule", {
    value: true
  });
  exports.cancelDebounce = cancelDebounce;
  exports.debounce = debounce;
  exports["default"] = void 0;

  function _toConsumableArray(arr) {
    return _arrayWithoutHoles(arr) || _iterableToArray(arr) || _nonIterableSpread();
  }

  function _nonIterableSpread() {
    throw new TypeError("Invalid attempt to spread non-iterable instance");
  }

  function _iterableToArray(iter) {
    if (Symbol.iterator in Object(iter) || Object.prototype.toString.call(iter) === "[object Arguments]") return Array.from(iter);
  }

  function _arrayWithoutHoles(arr) {
    if (Array.isArray(arr)) {
      for (var i = 0, arr2 = new Array(arr.length); i < arr.length; i++) {
        arr2[i] = arr[i];
      }return arr2;
    }
  }

  /**
   * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
   *
   * This library is free software; you can redistribute it and/or modify it under
   * the terms of the GNU Lesser General Public License as published by the Free
   * Software Foundation; either version 2.1 of the License, or (at your option)
   * any later version.
   *
   * This library is distributed in the hope that it will be useful, but WITHOUT
   * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
   * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
   * details.
   */

  /**
   * Debounces function execution.
   * @param {!function()} fn
   * @param {number} delay
   * @return {!function()}
   */
  function debounce(fn, delay) {
    return function debounced() {
      var args = arguments;
      cancelDebounce(debounced);
      debounced.id = setTimeout(function () {
        fn.apply(void 0, _toConsumableArray(args));
      }, delay);
    };
  }
  /**
   * Cancels the scheduled debounced function.
   * @param {function()} debounced
   */

  function cancelDebounce(debounced) {
    clearTimeout(debounced.id);
  }

  var _default = debounce;
  exports["default"] = _default;
  //# sourceMappingURL=debounce.es.js.map
});
//# sourceMappingURL=debounce.es.js.map