Liferay.Loader.define("frontend-js-web@3.0.53/liferay/compat/progressbar/ProgressBar.es", ['module', 'exports', 'require', 'frontend-js-metal-web$metal', 'frontend-js-metal-web$metal-component', 'frontend-js-metal-web$metal-soy', './ProgressBar.soy'], function (module, exports, require) {
  var define = undefined;
  Object.defineProperty(exports, "__esModule", {
    value: true
  });
  exports["default"] = exports.ProgressBar = void 0;

  var _metal = _interopRequireDefault(require("frontend-js-metal-web$metal"));

  var _metalComponent = _interopRequireDefault(require("frontend-js-metal-web$metal-component"));

  var _metalSoy = _interopRequireDefault(require("frontend-js-metal-web$metal-soy"));

  var _ProgressBar = _interopRequireDefault(require("./ProgressBar.soy"));

  function _interopRequireDefault(obj) {
    return obj && obj.__esModule ? obj : { "default": obj };
  }

  function _typeof(obj) {
    "@babel/helpers - typeof";
    if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") {
      _typeof = function _typeof(obj) {
        return typeof obj;
      };
    } else {
      _typeof = function _typeof(obj) {
        return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj;
      };
    }return _typeof(obj);
  }

  function _classCallCheck(instance, Constructor) {
    if (!(instance instanceof Constructor)) {
      throw new TypeError("Cannot call a class as a function");
    }
  }

  function _defineProperties(target, props) {
    for (var i = 0; i < props.length; i++) {
      var descriptor = props[i];descriptor.enumerable = descriptor.enumerable || false;descriptor.configurable = true;if ("value" in descriptor) descriptor.writable = true;Object.defineProperty(target, descriptor.key, descriptor);
    }
  }

  function _createClass(Constructor, protoProps, staticProps) {
    if (protoProps) _defineProperties(Constructor.prototype, protoProps);if (staticProps) _defineProperties(Constructor, staticProps);return Constructor;
  }

  function _possibleConstructorReturn(self, call) {
    if (call && (_typeof(call) === "object" || typeof call === "function")) {
      return call;
    }return _assertThisInitialized(self);
  }

  function _assertThisInitialized(self) {
    if (self === void 0) {
      throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
    }return self;
  }

  function _getPrototypeOf(o) {
    _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) {
      return o.__proto__ || Object.getPrototypeOf(o);
    };return _getPrototypeOf(o);
  }

  function _inherits(subClass, superClass) {
    if (typeof superClass !== "function" && superClass !== null) {
      throw new TypeError("Super expression must either be null or a function");
    }subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } });if (superClass) _setPrototypeOf(subClass, superClass);
  }

  function _setPrototypeOf(o, p) {
    _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) {
      o.__proto__ = p;return o;
    };return _setPrototypeOf(o, p);
  }

  /**
   * UI Component that renders a progress bar.
   * @deprecated since 7.2
   */
  var ProgressBar = /*#__PURE__*/function (_Component) {
    _inherits(ProgressBar, _Component);

    function ProgressBar() {
      _classCallCheck(this, ProgressBar);

      return _possibleConstructorReturn(this, _getPrototypeOf(ProgressBar).apply(this, arguments));
    }

    _createClass(ProgressBar, [{
      key: "setterValueFn_",

      /**
       * Setter function for the `value` state key. Makes sure the value
       * is between the current `min` and `max` state keys.
       * @param {number} value
       * @return {number}
       * @protected
       */
      value: function setterValueFn_(value) {
        if (value < this.min) {
          value = this.min;
        }

        if (value > this.max) {
          value = this.max;
        }

        return value;
      }
      /**
       * Synchronization logic for the `max` state.
       * @param {number} max
       */

    }, {
      key: "syncMax",
      value: function syncMax(max) {
        if (max < this.value) {
          this.value = max;
        }
      }
      /**
       * Synchronization logic for the `min` state.
       * @param {number} min
       */

    }, {
      key: "syncMin",
      value: function syncMin(min) {
        if (min > this.value) {
          this.value = min;
        }
      }
    }]);

    return ProgressBar;
  }(_metalComponent["default"]);
  /**
   * State definition.
   * @type {!Object}
   * @static
   */

  exports.ProgressBar = ProgressBar;
  ProgressBar.STATE = {
    /**
     * Optional CSS classes to be added to the inner progress bar element,
     * like 'progress-bar-danger'.
     * @type {string}
     */
    barClass: {
      validator: _metal["default"].isString
    },

    /**
     * An optional label to be rendered inside the progress bar. Can be either
     * a string (with raw text or html) or an incremental dom function.
     * @type {(function|string)}
     */
    label: {
      validator: function validator(label) {
        return !_metal["default"].isDefAndNotNull(label) || _metal["default"].isString(label) || _metal["default"].isFunction(label);
      }
    },

    /**
     * The maximum value of the progress bar. When the value is at its
     * max, the bar will be fully extended.
     * @type {number}
     */
    max: {
      validator: _metal["default"].isNumber,
      value: 100
    },

    /**
     * The minimum value of the progress bar. When the value is at its
     * max, the bar will be fully collapsed.
     * @type {number}
     */
    min: {
      validator: _metal["default"].isNumber,
      value: 0
    },

    /**
     * The current value of the progress bar.
     * @type {number}
     */
    value: {
      setter: 'setterValueFn_',
      validator: _metal["default"].isNumber,
      value: 0
    }
  };

  _metalSoy["default"].register(ProgressBar, _ProgressBar["default"]);

  var _default = ProgressBar;
  exports["default"] = _default;
  //# sourceMappingURL=ProgressBar.es.js.map
});
//# sourceMappingURL=ProgressBar.es.js.map