"use strict";

Liferay.Loader.define("frontend-js-web@3.0.12/liferay/util/address/get_regions.es", ['module', 'exports', 'require', 'frontend-js-metal-web$metal'], function (module, exports, require) {
  var define = undefined;
  Object.defineProperty(exports, "__esModule", {
    value: true
  });
  exports.default = getRegions;

  var _metal = require("frontend-js-metal-web$metal");

  /**
   * Returns a list of regions by country
   * @callback callback
   * @param {!string} selectKey The selected region ID
   * @return {array} Array of regions by country
   */
  function getRegions(callback, selectKey) {
    if (!(0, _metal.isFunction)(callback)) {
      throw new TypeError('Parameter callback must be a function');
    }

    if (!(0, _metal.isString)(selectKey)) {
      throw new TypeError('Parameter selectKey must be a string');
    }

    Liferay.Service('/region/get-regions', {
      active: true,
      countryId: parseInt(selectKey, 10)
    }, callback);
  }
  //# sourceMappingURL=get_regions.es.js.map
});
//# sourceMappingURL=get_regions.es.js.map