"use strict";

Liferay.Loader.define("frontend-js-web@3.0.12/liferay/portlet/RenderState.es", ['module', 'exports', 'require', 'frontend-js-metal-web$metal', './portlet_constants.es'], function (module, exports, require) {
  var define = undefined;
  Object.defineProperty(exports, "__esModule", {
    value: true
  });
  exports.default = exports.RenderState = void 0;

  var _metal = require("frontend-js-metal-web$metal");

  var _portlet_constants = _interopRequireDefault(require("./portlet_constants.es"));

  function _interopRequireDefault(obj) {
    return obj && obj.__esModule ? obj : { default: obj };
  }

  function _classCallCheck(instance, Constructor) {
    if (!(instance instanceof Constructor)) {
      throw new TypeError("Cannot call a class as a function");
    }
  }

  function _defineProperties(target, props) {
    for (var i = 0; i < props.length; i++) {
      var descriptor = props[i];descriptor.enumerable = descriptor.enumerable || false;descriptor.configurable = true;if ("value" in descriptor) descriptor.writable = true;Object.defineProperty(target, descriptor.key, descriptor);
    }
  }

  function _createClass(Constructor, protoProps, staticProps) {
    if (protoProps) _defineProperties(Constructor.prototype, protoProps);if (staticProps) _defineProperties(Constructor, staticProps);return Constructor;
  }

  var RenderState =
  /*#__PURE__*/
  function () {
    function RenderState(state) {
      _classCallCheck(this, RenderState);

      if ((0, _metal.isObject)(state)) {
        this.from(state);
      } else {
        this.parameters = {};
        this.portletMode = _portlet_constants.default.VIEW;
        this.windowState = _portlet_constants.default.NORMAL;
      }
    }
    /**
     * Clone returns a copy of this RenderState instance.
     * @memberof RenderState
     * @return {RenderState} A RenderState instance with same properties.
     * @review
     */

    _createClass(RenderState, [{
      key: "clone",
      value: function clone() {
        return new RenderState(this);
      }
      /**
       * Set the properties of a RenderState instance based on another RenderState
       * @memberof RenderState
       * @review
       */

    }, {
      key: "from",
      value: function from(renderState) {
        this.parameters = {};

        for (var name in renderState.parameters) {
          if (renderState.parameters.hasOwnProperty(name) && Array.isArray(renderState.parameters[name])) {
            this.parameters[name] = renderState.parameters[name].slice(0);
          }
        }

        this.setPortletMode(renderState.portletMode);
        this.setWindowState(renderState.windowState);
      }
      /**
       * Returns the portletMode for this RenderState.
       * @memberof RenderState
       * @return {String} The portletMode for this render state
       * @review
       */

    }, {
      key: "getPortletMode",
      value: function getPortletMode() {
        return this.portletMode;
      }
      /**
       * Returns the string parameter value for the given name.
       * If name designates a multi-valued parameter this function returns
       * the first value in the values array. If the parameter is undefined
       * this function returns the optional default parameter <code>defaultValue</code>.
       * @memberof RenderState
       * @param {String} name The name of the parameter to retreive.
       * @param {?String} defaultValue  The default value of the parameter in case it is undefined.
       * @return {String} The value of the parameter
       * @review
       */

    }, {
      key: "getValue",
      value: function getValue(name, defaultValue) {
        if (!(0, _metal.isString)(name)) {
          throw new TypeError('Parameter name must be a string');
        }

        var value = this.parameters[name];

        if (Array.isArray(value)) {
          value = value[0];
        }

        if (value === undefined && defaultValue !== undefined) {
          value = defaultValue;
        }

        return value;
      }
      /**
       * Gets the string array parameter value for the given <code>name</code>.
       * If the parameter for the given name is undefined, this function
       * returns the optional default value array <code>def</code>.
       * @memberof RenderState
       * @param {String} name  The name of the parameter to retrieve.
       * @param {?Array} defaultValue   The default value for the parameter if it is undefined.
       * @return {Array}
       * @review
       */

    }, {
      key: "getValues",
      value: function getValues(name, defaultValue) {
        if (!(0, _metal.isString)(name)) {
          throw new TypeError('Parameter name must be a string');
        }

        var value = this.parameters[name];
        return value ? value : defaultValue;
      }
      /**
       * Returns the windowState for this RenderState.
       * @memberof RenderState
       * @return {String} the window state for this render state
       * @review
       */

    }, {
      key: "getWindowState",
      value: function getWindowState() {
        return this.windowState;
      }
      /**
       * Removes the parameter with the given name.
       * @memberof RenderState
       * @param {String} name The name of the parameter to be removed.
       * @review
       */

    }, {
      key: "remove",
      value: function remove(name) {
        if (!(0, _metal.isString)(name)) {
          throw new TypeError('Parameter name must be a string');
        }

        if (this.parameters[name] !== undefined) {
          delete this.parameters[name];
        }
      }
      /**
       * Sets the portletMode to the specified value.
       * @memberof RenderState
       * @param {String} portletMode The portlet mode to be set.
       * @review
       * @see {PortletConstants}
       */

    }, {
      key: "setPortletMode",
      value: function setPortletMode(portletMode) {
        if (!(0, _metal.isString)(portletMode)) {
          throw new TypeError('Portlet Mode must be a string');
        }

        if (portletMode === _portlet_constants.default.EDIT || portletMode === _portlet_constants.default.HELP || portletMode === _portlet_constants.default.VIEW) {
          this.portletMode = portletMode;
        }
      }
      /**
       * Sets a parameter with a given name and value.
       * The value may be a string or an array.
       * @memberof RenderState
       * @param {String} name	The name of the parameter.
       * @param {Array|String} value  The value of the parameter.
       * @review
       */

    }, {
      key: "setValue",
      value: function setValue(name, value) {
        if (!(0, _metal.isString)(name)) {
          throw new TypeError('Parameter name must be a string');
        }

        if (!(0, _metal.isString)(value) && value !== null && !Array.isArray(value)) {
          throw new TypeError('Parameter value must be a string, an array or null');
        }

        if (!Array.isArray(value)) {
          value = [value];
        }

        this.parameters[name] = value;
      }
      /**
       * Sets a parameter with a given name and value.
       * The value may be a string or an array.
       * @memberof RenderState
       * @param {String} name	The name of the parameter.
       * @param {Array|String} value  The value of the parameter.
       * @review
       */

    }, {
      key: "setValues",
      value: function setValues(name, value) {
        this.setValue(name, value);
      }
      /**
       * Sets the windowState to the specified value.
       * @memberof RenderState
       * @param {String} windowSstate The window state to be set.
       * @return {String}
       * @review
       * @see {PortletConstants}
       */

    }, {
      key: "setWindowState",
      value: function setWindowState(windowState) {
        if (!(0, _metal.isString)(windowState)) {
          throw new TypeError('Window State must be a string');
        }

        if (windowState === _portlet_constants.default.MAXIMIZED || windowState === _portlet_constants.default.MINIMIZED || windowState === _portlet_constants.default.NORMAL) {
          this.windowState = windowState;
        }
      }
    }]);

    return RenderState;
  }();

  exports.RenderState = RenderState;
  var _default = RenderState;
  exports.default = _default;
  //# sourceMappingURL=RenderState.es.js.map
});
//# sourceMappingURL=RenderState.es.js.map