"use strict";

Liferay.Loader.define("frontend-js-web@3.0.12/liferay/modal/components/SimpleInputModal.es", ['module', 'exports', 'require', 'frontend-js-metal-web$metal-state', 'frontend-js-metal-web$metal', 'frontend-js-metal-web$metal-soy', '../../compat/modal/Modal.es', '../../PortletBase.es', './SimpleInputModal.soy'], function (module, exports, require) {
  var define = undefined;
  Object.defineProperty(exports, "__esModule", {
    value: true
  });
  exports.default = exports.SimpleInputModal = void 0;

  var _metalState = require("frontend-js-metal-web$metal-state");

  var _metal = require("frontend-js-metal-web$metal");

  var _metalSoy = _interopRequireDefault(require("frontend-js-metal-web$metal-soy"));

  require("../../compat/modal/Modal.es");

  var _PortletBase2 = _interopRequireDefault(require("../../PortletBase.es"));

  var _SimpleInputModal = _interopRequireDefault(require("./SimpleInputModal.soy"));

  function _interopRequireDefault(obj) {
    return obj && obj.__esModule ? obj : { default: obj };
  }

  function _typeof(obj) {
    if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") {
      _typeof = function _typeof(obj) {
        return typeof obj;
      };
    } else {
      _typeof = function _typeof(obj) {
        return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj;
      };
    }return _typeof(obj);
  }

  function _classCallCheck(instance, Constructor) {
    if (!(instance instanceof Constructor)) {
      throw new TypeError("Cannot call a class as a function");
    }
  }

  function _defineProperties(target, props) {
    for (var i = 0; i < props.length; i++) {
      var descriptor = props[i];descriptor.enumerable = descriptor.enumerable || false;descriptor.configurable = true;if ("value" in descriptor) descriptor.writable = true;Object.defineProperty(target, descriptor.key, descriptor);
    }
  }

  function _createClass(Constructor, protoProps, staticProps) {
    if (protoProps) _defineProperties(Constructor.prototype, protoProps);if (staticProps) _defineProperties(Constructor, staticProps);return Constructor;
  }

  function _possibleConstructorReturn(self, call) {
    if (call && (_typeof(call) === "object" || typeof call === "function")) {
      return call;
    }return _assertThisInitialized(self);
  }

  function _assertThisInitialized(self) {
    if (self === void 0) {
      throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
    }return self;
  }

  function _getPrototypeOf(o) {
    _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) {
      return o.__proto__ || Object.getPrototypeOf(o);
    };return _getPrototypeOf(o);
  }

  function _inherits(subClass, superClass) {
    if (typeof superClass !== "function" && superClass !== null) {
      throw new TypeError("Super expression must either be null or a function");
    }subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } });if (superClass) _setPrototypeOf(subClass, superClass);
  }

  function _setPrototypeOf(o, p) {
    _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) {
      o.__proto__ = p;return o;
    };return _setPrototypeOf(o, p);
  }

  /**
   * SimpleInputModal
   * @review
   */
  var SimpleInputModal =
  /*#__PURE__*/
  function (_PortletBase) {
    _inherits(SimpleInputModal, _PortletBase);

    function SimpleInputModal() {
      _classCallCheck(this, SimpleInputModal);

      return _possibleConstructorReturn(this, _getPrototypeOf(SimpleInputModal).apply(this, arguments));
    }

    _createClass(SimpleInputModal, [{
      key: "attached",

      /**
       * @inheritDoc
       * @review
       */
      value: function attached() {
        this.addListener('formSubmit', this._defaultFormSubmit.bind(this), true);
      }
      /**
       * @inheritDoc
       * @review
       */

    }, {
      key: "rendered",
      value: function rendered() {
        var _this = this;

        requestAnimationFrame(function () {
          _this.refs.modal.refs.mainField.focus();
        });
      }
      /**
       * Default event listener for form submission.
       * @param {Event} event
       * @private
       * @review
       */

    }, {
      key: "_defaultFormSubmit",
      value: function _defaultFormSubmit(event) {
        var _this2 = this;

        this.fetch(this.formSubmitURL, event.form).then(function (response) {
          return response.json();
        }).then(function (responseContent) {
          if (responseContent.error) {
            _this2._loadingResponse = false;

            _this2._handleFormError(responseContent);
          } else {
            _this2._handleFormSuccess(responseContent);
          }
        }).catch(function (response) {
          _this2._handleFormError(response);
        });
        this._loadingResponse = true;
      }
      /**
       * Callback executed when the SimpleInputModal cancel button
       * has been clicked.
       * @private
       * @review
       */

    }, {
      key: "_handleCancelButtonClick",
      value: function _handleCancelButtonClick() {
        this.emit('cancelButtonClicked');
      }
      /**
       * Callback executed when the SimpleInputModal form has been
       * submited and it receives a server error as response.
       * It emits a formError event with the errorMessage received.
       * @param {{error: string}} responseContent
       * @private
       * @review
       */

    }, {
      key: "_handleFormError",
      value: function _handleFormError(responseContent) {
        this._errorMessage = responseContent.error || '';
        this.emit('formError', {
          errorMessage: this._errorMessage
        });
      }
      /**
       * Callback executed when the SimpleInputModal form has been
       * submited. It prevents the default behaviour and sends this form
       * using a fetch request.
       * @param {Event} event
       * @private
       * @review
       */

    }, {
      key: "_handleFormSubmit",
      value: function _handleFormSubmit(event) {
        event.preventDefault();
        this.emit('formSubmit', {
          form: this.refs.modal.refs.form
        });
      }
      /**
       * Callback executed when the SimpleInputModal form has been
       * submited and it receives a server successful response.
       * It emits a formSuccess event with the redirectURL received.
       * @param {{redirectURL: string}} responseContent
       * @private
       * @review
       */

    }, {
      key: "_handleFormSuccess",
      value: function _handleFormSuccess(responseContent) {
        this.emit('formSuccess', {
          redirectURL: responseContent.redirectURL || ''
        });
      }
      /**
       * Callback executed when the modal visibility property changes
       * @private
       * @review
       */

    }, {
      key: "_handleModalVisibleChanged",
      value: function _handleModalVisibleChanged() {
        this.emit('dialogHidden');
      }
    }]);

    return SimpleInputModal;
  }(_PortletBase2.default);
  /**
   * State definition.
   * @review
   * @static
   * @type {!Object}
   */

  exports.SimpleInputModal = SimpleInputModal;
  SimpleInputModal.STATE = {
    /**
     * Label for the optional checkbox
     * @default ''
     * @instance
     * @memberOf SimpleInputModal
     * @review
     * @type {string}
     */
    checkboxFieldLabel: _metalState.Config.setter(function (checkboxFieldLabel) {
      return (0, _metal.isString)(checkboxFieldLabel) && checkboxFieldLabel ? _metalSoy.default.toIncDom(checkboxFieldLabel) : '';
    }).string().value(''),

    /**
     * Name for the optional checkbox
     * @default ''
     * @instance
     * @memberOf SimpleInputModal
     * @review
     * @type {string}
     */
    checkboxFieldName: _metalState.Config.string().value(''),

    /**
     * Initial value for the optional checkbox
     * @default false
     * @instance
     * @memberOf SimpleInputModal
     * @review
     * @type {boolean}
     */
    checkboxFieldValue: _metalState.Config.bool().value(false),

    /**
     * Modal window title
     * @default undefined
     * @instance
     * @memberOf SimpleInputModal
     * @review
     * @type {!string}
     */
    dialogTitle: _metalState.Config.string().required(),

    /**
     * Adds a hidden bogus input when necessary to work around some formdata + ajax
     * formatting issues. See LPS-86960 for more details
     * @default false
     * @instance
     * @memberOf SimpleInputModal
     * @review
     * @type {!string}
     */
    fixFormData: _metalState.Config.bool().value(false),

    /**
     * URL where the form will be submitted to
     * @default undefined
     * @instance
     * @memberOf SimpleInputModal
     * @review
     * @type {!string}
     */
    formSubmitURL: _metalState.Config.string().required(),

    /**
     * Autogenerated id provided by templates
     * @default ''
     * @instance
     * @memberOf SimpleInputModal
     * @review
     * @type {string}
     */
    id: _metalState.Config.string().value(''),

    /**
     * Name for the hidden id field
     * @default ''
     * @instance
     * @memberOf SimpleInputModal
     * @review
     * @type {string}
     */
    idFieldName: _metalState.Config.string().value(''),

    /**
     * Value for the hidden id field
     * @default ''
     * @instance
     * @memberOf SimpleInputModal
     * @review
     * @type {string}
     */
    idFieldValue: _metalState.Config.string().value(''),

    /**
     * Label for the main field
     * @default undefined
     * @instance
     * @memberOf SimpleInputModal
     * @review
     * @type {!string}
     */
    mainFieldLabel: _metalState.Config.setter(function (mainFieldLabel) {
      return _metalSoy.default.toIncDom(mainFieldLabel);
    }).string().required(),

    /**
     * Name for the main field
     * @default undefined
     * @instance
     * @memberOf SimpleInputModal
     * @review
     * @type {!string}
     */
    mainFieldName: _metalState.Config.string().required(),

    /**
     * Placeholder for the main field
     * @default ''
     * @instance
     * @memberOf SimpleInputModal
     * @review
     * @type {string}
     */
    mainFieldPlaceholder: _metalState.Config.string().value(''),

    /**
     * Initial value for the main field
     * @default ''
     * @instance
     * @memberOf SimpleInputModal
     * @review
     * @type {string}
     */
    mainFieldValue: _metalState.Config.string().value(''),

    /**
     * Namespace that will be prepended to field names
     * @default undefined
     * @instance
     * @memberOf SimpleInputModal
     * @review
     * @type {!string}
     */
    namespace: _metalState.Config.string().required(),

    /**
     * URL for the portal icons being used
     * @default undefined
     * @instance
     * @memberOf SimpleInputModal
     * @review
     * @type {!string}
     */
    spritemap: _metalState.Config.string().required(),

    /**
     * Form error message returned by the server
     * @default ''
     * @instance
     * @memberOf SimpleInputModal
     * @private
     * @review
     * @type {!string}
     */
    _errorMessage: _metalState.Config.string().internal().value(''),

    /**
     * Flag indicating if we are waiting for a server response
     * after a form submission.
     * @default false
     * @instance
     * @memberOf SimpleInputModal
     * @private
     * @review
     * @type {boolean}
     */
    _loadingResponse: _metalState.Config.bool().internal().value(false)
  };

  _metalSoy.default.register(SimpleInputModal, _SimpleInputModal.default);

  var _default = SimpleInputModal;
  exports.default = _default;
  //# sourceMappingURL=SimpleInputModal.es.js.map
});
//# sourceMappingURL=SimpleInputModal.es.js.map