"use strict";

Liferay.Loader.define("frontend-js-web@3.0.12/liferay/compat/tooltip/TooltipBase.es", ['module', 'exports', 'require', 'frontend-js-metal-web$metal', 'frontend-js-metal-web$metal-dom', 'frontend-js-metal-web$metal-position', 'frontend-js-metal-web$metal-component', 'frontend-js-metal-web$metal-events'], function (module, exports, require) {
  var define = undefined;
  Object.defineProperty(exports, "__esModule", {
    value: true
  });
  exports.default = exports.TooltipBase = void 0;

  var _metal = _interopRequireDefault(require("frontend-js-metal-web$metal"));

  var _metalDom = _interopRequireDefault(require("frontend-js-metal-web$metal-dom"));

  var _metalPosition = require("frontend-js-metal-web$metal-position");

  var _metalComponent = _interopRequireDefault(require("frontend-js-metal-web$metal-component"));

  var _metalEvents = require("frontend-js-metal-web$metal-events");

  function _interopRequireDefault(obj) {
    return obj && obj.__esModule ? obj : { default: obj };
  }

  function _typeof(obj) {
    if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") {
      _typeof = function _typeof(obj) {
        return typeof obj;
      };
    } else {
      _typeof = function _typeof(obj) {
        return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj;
      };
    }return _typeof(obj);
  }

  function _classCallCheck(instance, Constructor) {
    if (!(instance instanceof Constructor)) {
      throw new TypeError("Cannot call a class as a function");
    }
  }

  function _defineProperties(target, props) {
    for (var i = 0; i < props.length; i++) {
      var descriptor = props[i];descriptor.enumerable = descriptor.enumerable || false;descriptor.configurable = true;if ("value" in descriptor) descriptor.writable = true;Object.defineProperty(target, descriptor.key, descriptor);
    }
  }

  function _createClass(Constructor, protoProps, staticProps) {
    if (protoProps) _defineProperties(Constructor.prototype, protoProps);if (staticProps) _defineProperties(Constructor, staticProps);return Constructor;
  }

  function _possibleConstructorReturn(self, call) {
    if (call && (_typeof(call) === "object" || typeof call === "function")) {
      return call;
    }return _assertThisInitialized(self);
  }

  function _assertThisInitialized(self) {
    if (self === void 0) {
      throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
    }return self;
  }

  function _get(target, property, receiver) {
    if (typeof Reflect !== "undefined" && Reflect.get) {
      _get = Reflect.get;
    } else {
      _get = function _get(target, property, receiver) {
        var base = _superPropBase(target, property);if (!base) return;var desc = Object.getOwnPropertyDescriptor(base, property);if (desc.get) {
          return desc.get.call(receiver);
        }return desc.value;
      };
    }return _get(target, property, receiver || target);
  }

  function _superPropBase(object, property) {
    while (!Object.prototype.hasOwnProperty.call(object, property)) {
      object = _getPrototypeOf(object);if (object === null) break;
    }return object;
  }

  function _getPrototypeOf(o) {
    _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) {
      return o.__proto__ || Object.getPrototypeOf(o);
    };return _getPrototypeOf(o);
  }

  function _inherits(subClass, superClass) {
    if (typeof superClass !== "function" && superClass !== null) {
      throw new TypeError("Super expression must either be null or a function");
    }subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } });if (superClass) _setPrototypeOf(subClass, superClass);
  }

  function _setPrototypeOf(o, p) {
    _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) {
      o.__proto__ = p;return o;
    };return _setPrototypeOf(o, p);
  }

  /**
   * The base class to be shared between components that have tooltip behavior.
   * This helps decouple this behavior logic from the UI, which may be different
   * between components. The Tooltip component itself extends from this, as does
   * the crystal Popover component, which can be accessed at metal/crystal-popover.
   */
  var TooltipBase =
  /*#__PURE__*/
  function (_Component) {
    _inherits(TooltipBase, _Component);

    function TooltipBase() {
      _classCallCheck(this, TooltipBase);

      return _possibleConstructorReturn(this, _getPrototypeOf(TooltipBase).apply(this, arguments));
    }

    _createClass(TooltipBase, [{
      key: "attached",

      /**
       * @inheritDoc
       */
      value: function attached() {
        this.align();
        this.syncTriggerEvents(this.triggerEvents);
      }
      /**
       * @inheritDoc
       */

    }, {
      key: "created",
      value: function created() {
        this.currentAlignElement = this.alignElement;
        this.eventHandler_ = new _metalEvents.EventHandler();
      }
      /**
       * @inheritDoc
       */

    }, {
      key: "detached",
      value: function detached() {
        this.eventHandler_.removeAllListeners();
      }
      /**
       * @inheritDoc
       */

    }, {
      key: "disposeInternal",
      value: function disposeInternal() {
        _get(_getPrototypeOf(TooltipBase.prototype), "disposeInternal", this).call(this);

        clearTimeout(this.delay_);
      }
      /**
       * Aligns the tooltip with the best region around alignElement. The best
       * region is defined by clockwise rotation starting from the specified
       * `position`. The element is always aligned in the middle of alignElement
       * axis.
       * @param {Element=} opt_alignElement Optional element to align with.
       */

    }, {
      key: "align",
      value: function align(opt_alignElement) {
        this.syncCurrentAlignElement(opt_alignElement || this.currentAlignElement);
      }
      /**
       * @param {!function()} fn
       * @param {number} delay
       * @private
       */

    }, {
      key: "callAsync_",
      value: function callAsync_(fn, delay) {
        clearTimeout(this.delay_);
        this.delay_ = setTimeout(fn.bind(this), delay);
      }
      /**
       * Handles hide event triggered by `events`.
       * @param {!Event} event
       * @protected
       */

    }, {
      key: "handleHide",
      value: function handleHide(event) {
        var delegateTarget = event.delegateTarget;
        var interactingWithDifferentTarget = delegateTarget && delegateTarget !== this.currentAlignElement;
        this.callAsync_(function () {
          if (this.locked_) {
            return;
          }

          if (interactingWithDifferentTarget) {
            this.currentAlignElement = delegateTarget;
          } else {
            this.visible = false;
            this.syncVisible(false);
          }
        }, this.delay[1]);
      }
      /**
       * Handles show event triggered by `events`.
       * @param {!Event} event
       * @protected
       */

    }, {
      key: "handleShow",
      value: function handleShow(event) {
        var delegateTarget = event.delegateTarget;

        _get(_getPrototypeOf(TooltipBase.prototype), "syncVisible", this).call(this, true);

        this.callAsync_(function () {
          this.currentAlignElement = delegateTarget;
          this.visible = true;
        }, this.delay[0]);
      }
      /**
       * Handles toggle event triggered by `events`.
       * @param {!Event} event
       * @protected
       */

    }, {
      key: "handleToggle",
      value: function handleToggle(event) {
        if (this.visible) {
          this.handleHide(event);
        } else {
          this.handleShow(event);
        }
      }
      /**
       * Locks tooltip visibility.
       * @param {!Event} event
       */

    }, {
      key: "lock",
      value: function lock() {
        this.locked_ = true;
      }
      /**
       * Unlocks tooltip visibility.
       * @param {!Event} event
       */

    }, {
      key: "unlock",
      value: function unlock(event) {
        this.locked_ = false;
        this.handleHide(event);
      }
      /**
       * Synchronizes the value of the `currentAlignElement` internal state
       * with the `alignElement`.
       * @param {Element} alignElement
       */

    }, {
      key: "syncAlignElement",
      value: function syncAlignElement(alignElement) {
        this.currentAlignElement = alignElement;
      }
      /**
       * State synchronization logic for `currentAlignElement`.
       * @param {Element} alignElement
       * @param {Element} prevAlignElement
       */

    }, {
      key: "syncCurrentAlignElement",
      value: function syncCurrentAlignElement(alignElement, prevAlignElement) {
        if (prevAlignElement) {
          alignElement.removeAttribute('aria-describedby');
        }

        if (alignElement) {
          var dataTitle = alignElement.getAttribute('data-title');

          if (dataTitle) {
            this.title = dataTitle;
          }

          if (this.inDocument) {
            this.alignedPosition = TooltipBase.Align.align(this.element, alignElement, this.position);
          }
        }
      }
      /**
       * State synchronization logic for `position`.
       */

    }, {
      key: "syncPosition",
      value: function syncPosition() {
        this.syncCurrentAlignElement(this.currentAlignElement);
      }
      /**
       * State synchronization logic for `selector`.
       */

    }, {
      key: "syncSelector",
      value: function syncSelector() {
        this.syncTriggerEvents(this.triggerEvents);
      }
      /**
       * State synchronization logic for `triggerEvents`.
       * @param {!Array<string>} triggerEvents
       */

    }, {
      key: "syncTriggerEvents",
      value: function syncTriggerEvents(triggerEvents) {
        if (!this.inDocument) {
          return;
        }

        this.eventHandler_.removeAllListeners();
        var selector = this.selector;

        if (!selector) {
          return;
        }

        this.eventHandler_.add(this.on('mouseenter', this.lock), this.on('mouseleave', this.unlock));

        if (triggerEvents[0] === triggerEvents[1]) {
          this.eventHandler_.add(_metalDom.default.delegate(document, triggerEvents[0], selector, this.handleToggle.bind(this)));
        } else {
          this.eventHandler_.add(_metalDom.default.delegate(document, triggerEvents[0], selector, this.handleShow.bind(this)), _metalDom.default.delegate(document, triggerEvents[1], selector, this.handleHide.bind(this)));
        }
      }
      /**
       * State synchronization logic for `visible`. Realigns the tooltip.
       */

    }, {
      key: "syncVisible",
      value: function syncVisible() {
        this.align();
      }
    }]);

    return TooltipBase;
  }(_metalComponent.default);
  /**
   * @inheritDoc
   * @see `Align` class.
   * @static
   */

  exports.TooltipBase = TooltipBase;
  TooltipBase.Align = _metalPosition.Align;
  /**
   * TooltipBase state definition.
   * @type {!Object}
   * @static
   */

  TooltipBase.STATE = {
    /**
     * The current position of the tooltip after being aligned via `Align.align`.
     * @type {number}
     */
    alignedPosition: {
      validator: TooltipBase.Align.isValidPosition
    },

    /**
     * Element to align tooltip with.
     * @type {Element}
     */
    alignElement: {
      setter: _metalDom.default.toElement
    },

    /**
     * The current element aligned tooltip with.
     * @type {Element}
     */
    currentAlignElement: {
      internal: true,
      setter: _metalDom.default.toElement
    },

    /**
     * Delay showing and hiding the tooltip (ms).
     * @type {!Array<number>}
     * @default [ 500, 250 ]
     */
    delay: {
      validator: Array.isArray,
      value: [500, 250]
    },

    /**
     * Trigger events used to bind handlers to show and hide tooltip.
     * @type {!Array<string>}
     * @default ['mouseenter', 'mouseleave']
     */
    triggerEvents: {
      validator: Array.isArray,
      value: ['mouseenter', 'mouseleave']
    },

    /**
     * If a selector is provided, tooltip objects will be delegated to the
     * specified targets by setting the `alignElement`.
     * @type {?string}
     */
    selector: {
      validator: _metal.default.isString
    },

    /**
     * The position to try alignment. If not possible the best position will be
     * found.
     * @type {number}
     * @default Align.Bottom
     */
    position: {
      validator: TooltipBase.Align.isValidPosition,
      value: TooltipBase.Align.Bottom
    },

    /**
     * Content to be placed inside tooltip.
     * @type {string}
     */
    title: {}
  };
  /**
   * CSS classes used for each align position.
   * @type {!Array}
   * @static
   */

  TooltipBase.PositionClasses = ['top', 'right', 'bottom', 'left'];
  var _default = TooltipBase;
  exports.default = _default;
  //# sourceMappingURL=TooltipBase.es.js.map
});
//# sourceMappingURL=TooltipBase.es.js.map