"use strict";

Liferay.Loader.define("frontend-js-web@3.0.12/liferay/compat/slider/Slider.es", ['module', 'exports', 'require', 'frontend-js-metal-web$metal', 'frontend-js-metal-web$metal-dom', 'frontend-js-metal-web$metal-component', 'frontend-js-metal-web$metal-drag-drop', 'frontend-js-metal-web$metal-position', 'frontend-js-metal-web$metal-soy', './Slider.soy'], function (module, exports, require) {
  var define = undefined;
  Object.defineProperty(exports, "__esModule", {
    value: true
  });
  exports.default = exports.Slider = void 0;

  var _metal = _interopRequireDefault(require("frontend-js-metal-web$metal"));

  var _metalDom = _interopRequireDefault(require("frontend-js-metal-web$metal-dom"));

  var _metalComponent = _interopRequireDefault(require("frontend-js-metal-web$metal-component"));

  var _metalDragDrop = require("frontend-js-metal-web$metal-drag-drop");

  var _metalPosition = _interopRequireDefault(require("frontend-js-metal-web$metal-position"));

  var _metalSoy = _interopRequireDefault(require("frontend-js-metal-web$metal-soy"));

  var _Slider = _interopRequireDefault(require("./Slider.soy"));

  function _interopRequireDefault(obj) {
    return obj && obj.__esModule ? obj : { default: obj };
  }

  function _typeof(obj) {
    if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") {
      _typeof = function _typeof(obj) {
        return typeof obj;
      };
    } else {
      _typeof = function _typeof(obj) {
        return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj;
      };
    }return _typeof(obj);
  }

  function _classCallCheck(instance, Constructor) {
    if (!(instance instanceof Constructor)) {
      throw new TypeError("Cannot call a class as a function");
    }
  }

  function _defineProperties(target, props) {
    for (var i = 0; i < props.length; i++) {
      var descriptor = props[i];descriptor.enumerable = descriptor.enumerable || false;descriptor.configurable = true;if ("value" in descriptor) descriptor.writable = true;Object.defineProperty(target, descriptor.key, descriptor);
    }
  }

  function _createClass(Constructor, protoProps, staticProps) {
    if (protoProps) _defineProperties(Constructor.prototype, protoProps);if (staticProps) _defineProperties(Constructor, staticProps);return Constructor;
  }

  function _possibleConstructorReturn(self, call) {
    if (call && (_typeof(call) === "object" || typeof call === "function")) {
      return call;
    }return _assertThisInitialized(self);
  }

  function _assertThisInitialized(self) {
    if (self === void 0) {
      throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
    }return self;
  }

  function _get(target, property, receiver) {
    if (typeof Reflect !== "undefined" && Reflect.get) {
      _get = Reflect.get;
    } else {
      _get = function _get(target, property, receiver) {
        var base = _superPropBase(target, property);if (!base) return;var desc = Object.getOwnPropertyDescriptor(base, property);if (desc.get) {
          return desc.get.call(receiver);
        }return desc.value;
      };
    }return _get(target, property, receiver || target);
  }

  function _superPropBase(object, property) {
    while (!Object.prototype.hasOwnProperty.call(object, property)) {
      object = _getPrototypeOf(object);if (object === null) break;
    }return object;
  }

  function _getPrototypeOf(o) {
    _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) {
      return o.__proto__ || Object.getPrototypeOf(o);
    };return _getPrototypeOf(o);
  }

  function _inherits(subClass, superClass) {
    if (typeof superClass !== "function" && superClass !== null) {
      throw new TypeError("Super expression must either be null or a function");
    }subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } });if (superClass) _setPrototypeOf(subClass, superClass);
  }

  function _setPrototypeOf(o, p) {
    _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) {
      o.__proto__ = p;return o;
    };return _setPrototypeOf(o, p);
  }

  /**
   * Slider component.
   * @deprecated since 7.2
   */
  var Slider =
  /*#__PURE__*/
  function (_Component) {
    _inherits(Slider, _Component);

    function Slider() {
      _classCallCheck(this, Slider);

      return _possibleConstructorReturn(this, _getPrototypeOf(Slider).apply(this, arguments));
    }

    _createClass(Slider, [{
      key: "attached",

      /**
       * @inheritDoc
       */
      value: function attached() {
        this.drag_ = new _metalDragDrop.Drag({
          axis: 'x',
          constrain: this.constrainToRail_.bind(this),
          container: this.element,
          handles: '.handle',
          sources: '.rail-handle'
        });
        this.on('elementChanged', this.handleElementChanged_);
        this.attachDragEvents_();
      }
      /**
       * Attaches the drag events to handle value updates when dragging the rail handle.
       * protected
       */

    }, {
      key: "attachDragEvents_",
      value: function attachDragEvents_() {
        this.drag_.on(_metalDragDrop.Drag.Events.DRAG, this.updateValueFromDragData_.bind(this));
        this.drag_.on(_metalDragDrop.Drag.Events.END, this.updateValueFromDragData_.bind(this));
      }
      /**
       * Constrains the given region to be inside the rail. This is being used
       * instead of `Drag`'s default behavior, because `Drag` would require the
       * whole handle to be inside the rail element, while we just want to make sure
       * that the left side of the handle is inside it.
       * @param {!Object} region
       * @protected
       */

    }, {
      key: "constrainToRail_",
      value: function constrainToRail_(region) {
        var constrain = _metalPosition.default.getRegion(this.refs.rail, true);

        if (region.left < constrain.left) {
          region.left = constrain.left;
        } else if (region.left > constrain.right) {
          region.left -= region.left - constrain.right;
        }

        region.right = region.left + region.width;
      }
      /**
       * @inheritDoc
       */

    }, {
      key: "disposeInternal",
      value: function disposeInternal() {
        _get(_getPrototypeOf(Slider.prototype), "disposeInternal", this).call(this);

        this.drag_.dispose();
      }
      /**
       * Returns the `Drag` instance being used.
       * @return {!Drag}
       */

    }, {
      key: "getDrag",
      value: function getDrag() {
        return this.drag_;
      }
      /**
       * Handles the `elementChanged` event. Updates the drag container to the new
       * element, and also updates the constrain element.
       * @param {!Object} data
       * @protected
       */

    }, {
      key: "handleElementChanged_",
      value: function handleElementChanged_(data) {
        if (data.newVal) {
          this.drag_.container = data.newVal;
        }
      }
      /**
       * Handles mouse down actions on the slider rail and updates the slider value accordingly.
       * @param {!Event} event
       * @protected
       */

    }, {
      key: "onRailClick_",
      value: function onRailClick_(event) {
        if (_metalDom.default.hasClass(event.target, 'rail') || _metalDom.default.hasClass(event.target, 'rail-active')) {
          var prevValue = this.value;
          this.updateValue_(event.offsetX, 0, true);

          if (prevValue === this.value) {
            var handleRegion = _metalPosition.default.getRegion(this.refs.handle);

            if (event.offsetX < handleRegion.left) {
              this.value -= 1;
            } else {
              this.value += 1;
            }
          }
        }
      }
      /**
       * Synchronizes the slider UI with the `max` state key.
       * @param {number} newVal The new value of the state key.
       */

    }, {
      key: "syncMax",
      value: function syncMax(newVal) {
        if (newVal < this.value) {
          this.value = newVal;
        }
      }
      /**
       * Synchronizes the slider UI with the `min` state key.
       * @param {number} newVal The new value of the state key.
       */

    }, {
      key: "syncMin",
      value: function syncMin(newVal) {
        if (newVal > this.value) {
          this.value = newVal;
        }
      }
      /**
       * Updates the slider value based on the UI state of the handle element.
       * @param {number} handlePosition Position of the handle in px.
       * @param {number} offset Offset to be added to normalize relative inputs.
       * @param {boolean=} opt_relative If the given position is relative to the
       *     rail or not.
       * @protected
       */

    }, {
      key: "updateValue_",
      value: function updateValue_(handlePosition, offset, opt_relative) {
        var region = _metalPosition.default.getRegion(this.element);

        if (!opt_relative) {
          handlePosition -= region.left;
        }

        this.value = Math.round(offset + handlePosition / region.width * (this.max - this.min));
      }
      /**
       * Handles Drag events from the rail handle and updates the slider value accordingly.
       * @param {!Object} data
       * @protected
       */

    }, {
      key: "updateValueFromDragData_",
      value: function updateValueFromDragData_(data, event) {
        this.updateValue_(data.x, this.min);
        event.preventDefault();
      }
    }]);

    return Slider;
  }(_metalComponent.default);

  exports.Slider = Slider;

  _metalSoy.default.register(Slider, _Slider.default);
  /**
   * `Slider`'s state definition.
   */

  Slider.STATE = {
    /**
     * Name of the hidden input field that holds the slider value. Useful when slider is embedded
     * inside a form so it can automatically send its value.
     * @type {string}
     */
    inputName: {
      validator: _metal.default.isString
    },

    /**
     * Defines the maximum value handled by the slider.
     * @type {number}
     * @default 100
     */
    max: {
      value: 100
    },

    /**
     * Defines the minimum value handled by the slider.
     * @type {number}
     * @default 0
     */
    min: {
      value: 0
    },

    /**
     * Defines the currently selected value on the slider.
     * @type {number}
     * @default 0
     */
    value: {
      validator: function validator(val) {
        return _metal.default.isNumber(val) && this.min <= val && val <= this.max;
      },
      value: 0
    }
  };
  var _default = Slider;
  exports.default = _default;
  //# sourceMappingURL=Slider.es.js.map
});
//# sourceMappingURL=Slider.es.js.map