"use strict";

Liferay.Loader.define("frontend-js-web@3.0.12/liferay/compat/progressbar/ProgressBar.soy", ['module', 'exports', 'require', 'frontend-js-metal-web$metal-component', 'frontend-js-metal-web$metal-soy'], function (module, exports, require) {
  var define = undefined;
  Object.defineProperty(exports, "__esModule", {
    value: true
  });
  exports.default = exports.templates = exports.liferayfrontendProgressBar = void 0;

  var _metalComponent = _interopRequireDefault(require("frontend-js-metal-web$metal-component"));

  var _metalSoy = _interopRequireDefault(require("frontend-js-metal-web$metal-soy"));

  function _interopRequireDefault(obj) {
    return obj && obj.__esModule ? obj : { default: obj };
  }

  function _typeof(obj) {
    if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") {
      _typeof = function _typeof(obj) {
        return typeof obj;
      };
    } else {
      _typeof = function _typeof(obj) {
        return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj;
      };
    }return _typeof(obj);
  }

  function _classCallCheck(instance, Constructor) {
    if (!(instance instanceof Constructor)) {
      throw new TypeError("Cannot call a class as a function");
    }
  }

  function _possibleConstructorReturn(self, call) {
    if (call && (_typeof(call) === "object" || typeof call === "function")) {
      return call;
    }return _assertThisInitialized(self);
  }

  function _assertThisInitialized(self) {
    if (self === void 0) {
      throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
    }return self;
  }

  function _getPrototypeOf(o) {
    _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) {
      return o.__proto__ || Object.getPrototypeOf(o);
    };return _getPrototypeOf(o);
  }

  function _inherits(subClass, superClass) {
    if (typeof superClass !== "function" && superClass !== null) {
      throw new TypeError("Super expression must either be null or a function");
    }subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } });if (superClass) _setPrototypeOf(subClass, superClass);
  }

  function _setPrototypeOf(o, p) {
    _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) {
      o.__proto__ = p;return o;
    };return _setPrototypeOf(o, p);
  }

  var templates;
  exports.templates = templates;
  goog.loadModule(function (exports) {
    var soy = goog.require('soy');

    var soydata = goog.require('soydata'); // This file was automatically generated from ProgressBar.soy.
    // Please don't edit this file by hand.

    /**
     * @fileoverview Templates in namespace liferay.frontend.ProgressBar.
     * @public
     */

    goog.module('liferay.frontend.ProgressBar.incrementaldom');

    goog.require('goog.soy.data.SanitizedContent');

    var incrementalDom = goog.require('incrementaldom');

    goog.require('soy.asserts');

    var soyIdom = goog.require('soy.idom');
    /**
     * @param {{
     *  barClass: (!goog.soy.data.SanitizedContent|null|string|undefined),
     *  elementClasses: (!goog.soy.data.SanitizedContent|null|string|undefined),
     *  max: (null|number|undefined),
     *  min: (null|number|undefined),
     *  value: (null|number|undefined),
     *  label: (!goog.soy.data.SanitizedContent|function()|null|string|undefined)
     * }} opt_data
     * @param {Object<string, *>=} opt_ijData
     * @param {Object<string, *>=} opt_ijData_deprecated
     * @return {void}
     * @suppress {checkTypes}
     */

    function $render(opt_data, opt_ijData, opt_ijData_deprecated) {
      opt_ijData = opt_ijData_deprecated || opt_ijData;
      opt_data = opt_data || {};
      /** @type {!goog.soy.data.SanitizedContent|null|string|undefined} */

      var barClass = soy.asserts.assertType(opt_data.barClass == null || goog.isString(opt_data.barClass) || opt_data.barClass instanceof goog.soy.data.SanitizedContent, 'barClass', opt_data.barClass, '!goog.soy.data.SanitizedContent|null|string|undefined');
      /** @type {!goog.soy.data.SanitizedContent|null|string|undefined} */

      var elementClasses = soy.asserts.assertType(opt_data.elementClasses == null || goog.isString(opt_data.elementClasses) || opt_data.elementClasses instanceof goog.soy.data.SanitizedContent, 'elementClasses', opt_data.elementClasses, '!goog.soy.data.SanitizedContent|null|string|undefined');
      /** @type {null|number|undefined} */

      var max = soy.asserts.assertType(opt_data.max == null || goog.isNumber(opt_data.max), 'max', opt_data.max, 'null|number|undefined');
      /** @type {null|number|undefined} */

      var min = soy.asserts.assertType(opt_data.min == null || goog.isNumber(opt_data.min), 'min', opt_data.min, 'null|number|undefined');
      /** @type {null|number|undefined} */

      var value = soy.asserts.assertType(opt_data.value == null || goog.isNumber(opt_data.value), 'value', opt_data.value, 'null|number|undefined');
      /** @type {!goog.soy.data.SanitizedContent|function()|null|string|undefined} */

      var label = soy.asserts.assertType(opt_data.label == null || goog.isFunction(opt_data.label) || goog.isString(opt_data.label) || opt_data.label instanceof goog.soy.data.SanitizedContent, 'label', opt_data.label, '!goog.soy.data.SanitizedContent|function()|null|string|undefined');
      var curMax__soy192 = max ? max : 100;
      var curMin__soy194 = min ? min : 0;
      var curValue__soy196 = value ? value : 0;
      incrementalDom.elementOpenStart('div');
      incrementalDom.attr('class', 'progress ' + (elementClasses ? ' ' + elementClasses : ''));
      incrementalDom.attr('role', 'progressbar');
      incrementalDom.attr('aria-valuemax', curMax__soy192);
      incrementalDom.attr('aria-valuemin', curMin__soy194);
      incrementalDom.attr('aria-valuenow', curValue__soy196);
      incrementalDom.attr('tabindex', '0');
      incrementalDom.elementOpenEnd();
      var percentage__soy206 = Math.floor((curValue__soy196 - curMin__soy194) * 100 / (curMax__soy192 - curMin__soy194));
      incrementalDom.elementOpenStart('div');
      incrementalDom.attr('class', 'progress-bar' + (barClass ? ' ' + barClass : ''));
      incrementalDom.attr('style', 'width: ' + percentage__soy206 + '%');
      incrementalDom.elementOpenEnd();
      soyIdom.print(label ? label : '');
      incrementalDom.elementClose('div');
      incrementalDom.elementClose('div');
    }

    exports.render = $render;
    /**
     * @typedef {{
     *  barClass: (!goog.soy.data.SanitizedContent|null|string|undefined),
     *  elementClasses: (!goog.soy.data.SanitizedContent|null|string|undefined),
     *  max: (null|number|undefined),
     *  min: (null|number|undefined),
     *  value: (null|number|undefined),
     *  label: (!goog.soy.data.SanitizedContent|function()|null|string|undefined)
     * }}
     */

    $render.Params;

    if (goog.DEBUG) {
      $render.soyTemplateName = 'liferay.frontend.ProgressBar.render';
    }

    exports.render.params = ["barClass", "elementClasses", "max", "min", "value", "label"];
    exports.render.types = {
      "barClass": "string",
      "elementClasses": "string",
      "max": "int",
      "min": "int",
      "value": "int",
      "label": "html|string"
    };
    exports.templates = templates = exports;
    return exports;
  });

  var liferayfrontendProgressBar =
  /*#__PURE__*/
  function (_Component) {
    _inherits(liferayfrontendProgressBar, _Component);

    function liferayfrontendProgressBar() {
      _classCallCheck(this, liferayfrontendProgressBar);

      return _possibleConstructorReturn(this, _getPrototypeOf(liferayfrontendProgressBar).apply(this, arguments));
    }

    return liferayfrontendProgressBar;
  }(_metalComponent.default);

  exports.liferayfrontendProgressBar = liferayfrontendProgressBar;

  _metalSoy.default.register(liferayfrontendProgressBar, templates);

  var _default = templates;
  /* jshint ignore:end */

  exports.default = _default;
  //# sourceMappingURL=ProgressBar.soy.js.map
});
//# sourceMappingURL=ProgressBar.soy.js.map