"use strict";

Liferay.Loader.define("frontend-js-web@3.0.12/liferay/PortletBase.es", ['module', 'exports', 'require', 'frontend-js-metal-web$metal', 'frontend-js-metal-web$metal-dom', 'frontend-js-metal-web$metal-component', './util/form/object_to_form_data.es'], function (module, exports, require) {
  var define = undefined;
  Object.defineProperty(exports, "__esModule", {
    value: true
  });
  exports.default = void 0;

  var _metal = _interopRequireDefault(require("frontend-js-metal-web$metal"));

  var _metalDom = _interopRequireDefault(require("frontend-js-metal-web$metal-dom"));

  var _metalComponent = _interopRequireDefault(require("frontend-js-metal-web$metal-component"));

  var _object_to_form_data = _interopRequireDefault(require("./util/form/object_to_form_data.es"));

  function _interopRequireDefault(obj) {
    return obj && obj.__esModule ? obj : { default: obj };
  }

  function _typeof(obj) {
    if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") {
      _typeof = function _typeof(obj) {
        return typeof obj;
      };
    } else {
      _typeof = function _typeof(obj) {
        return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj;
      };
    }return _typeof(obj);
  }

  function _classCallCheck(instance, Constructor) {
    if (!(instance instanceof Constructor)) {
      throw new TypeError("Cannot call a class as a function");
    }
  }

  function _defineProperties(target, props) {
    for (var i = 0; i < props.length; i++) {
      var descriptor = props[i];descriptor.enumerable = descriptor.enumerable || false;descriptor.configurable = true;if ("value" in descriptor) descriptor.writable = true;Object.defineProperty(target, descriptor.key, descriptor);
    }
  }

  function _createClass(Constructor, protoProps, staticProps) {
    if (protoProps) _defineProperties(Constructor.prototype, protoProps);if (staticProps) _defineProperties(Constructor, staticProps);return Constructor;
  }

  function _possibleConstructorReturn(self, call) {
    if (call && (_typeof(call) === "object" || typeof call === "function")) {
      return call;
    }return _assertThisInitialized(self);
  }

  function _assertThisInitialized(self) {
    if (self === void 0) {
      throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
    }return self;
  }

  function _getPrototypeOf(o) {
    _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) {
      return o.__proto__ || Object.getPrototypeOf(o);
    };return _getPrototypeOf(o);
  }

  function _inherits(subClass, superClass) {
    if (typeof superClass !== "function" && superClass !== null) {
      throw new TypeError("Super expression must either be null or a function");
    }subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } });if (superClass) _setPrototypeOf(subClass, superClass);
  }

  function _setPrototypeOf(o, p) {
    _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) {
      o.__proto__ = p;return o;
    };return _setPrototypeOf(o, p);
  }

  /**
   * PortletBase provides some helper functions that simplify querying the DOM
   * for elements related to a specific portlet.
   * @abstract
   * @extends {Component}
   * @review
   */
  var PortletBase =
  /*#__PURE__*/
  function (_Component) {
    _inherits(PortletBase, _Component);

    function PortletBase() {
      _classCallCheck(this, PortletBase);

      return _possibleConstructorReturn(this, _getPrototypeOf(PortletBase).apply(this, arguments));
    }

    _createClass(PortletBase, [{
      key: "all",

      /**
       * Returns a NodeList containing all of the matching Element nodes within
       * the subtrees of the root object, in tree order. If there are no matching
       * nodes, the method returns an empty NodeList.
       * @param {string} selectors List of one or more CSS relative selectors
       * @param {(string|Element|Document)=} root Root node of the search. If not
       * specified, the element search will start in the portlet's root node or in
       * the document
       * @return {NodeList<Element>} List of Elements matching the selectors in
       * tree order
       * @review
       */
      value: function all(selectors, root) {
        root = _metalDom.default.toElement(root) || this.rootNode || document;
        return root.querySelectorAll(this.namespaceSelectors_(this.portletNamespace || this.namespace, selectors));
      }
      /**
       * Performs an HTTP POST request to the given url with the given body.
       * @param {!string} url Where to send the post request
       * @param {!Object|!FormData} body Request body
       * @return {Promise}
       * @review
       */

    }, {
      key: "fetch",
      value: function (_fetch) {
        function fetch(_x, _x2) {
          return _fetch.apply(this, arguments);
        }

        fetch.toString = function () {
          return _fetch.toString();
        };

        return fetch;
      }(function (url, body) {
        var requestBody = this.getRequestBody_(body);
        return fetch(url, {
          body: requestBody,
          credentials: 'include',
          method: 'POST'
        });
      })
      /**
       * Transform the given body into a valid FormData element.
       * @param {!FormData|!HTMLFormElement|!Object} body Original data
       * @return {FormData} Transformed FormData
       * @review
       */

    }, {
      key: "getRequestBody_",
      value: function getRequestBody_(body) {
        var requestBody;

        if (body instanceof FormData) {
          requestBody = body;
        } else if (body instanceof HTMLFormElement) {
          requestBody = new FormData(body);
        } else if (_typeof(body) === 'object') {
          requestBody = (0, _object_to_form_data.default)(this.ns(body));
        } else {
          requestBody = body;
        }

        return requestBody;
      }
      /**
       * Namespaces the list of selectors appending the portlet namespace to the
       * selectors of type id. Selectors of other types remain unaltered.
       * @param {string} namespace The portlet's namespace
       * @param {string} selectors List of one or more CSS relative selectors
       * @protected
       * @return {string} Namespaced id selectors
       * @review
       */

    }, {
      key: "namespaceSelectors_",
      value: function namespaceSelectors_(namespace, selectors) {
        return selectors.replace(new RegExp('(#|\\[id=(\\"|\\\'))(?!' + namespace + ')', 'g'), '$1' + namespace);
      }
      /**
       * Appends the portlet's namespace to the given string or object properties.
       * @param {!Object|string} obj The object or string to be namespaced
       * @return {Object|string} An object with its properties namespaced using
       * the portlet namespace or a namespaced string
       * @review
       */

    }, {
      key: "ns",
      value: function ns(obj) {
        return Liferay.Util.ns(this.portletNamespace || this.namespace, obj);
      }
      /**
       * Returns the first matching Element node within the subtrees of the
       * root object. If there is no matching Element, the method returns null.
       * @param {string} selectors List of one or more CSS relative selectors
       * @param {(string|Element|Document)=} root Root node of the search. If not
       * specified, the element search will start in the portlet's root node or in
       * the document
       * @return {Element|null} List of First Element matching the selectors or null
       * @review
       */

    }, {
      key: "one",
      value: function one(selectors, root) {
        root = _metalDom.default.toElement(root) || this.rootNode || document;
        return root.querySelector(this.namespaceSelectors_(this.portletNamespace || this.namespace, selectors));
      }
      /**
       * Returns the default portlet root node element. By default, this is the
       * element with id "p_p_id{portletNamespace}".
       * @protected
       * @return {Element} The portlet's default root node element
       * @review
       */

    }, {
      key: "rootNodeValueFn_",
      value: function rootNodeValueFn_() {
        return _metalDom.default.toElement("#p_p_id".concat(this.portletNamespace || this.namespace));
      }
    }]);

    return PortletBase;
  }(_metalComponent.default);
  /**
   * State definition.
   * @ignore
   * @review
   * @static
   * @type {!Object}
   */

  PortletBase.STATE = {
    /**
     * Portlet's namespace
     * @deprecated since 7.1
     * @instance
     * @memberof PortletBase
     * @review
     * @type {string}
     */
    namespace: {
      validator: _metal.default.isString
    },

    /**
     * Portlet's namespace
     * @instance
     * @memberof PortletBase
     * @review
     * @type {string}
     */
    portletNamespace: {
      validator: _metal.default.isString
    },

    /**
     * Portlet's root node element
     * @instance
     * @memberof PortletBase
     * @review
     * @type {Element}
     */
    rootNode: {
      setter: _metalDom.default.toElement,
      valueFn: 'rootNodeValueFn_'
    }
  };
  var _default = PortletBase;
  exports.default = _default;
  //# sourceMappingURL=PortletBase.es.js.map
});
//# sourceMappingURL=PortletBase.es.js.map