'use strict';

Liferay.Loader.define("frontend-js-web@2.0.6/liferay/compat/list/ListItem.es", ['module', 'exports', 'require', 'frontend-js-metal-web$metal', 'frontend-js-metal-web$metal-component', 'frontend-js-metal-web$metal-soy', './ListItem.soy'], function (module, exports, require) {
	var define = undefined;
	Object.defineProperty(exports, "__esModule", {
		value: true
	});
	exports.ListItem = undefined;

	var _createClass = function () {
		function defineProperties(target, props) {
			for (var i = 0; i < props.length; i++) {
				var descriptor = props[i];descriptor.enumerable = descriptor.enumerable || false;descriptor.configurable = true;if ("value" in descriptor) descriptor.writable = true;Object.defineProperty(target, descriptor.key, descriptor);
			}
		}return function (Constructor, protoProps, staticProps) {
			if (protoProps) defineProperties(Constructor.prototype, protoProps);if (staticProps) defineProperties(Constructor, staticProps);return Constructor;
		};
	}();

	var _metal = require("frontend-js-metal-web$metal");

	var _metal2 = _interopRequireDefault(_metal);

	var _metalComponent = require("frontend-js-metal-web$metal-component");

	var _metalComponent2 = _interopRequireDefault(_metalComponent);

	var _metalSoy = require("frontend-js-metal-web$metal-soy");

	var _metalSoy2 = _interopRequireDefault(_metalSoy);

	var _ListItemSoy = require("./ListItem.soy");

	var _ListItemSoy2 = _interopRequireDefault(_ListItemSoy);

	function _interopRequireDefault(obj) {
		return obj && obj.__esModule ? obj : { default: obj };
	}

	function _classCallCheck(instance, Constructor) {
		if (!(instance instanceof Constructor)) {
			throw new TypeError("Cannot call a class as a function");
		}
	}

	function _possibleConstructorReturn(self, call) {
		if (!self) {
			throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
		}return call && (typeof call === "object" || typeof call === "function") ? call : self;
	}

	function _inherits(subClass, superClass) {
		if (typeof superClass !== "function" && superClass !== null) {
			throw new TypeError("Super expression must either be null or a function, not " + typeof superClass);
		}subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } });if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass;
	}

	/**
  * List component.
  */

	var ListItem = function (_Component) {
		_inherits(ListItem, _Component);

		function ListItem() {
			_classCallCheck(this, ListItem);

			return _possibleConstructorReturn(this, (ListItem.__proto__ || Object.getPrototypeOf(ListItem)).apply(this, arguments));
		}

		_createClass(ListItem, [{
			key: 'setterItemFn_',

			/**
    * Setter function for the `item` state key.
    * @param {!Object} item
    * @protected
    */

			value: function setterItemFn_(item) {
				if (item.textPrimary && _metal2.default.isString(item.textPrimary)) {
					item.textPrimary = _metalSoy2.default.toIncDom(item.textPrimary);
				}
				if (item.textSecondary && _metal2.default.isString(item.textSecondary)) {
					item.textSecondary = _metalSoy2.default.toIncDom(item.textSecondary);
				}
				if (item.avatar && item.avatar.content && _metal2.default.isString(item.avatar.content)) {
					item.avatar.content = _metalSoy2.default.toIncDom(item.avatar.content);
				}
				if (Array.isArray(item.iconsHtml)) {
					item.iconsHtml = item.iconsHtml.map(_metalSoy2.default.toIncDom);
				}
				return item;
			}
		}]);

		return ListItem;
	}(_metalComponent2.default);

	_metalSoy2.default.register(ListItem, _ListItemSoy2.default);

	/**
  * List state definition.
  * @type {Object}
  * @static
  */

	ListItem.STATE = {

		/**
   * A unique identifier for each item.
   * @type {string}
   */

		id: {
			valueFn: function valueFn() {
				return 'list-component-item' + _metal2.default.getUid();
			}
		},

		/**
   * The item to be rendered.
   * @type {!Object}
   */

		item: {
			validator: _metal2.default.isObject,
			setter: 'setterItemFn_'
		},

		/**
   * The index of the item in the list.
   * @type {number}
   */

		index: {
			value: -1
		}
	};

	exports.ListItem = ListItem;
	exports.default = ListItem;
});
//# sourceMappingURL=ListItem.es.js.map