'use strict';

Liferay.Loader.define("frontend-js-web@2.0.6/liferay/compat/autocomplete/Autocomplete.es", ['module', 'exports', 'require', 'frontend-js-metal-web$metal', 'frontend-js-metal-web$metal-debounce', 'frontend-js-metal-web$metal-dom', 'frontend-js-metal-web$metal-promise', 'frontend-js-metal-web$metal-position', './AutocompleteBase.es', 'frontend-js-metal-web$metal-soy', '../list/List.es', './Autocomplete.soy'], function (module, exports, require) {
	var define = undefined;
	Object.defineProperty(exports, "__esModule", {
		value: true
	});
	exports.Autocomplete = undefined;

	var _createClass = function () {
		function defineProperties(target, props) {
			for (var i = 0; i < props.length; i++) {
				var descriptor = props[i];descriptor.enumerable = descriptor.enumerable || false;descriptor.configurable = true;if ("value" in descriptor) descriptor.writable = true;Object.defineProperty(target, descriptor.key, descriptor);
			}
		}return function (Constructor, protoProps, staticProps) {
			if (protoProps) defineProperties(Constructor.prototype, protoProps);if (staticProps) defineProperties(Constructor, staticProps);return Constructor;
		};
	}();

	var _get = function get(object, property, receiver) {
		if (object === null) object = Function.prototype;var desc = Object.getOwnPropertyDescriptor(object, property);if (desc === undefined) {
			var parent = Object.getPrototypeOf(object);if (parent === null) {
				return undefined;
			} else {
				return get(parent, property, receiver);
			}
		} else if ("value" in desc) {
			return desc.value;
		} else {
			var getter = desc.get;if (getter === undefined) {
				return undefined;
			}return getter.call(receiver);
		}
	};

	var _metal = require("frontend-js-metal-web$metal");

	var _metal2 = _interopRequireDefault(_metal);

	var _metalDebounce = require("frontend-js-metal-web$metal-debounce");

	var _metalDebounce2 = _interopRequireDefault(_metalDebounce);

	var _metalDom = require("frontend-js-metal-web$metal-dom");

	var _metalDom2 = _interopRequireDefault(_metalDom);

	var _metalPromise = require("frontend-js-metal-web$metal-promise");

	var _metalPosition = require("frontend-js-metal-web$metal-position");

	var _AutocompleteBase2 = require('./AutocompleteBase.es');

	var _AutocompleteBase3 = _interopRequireDefault(_AutocompleteBase2);

	var _metalSoy = require("frontend-js-metal-web$metal-soy");

	var _metalSoy2 = _interopRequireDefault(_metalSoy);

	require('../list/List.es');

	var _Autocomplete = require('./Autocomplete.soy');

	var _Autocomplete2 = _interopRequireDefault(_Autocomplete);

	function _interopRequireDefault(obj) {
		return obj && obj.__esModule ? obj : { default: obj };
	}

	function _classCallCheck(instance, Constructor) {
		if (!(instance instanceof Constructor)) {
			throw new TypeError("Cannot call a class as a function");
		}
	}

	function _possibleConstructorReturn(self, call) {
		if (!self) {
			throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
		}return call && (typeof call === "object" || typeof call === "function") ? call : self;
	}

	function _inherits(subClass, superClass) {
		if (typeof superClass !== "function" && superClass !== null) {
			throw new TypeError("Super expression must either be null or a function, not " + typeof superClass);
		}subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } });if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass;
	}

	var DOWN = 40;
	var ENTER = 13;
	var SPACE = 32;
	var UP = 38;

	/*
  * Autocomplete component.
  */

	var Autocomplete = function (_AutocompleteBase) {
		_inherits(Autocomplete, _AutocompleteBase);

		function Autocomplete() {
			_classCallCheck(this, Autocomplete);

			return _possibleConstructorReturn(this, (Autocomplete.__proto__ || Object.getPrototypeOf(Autocomplete)).apply(this, arguments));
		}

		_createClass(Autocomplete, [{
			key: 'attached',

			/**
    * @inheritDoc
    */

			value: function attached() {
				_get(Autocomplete.prototype.__proto__ || Object.getPrototypeOf(Autocomplete.prototype), 'attached', this).call(this);
				this.setAriaAttributes_();
				this.eventHandler_.add(_metalDom2.default.on(this.inputElement, 'focus', this.handleInputFocus_.bind(this)));
				this.eventHandler_.add(_metalDom2.default.on(document, 'click', this.handleDocClick_.bind(this)));
				this.eventHandler_.add(_metalDom2.default.on(window, 'resize', (0, _metalDebounce2.default)(this.handleWindowResize_.bind(this), 100)));
				this.eventHandler_.add(_metalDom2.default.on(this.inputElement, 'keydown', this.handleKeyDown_.bind(this)));
				this.eventHandler_.add(this.getList().on('rendered', this.handleListRender_.bind(this)));
				if (this.visible) {
					this.align();
				}
			}

			/**
    * Aligns main element to the input element.
    */

		}, {
			key: 'align',
			value: function align() {
				this.element.style.width = this.inputElement.offsetWidth + 'px';
				var position = _metalPosition.Align.align(this.element, this.inputElement, _metalPosition.Align.Bottom, this.autoBestAlign);

				_metalDom2.default.removeClasses(this.element, this.positionCss_);
				switch (position) {
					case _metalPosition.Align.Top:
					case _metalPosition.Align.TopLeft:
					case _metalPosition.Align.TopRight:
						this.positionCss_ = 'autocomplete-top';
						break;
					case _metalPosition.Align.Bottom:
					case _metalPosition.Align.BottomLeft:
					case _metalPosition.Align.BottomRight:
						this.positionCss_ = 'autocomplete-bottom';
						break;
					default:
						this.positionCss_ = null;

				}
				_metalDom2.default.addClasses(this.element, this.positionCss_);
			}

			/**
    * Actives an option of the suggestion list by inform an index.
    * @param {number} index
    * @protected
    */

		}, {
			key: 'activateListItem_',
			value: function activateListItem_(index) {
				var option = this.currentList_[index];
				_metalDom2.default.removeClasses(this.currentList_[this.activeIndex_], 'active');
				this.activeIndex_ = index;
				this.inputElement.setAttribute('aria-activedescendant', option.getAttribute('id'));
				_metalDom2.default.addClasses(option, 'active');
			}

			/**
    * Returns the previous index or the last one if the active index was the first.
    * @protected
    * @return {number} Index
    */

		}, {
			key: 'decreaseIndex_',
			value: function decreaseIndex_() {
				return this.activeIndex_ === 0 ? this.getLastIndex_() : this.activeIndex_ - 1;
			}

			/**
    * Returns the last index of the list.
    * @protected
    * @return {number} Index
    */

		}, {
			key: 'getLastIndex_',
			value: function getLastIndex_() {
				return this.getList().items.length - 1;
			}

			/**
    * Returns the `List` component being used to render the matched items.
    * @return {!List}
    */

		}, {
			key: 'getList',
			value: function getList() {
				return this.components.list;
			}

			/**
    * Handles action keys interactions.
    * @param {!Event} event
    * @protected
    */

		}, {
			key: 'handleActionKeys_',
			value: function handleActionKeys_() {
				var selectedItem = this.getList().items[this.activeIndex_];
				this.selectOption_(selectedItem);
			}

			/**
    * Handles `click` events, stopping their propagation.
    * @param {!Event} event
    * @protected
    */

		}, {
			key: 'handleClick_',
			value: function handleClick_(event) {
				event.stopPropagation();
			}

			/**
    * Handles document click in order to hide autocomplete. If input element is
    * focused autocomplete will not hide.
    * @param {!Event} event
    */

		}, {
			key: 'handleDocClick_',
			value: function handleDocClick_() {
				if (document.activeElement === this.inputElement) {
					return;
				}
				this.visible = false;
			}

			/**
    * Handles input focus.
    * @param {!Event} event
    */

		}, {
			key: 'handleInputFocus_',
			value: function handleInputFocus_() {
				this.request(this.inputElement.value);
			}

			/**
    * Executed after List rendering.
    * @param {number} index
    * @protected
    */

		}, {
			key: 'handleListRender_',
			value: function handleListRender_() {
				if (this.visible) {
					this.currentList_ = this.element.querySelectorAll('.listitem');
					this.activateListItem_(0);
				}
			}

			/**
    * Handles a `keydown` event on this component. Handles keyboard controls.
    * @param {!Event} event
    * @protected
    */

		}, {
			key: 'handleKeyDown_',
			value: function handleKeyDown_(event) {
				if (this.visible) {
					switch (event.keyCode) {
						case UP:
							this.activateListItem_(this.decreaseIndex_());
							event.preventDefault();
							break;
						case DOWN:
							this.activateListItem_(this.increaseIndex_());
							event.preventDefault();
							break;
						case ENTER:
						case SPACE:
							this.handleActionKeys_();
							event.preventDefault();
							break;
					}
				}
			}

			/**
    * Handles window resize events. Realigns the autocomplete results list to
    * the input field.
    */

		}, {
			key: 'handleWindowResize_',
			value: function handleWindowResize_() {
				if (this.visible) {
					this.align();
				}
			}

			/**
    * Returns the next index or zero if the active index was the last.
    * @protected
    * @return {number} Index
    */

		}, {
			key: 'increaseIndex_',
			value: function increaseIndex_() {
				return this.activeIndex_ === this.getLastIndex_() ? 0 : this.activeIndex_ + 1;
			}

			/**
    * Listens to the itemSelected event and it tells autocomplete which
    * element was selected.
    * @param {!Element} item The list selected item.
    * @protected
    */

		}, {
			key: 'onListItemSelected_',
			value: function onListItemSelected_(item) {
				var selectedIndex = parseInt(item.getAttribute('data-index'), 10);
				var selectedItem = this.getList().items[selectedIndex];
				this.selectOption_(selectedItem);
			}

			/**
    * @inheritDoc
    */

		}, {
			key: 'request',
			value: function request(query) {
				if (this.autocompleteClosing_) {

					// While closing the input element will be focused, causing another
					// request. This request should be ignored though, since we wish to close
					// the dropdown list, not open it again.

					return;
				}

				var self = this;
				return _get(Autocomplete.prototype.__proto__ || Object.getPrototypeOf(Autocomplete.prototype), 'request', this).call(this, query).then(function (data) {
					if (data) {
						data.forEach(self.assertItemObjectStructure_);
						self.getList().items = data;
					}
					self.visible = !!(data && data.length > 0);
				});
			}

			/**
    * Emits a `select` event with the information about the selected item and
    * hides the list element.
    * @param {!Object} item The list selected item.
    * @protected
    */

		}, {
			key: 'selectOption_',
			value: function selectOption_(selectedItem) {
				this.autocompleteClosing_ = true;
				this.emit('select', selectedItem);
				this.visible = false;
				this.autocompleteClosing_ = false;
			}

			/**
    * Set the required ARIA attributes to the inputElement.
    * @protected
    */

		}, {
			key: 'setAriaAttributes_',
			value: function setAriaAttributes_() {
				this.inputElement.setAttribute('aria-activedescendant', '');
				this.inputElement.setAttribute('aria-autocomplete', 'list');
				this.inputElement.setAttribute('aria-haspopup', true);
				this.inputElement.setAttribute('aria-owns', this.listId);
				this.inputElement.setAttribute('role', 'combobox');
			}

			/**
    * Synchronization logic for `visible` state.
    * @param {boolean} visible
    */

		}, {
			key: 'syncVisible',
			value: function syncVisible(visible) {
				_get(Autocomplete.prototype.__proto__ || Object.getPrototypeOf(Autocomplete.prototype), 'syncVisible', this).call(this, visible);

				if (visible) {
					this.align();
				}
			}

			/**
    * Asserts that formatted data is valid. Throws error if item is not in the
    * valid syntax.
    * @param {*} item
    * @protected
    */

		}, {
			key: 'assertItemObjectStructure_',
			value: function assertItemObjectStructure_(item) {
				if (!_metal2.default.isObject(item)) {
					throw new _metalPromise.CancellablePromise.CancellationError('Autocomplete item must be an object');
				}
				if (!item.hasOwnProperty('textPrimary')) {
					throw new _metalPromise.CancellablePromise.CancellationError('Autocomplete item must be an object with \'textPrimary\' key');
				}
			}
		}]);

		return Autocomplete;
	}(_AutocompleteBase3.default);

	_metalSoy2.default.register(Autocomplete, _Autocomplete2.default);

	/**
  * State definition.
  * @type {!Object}
  * @static
  */

	Autocomplete.STATE = {

		/**
   * Activate or Deactivate the suggestion of the best align region. If true,
   * the component will try to find a better region to align, otherwise,
   * it will keep the position at the bottom.
   * @type {boolean}
   * @default true.
   */

		autoBestAlign: {
			value: true,
			validator: _metal2.default.isBoolean
		},

		/**
   * Function that converts a given item to the format that should be used by
   * the autocomplete.
   * @type {!function()}
   */

		format: {
			value: function value(item) {
				if (_metal2.default.isString(item)) {
					item = {
						textPrimary: item
					};
				}
				if (_metal2.default.isObject(item) && !item.text) {
					item.text = item.textPrimary;
				}
				return item;
			}
		}
	};

	exports.Autocomplete = Autocomplete;
	exports.default = Autocomplete;
});
//# sourceMappingURL=Autocomplete.es.js.map