'use strict';

Liferay.Loader.define('frontend-js-web@2.0.31/liferay/portlet/register.es', ['module', 'exports', 'require', 'frontend-js-metal-web$metal-promise', './PortletInit.es', './portlet_util.es'], function (module, exports, require) {
	var define = undefined;
	Object.defineProperty(exports, "__esModule", {
		value: true
	});
	exports.register = undefined;

	var _metalPromise = require('frontend-js-metal-web$metal-promise');

	var _metalPromise2 = _interopRequireDefault(_metalPromise);

	var _PortletInit = require('./PortletInit.es');

	var _PortletInit2 = _interopRequireDefault(_PortletInit);

	var _portlet_util = require('./portlet_util.es');

	function _interopRequireDefault(obj) {
		return obj && obj.__esModule ? obj : { default: obj };
	}

	/**
  * Registers a portlet client with the portlet hub.
  * @param {string} portletId The unique portlet identifier
  * @return {Promise} A Promise object. Returns an {@link PortletInit} object
  * containing functions for use by the portlet client on successful resolution.
  * Returns an Error object containing a descriptive message on failure.
  * @review
  */

	var register = function register(portletId) {
		(0, _portlet_util.validateArguments)(arguments, 1, 1, ['string']);

		var pageRenderState = global.portlet.data.pageRenderState;

		return new _metalPromise2.default(function (resolve, reject) {
			if ((0, _portlet_util.validatePortletId)(pageRenderState, portletId)) {
				resolve(new _PortletInit2.default(portletId));
			} else {
				reject(new Error('Invalid portlet ID'));
			}
		});
	};

	exports.register = register;
	exports.default = register;
});
//# sourceMappingURL=register.es.js.map