'use strict';

Liferay.Loader.define("frontend-js-web@2.0.31/liferay/portlet/PortletInit.es", ['module', 'exports', 'require', 'frontend-js-metal-web$metal', 'frontend-js-web$uuid/v1', './portlet_constants.es', './portlet_util.es', './RenderState.es'], function (module, exports, require) {
	var define = undefined;
	Object.defineProperty(exports, "__esModule", {
		value: true
	});
	exports.PortletInit = undefined;

	var _typeof = typeof Symbol === "function" && typeof Symbol.iterator === "symbol" ? function (obj) {
		return typeof obj;
	} : function (obj) {
		return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj;
	};

	var _createClass = function () {
		function defineProperties(target, props) {
			for (var i = 0; i < props.length; i++) {
				var descriptor = props[i];descriptor.enumerable = descriptor.enumerable || false;descriptor.configurable = true;if ("value" in descriptor) descriptor.writable = true;Object.defineProperty(target, descriptor.key, descriptor);
			}
		}return function (Constructor, protoProps, staticProps) {
			if (protoProps) defineProperties(Constructor.prototype, protoProps);if (staticProps) defineProperties(Constructor, staticProps);return Constructor;
		};
	}();

	var _metal = require("frontend-js-metal-web$metal");

	var _v = require("frontend-js-web$uuid/v1");

	var _v2 = _interopRequireDefault(_v);

	var _portlet_constants = require('./portlet_constants.es');

	var _portlet_constants2 = _interopRequireDefault(_portlet_constants);

	var _portlet_util = require('./portlet_util.es');

	var _RenderState = require('./RenderState.es');

	var _RenderState2 = _interopRequireDefault(_RenderState);

	function _interopRequireDefault(obj) {
		return obj && obj.__esModule ? obj : { default: obj };
	}

	function _toConsumableArray(arr) {
		if (Array.isArray(arr)) {
			for (var i = 0, arr2 = Array(arr.length); i < arr.length; i++) {
				arr2[i] = arr[i];
			}return arr2;
		} else {
			return Array.from(arr);
		}
	}

	function _classCallCheck(instance, Constructor) {
		if (!(instance instanceof Constructor)) {
			throw new TypeError("Cannot call a class as a function");
		}
	}

	/**
  * Flag specifying whether history is to be processed
  * (true if browser supports HTML5 session history APIs)
  * @type {boolean}
  * @review
  */

	var doHistory = window.history && window.history.pushState;

	/**
  * Regex for portlet-level events
  * @type {string}
  * @review
  */

	var portletRegex = '^portlet[.].*';

	/**
  * Determines if blocking action is currently in process.
  * @type {boolean}
  * @review
  */

	var busy = false;

	/**
  * An array containing the event listeners.
  * @type {Array.<Object>}
  * @review
  */

	var eventListeners = {};

	/**
  * An array containing the event listeners currently queued for being dispatched.
  * @type {Array.<Object>}
  * @review
  */

	var eventListenersQueue = [];

	/**
  * The page render state containing the all portlets and public parameters map.
  * @type {Object}
  * @review
  */

	var pageRenderState = void 0;

	/**
  * PortletInit
  * @review
  */

	var PortletInit = function () {
		function PortletInit(portletId) {
			_classCallCheck(this, PortletInit);

			this._portletId = portletId;

			this.constants = Object.assign({}, _portlet_constants2.default);

			if (!pageRenderState) {
				pageRenderState = global.portlet.data.pageRenderState;

				this._updateHistory(true);
			}

			this.portletModes = pageRenderState.portlets[this._portletId].allowedPM.slice(0);

			this.windowStates = pageRenderState.portlets[this._portletId].allowedWS.slice(0);
		}

		/**
   * Performs the actual action.
   * @param {Object} parameters Additional parameters to be set.
   * @param {HTMLFormElement} element Form to be submitted. May be <code>null</code>.
   * @protected
   * @review
   */

		_createClass(PortletInit, [{
			key: '_executeAction',
			value: function _executeAction(parameters, element) {
				var _this = this;

				return new Promise(function (resolve, reject) {
					(0, _portlet_util.getUrl)(pageRenderState, 'ACTION', _this._portletId, parameters).then(function (url) {
						var options = (0, _portlet_util.generateActionUrl)(_this._portletId, url, element);

						fetch(options.url, options).then(function (res) {
							return res.text();
						}).then(function (text) {
							var updatedIds = _this._updatePageStateFromString(text, _this._portletId);

							resolve(updatedIds);
						}).catch(function (err) {
							reject(err);
						});
					});
				});
			}

			/**
    * Returns true if an onStateChange listener is registered for the portlet.
    * @memberof PortletInit
    * @param {string} portletId The portlet ID.
    * @return {boolean} Returns true if a listener is registered.
    * @protected
    * @review
    */

		}, {
			key: '_hasListener',
			value: function _hasListener(portletId) {
				var eventListenerPortletIds = Object.keys(eventListeners).map(function (key) {
					return eventListeners[key].id;
				});

				return eventListenerPortletIds.includes(portletId);
			}

			/**
    * Sends an onError event to all registered error event handlers for a given
    * portlet.
    * @memberof PortletInit
    * @param {string} portletId The portlet ID.
    * @param {string} err The error message.
    * @protected
    * @review
    */

		}, {
			key: '_reportError',
			value: function _reportError(portletId, err) {
				Object.keys(eventListeners).map(function (key) {
					var listener = eventListeners[key];

					if (listener.id === portletId && listener.type === 'portlet.onError') {
						setTimeout(function () {
							listener.handler('portlet.onError', err);
						});
					}
					return false;
				});
			}

			/**
   * Callback function that must be called after a partial action has been
   * started.
   *
   * The page state is generated by the portal and transmitted to the client by
   * the portlet. The portlet client that initiated the partial action must
   * pass the page state string to this function.
   *
   * The callback should only be called once to conclude a partial action sequence.
   * @memberof PortletInit
   * @param {string} portletId The portlet ID.
   * @param {string} updateString The new page state in string form.
   * @throws {TypeError} Thrown if the parameter is not a string.
   * @protected
   * @review
   */

		}, {
			key: '_setPageState',
			value: function _setPageState(portletId, updateString) {
				var _this2 = this;

				if (!(0, _metal.isString)(updateString)) {
					throw new TypeError('Invalid update string: ' + updateString);
				}

				this._updatePageState(updateString, portletId).then(function (updatedIds) {
					_this2._updatePortletStates(updatedIds);
				}, function (err) {
					busy = false;

					_this2._reportError(portletId, err);
				});
			}

			/**
    * Sets state for the portlet.
    * returns array of IDs for portlets that were affected by the change,
    * taking into account the public render parameters.
    * @memberof PortletInit
    * @param {Object} state The state to be set.
    * @return {Array}
    * @protected
    * @review
    */

		}, {
			key: '_setState',
			value: function _setState(state) {
				var publicRenderParameters = (0, _portlet_util.getUpdatedPublicRenderParameters)(pageRenderState, this._portletId, state);

				var updatedIds = [];

				var parameterKeys = Object.keys(publicRenderParameters);

				var _iteratorNormalCompletion = true;
				var _didIteratorError = false;
				var _iteratorError = undefined;

				try {
					for (var _iterator = parameterKeys[Symbol.iterator](), _step; !(_iteratorNormalCompletion = (_step = _iterator.next()).done); _iteratorNormalCompletion = true) {
						var parameterKey = _step.value;

						var newValue = publicRenderParameters[parameterKey];

						var groupMap = pageRenderState.prpMap[parameterKey];

						var groupKeys = Object.keys(groupMap);

						var _iteratorNormalCompletion3 = true;
						var _didIteratorError3 = false;
						var _iteratorError3 = undefined;

						try {
							for (var _iterator3 = groupKeys[Symbol.iterator](), _step3; !(_iteratorNormalCompletion3 = (_step3 = _iterator3.next()).done); _iteratorNormalCompletion3 = true) {
								var groupKey = _step3.value;

								if (groupKey !== this._portletId) {
									var parts = groupMap[groupKey].split('|');

									var _portletId = parts[0];

									var parameterName = parts[1];

									if (newValue === undefined) {
										delete pageRenderState.portlets[_portletId].state.parameters[parameterName];
									} else {
										pageRenderState.portlets[_portletId].state.parameters[parameterName] = [].concat(_toConsumableArray(newValue));
									}
									updatedIds.push(_portletId);
								}
							}
						} catch (err) {
							_didIteratorError3 = true;
							_iteratorError3 = err;
						} finally {
							try {
								if (!_iteratorNormalCompletion3 && _iterator3.return) {
									_iterator3.return();
								}
							} finally {
								if (_didIteratorError3) {
									throw _iteratorError3;
								}
							}
						}
					}
				} catch (err) {
					_didIteratorError = true;
					_iteratorError = err;
				} finally {
					try {
						if (!_iteratorNormalCompletion && _iterator.return) {
							_iterator.return();
						}
					} finally {
						if (_didIteratorError) {
							throw _iteratorError;
						}
					}
				}

				var portletId = this._portletId;

				// Update state for the initiating portlet.

				pageRenderState.portlets[portletId].state = state;
				updatedIds.push(portletId);

				// Delete render data for all affected portlets in order to avoid dispatching
				// stale render data

				var _iteratorNormalCompletion2 = true;
				var _didIteratorError2 = false;
				var _iteratorError2 = undefined;

				try {
					for (var _iterator2 = updatedIds[Symbol.iterator](), _step2; !(_iteratorNormalCompletion2 = (_step2 = _iterator2.next()).done); _iteratorNormalCompletion2 = true) {
						var updatedId = _step2.value;

						pageRenderState.portlets[updatedId].renderData.content = null;
					}

					// Update history for back-button support
				} catch (err) {
					_didIteratorError2 = true;
					_iteratorError2 = err;
				} finally {
					try {
						if (!_iteratorNormalCompletion2 && _iterator2.return) {
							_iterator2.return();
						}
					} finally {
						if (_didIteratorError2) {
							throw _iteratorError2;
						}
					}
				}

				this._updateHistory();

				return Promise.resolve(updatedIds);
			}

			/**
    * Sets up for the action.
    * @memberof PortletInit
    * @param {Object} parameters Additional parameters. May be <code>null</code>.
    * @param {HTMLFormElement} element Form to be submitted May be <code>null</code>.
    * @throws {AccessDeniedException} Thrown if a blocking operation is already in progress.
    * @throws {NotInitializedException} Thrown if a portlet ID is provided, but no onStateChange
    * listener has been registered.
    * @protected
    * @review
    */

		}, {
			key: '_setupAction',
			value: function _setupAction(parameters, element) {
				var _this3 = this;

				if (this.isInProgress()) {
					throw {
						message: 'Operation is already in progress',
						name: 'AccessDeniedException'
					};
				}

				if (!this._hasListener(this._portletId)) {
					throw {
						message: 'No onStateChange listener registered for portlet: ' + this._portletId,
						name: 'NotInitializedException'
					};
				}

				busy = true;

				return this._executeAction(parameters, element).then(function (updatedIds) {
					return _this3._updatePortletStates(updatedIds).then(function (updatedIds) {
						busy = false;

						return updatedIds;
					});
				}, function (err) {
					busy = false;

					_this3._reportError(_this3._portletId, err);
				});
			}

			/**
    * Called when the page state has been updated to allow
    * the browser history to be taken care of.
    * @memberof PortletInit
    * @param {boolean} replace Replace the state rather than pushing.
    * @protected
    * @review
    */

		}, {
			key: '_updateHistory',
			value: function _updateHistory(replace) {
				if (doHistory) {
					(0, _portlet_util.getUrl)(pageRenderState, 'RENDER', null, {}).then(function (url) {
						var token = JSON.stringify(pageRenderState);

						if (replace) {
							history.replaceState(token, '');
						} else {
							try {
								history.pushState(token, '', url);
							} catch (e) {}
						}
					});
				}
			}

			/**
    * Update page state passed in after partial action. The list of
    * ID's of updated portlets is passed back through a promise in order
    * to decouple the layers.
    *
    * @memberof PortletInit
    * @param {string} updateString The updated render state string.
    * @review
    */

		}, {
			key: '_updatePageState',
			value: function _updatePageState(updateString) {
				var _this4 = this;

				return new Promise(function (resolve, reject) {
					try {
						var updatedIds = _this4._updatePageStateFromString(updateString, _this4._portletId);

						resolve(updatedIds);
					} catch (e) {
						reject(new Error('Partial Action decode status: ' + e.message));
					}
				});
			}

			/**
    * Updates page state from string and returns array of portlet IDs
    * to be updated.
    *
    * @memberof PortletInit
    * @param {string} updateString The update string.
    * @param {string} portletId The portlet ID.
    * @protected
    * @review
    */

		}, {
			key: '_updatePageStateFromString',
			value: function _updatePageStateFromString(updateString, portletId) {
				var portlets = (0, _portlet_util.decodeUpdateString)(pageRenderState, updateString);
				var updatedIds = [];

				var stateUpdated = false;

				// Update portlets and collect IDs of affected portlets.

				var keys = Object.keys(portlets);

				var _iteratorNormalCompletion4 = true;
				var _didIteratorError4 = false;
				var _iteratorError4 = undefined;

				try {
					for (var _iterator4 = keys[Symbol.iterator](), _step4; !(_iteratorNormalCompletion4 = (_step4 = _iterator4.next()).done); _iteratorNormalCompletion4 = true) {
						var key = _step4.value;

						var portletData = portlets[key];

						pageRenderState.portlets[key] = portletData;
						updatedIds.push(key);
						stateUpdated = true;
					}

					// portletId will be null or undefined when called from onpopstate routine.
					// In that case, don't update history.
				} catch (err) {
					_didIteratorError4 = true;
					_iteratorError4 = err;
				} finally {
					try {
						if (!_iteratorNormalCompletion4 && _iterator4.return) {
							_iterator4.return();
						}
					} finally {
						if (_didIteratorError4) {
							throw _iteratorError4;
						}
					}
				}

				if (stateUpdated && portletId) {
					this._updateHistory();
				}

				return updatedIds;
			}

			/**
    *
    * Accepts an object containing changed render states.
    * Updates the state for each portlet present.
    *
    * @memberof PortletInit
    * @param {Array} updatedIds Array of portlet IDs to be updated.
    * @return {Promsise.<string>}
    * @protected
    * @review
    */

		}, {
			key: '_updatePortletStates',
			value: function _updatePortletStates(updatedIds) {
				var _this5 = this;

				return new Promise(function (resolve, reject) {
					if (updatedIds.length === 0) {
						busy = false;
					} else {
						var _iteratorNormalCompletion5 = true;
						var _didIteratorError5 = false;
						var _iteratorError5 = undefined;

						try {
							for (var _iterator5 = updatedIds[Symbol.iterator](), _step5; !(_iteratorNormalCompletion5 = (_step5 = _iterator5.next()).done); _iteratorNormalCompletion5 = true) {
								var updatedId = _step5.value;

								_this5._updateStateForPortlet(updatedId);
							}
						} catch (err) {
							_didIteratorError5 = true;
							_iteratorError5 = err;
						} finally {
							try {
								if (!_iteratorNormalCompletion5 && _iterator5.return) {
									_iterator5.return();
								}
							} finally {
								if (_didIteratorError5) {
									throw _iteratorError5;
								}
							}
						}
					}
					resolve(updatedIds);
				});
			}

			/**
    * Updates the page render state
    *
    * @memberof PortletInit
    * @param {Object} state The new state to be set.
    * @protected
    * @review
    */

		}, {
			key: '_updateState',
			value: function _updateState(state) {
				var _this6 = this;

				if (busy) {
					throw {
						message: 'Operation in progress',
						name: 'AccessDeniedException'
					};
				} else if (!this._hasListener(this._portletId)) {
					throw {
						message: 'No onStateChange listener registered for portlet: ' + this._portletId,
						name: 'NotInitializedException'
					};
				}

				busy = true;

				this._setState(state).then(function (updatedIds) {
					_this6._updatePortletStates(updatedIds);
				}).catch(function (err) {
					busy = false;
					_this6._reportError(_this6._portletId, err);
				});
			}

			/**
    * Calls the portlet onStateChange method in an asynchronous manner in order
    * to decouple the public API. This method is intended for use after
    * portlet client registers an onStateChange listener.
    *
    * @memberof PortletInit
    * @param {string} portletId The portlet ID.
    * @protected
    * @review
    */

		}, {
			key: '_updateStateForPortlet',
			value: function _updateStateForPortlet(portletId) {
				var updateQueueIds = eventListenersQueue.map(function (item) {
					return item.handle;
				});

				var keys = Object.keys(eventListeners);

				var _iteratorNormalCompletion6 = true;
				var _didIteratorError6 = false;
				var _iteratorError6 = undefined;

				try {
					for (var _iterator6 = keys[Symbol.iterator](), _step6; !(_iteratorNormalCompletion6 = (_step6 = _iterator6.next()).done); _iteratorNormalCompletion6 = true) {
						var key = _step6.value;

						var eventData = eventListeners[key];

						if (eventData.type !== 'portlet.onStateChange') {
							continue;
						}

						if (eventData.id === portletId && !updateQueueIds.includes(key)) {
							eventListenersQueue.push(eventData);
						}
					}
				} catch (err) {
					_didIteratorError6 = true;
					_iteratorError6 = err;
				} finally {
					try {
						if (!_iteratorNormalCompletion6 && _iterator6.return) {
							_iterator6.return();
						}
					} finally {
						if (_didIteratorError6) {
							throw _iteratorError6;
						}
					}
				}

				if (eventListenersQueue.length > 0) {
					setTimeout(function () {
						busy = true;

						while (eventListenersQueue.length > 0) {
							var eventData = eventListenersQueue.shift();
							var handler = eventData.handler;
							var id = eventData.id;

							if (!pageRenderState.portlets[id]) {
								continue;
							}

							var renderData = pageRenderState.portlets[id].renderData;
							var renderState = new _RenderState2.default(pageRenderState.portlets[id].state);

							if (renderData && renderData.content) {
								handler('portlet.onStateChange', renderState, renderData);
							} else {
								handler('portlet.onStateChange', renderState);
							}
						}

						busy = false;
					});
				}
			}

			/**
    * Initiates a portlet action using the specified action parameters and
    * element arguments.
    *
    * @memberof PortletInit
    * @param {PortletParameters} parameters Action parameters to be added to the URL
    * @param {HTMLFormElement} element DOM element of form to be submitted
    * @return {Promise} A Promise object that is resolved with no argument when the action request has completed.
    * @throws {TypeError} Thrown if the input parameters are invalid
    * @throws {AccessDeniedException} Thrown if a blocking operation is already in progress.
    * @throws {NotInitializedException} Thrown if a portlet ID is provided, but no onStateChange listener has been registered.
    * @review
    */

		}, {
			key: 'action',
			value: function action() {
				var actionParameters = null;
				var argCount = 0;
				var el = null;

				for (var _len = arguments.length, args = Array(_len), _key = 0; _key < _len; _key++) {
					args[_key] = arguments[_key];
				}

				var _iteratorNormalCompletion7 = true;
				var _didIteratorError7 = false;
				var _iteratorError7 = undefined;

				try {
					for (var _iterator7 = args[Symbol.iterator](), _step7; !(_iteratorNormalCompletion7 = (_step7 = _iterator7.next()).done); _iteratorNormalCompletion7 = true) {
						var arg = _step7.value;

						if (arg instanceof HTMLFormElement) {
							if (el !== null) {
								throw new TypeError('Too many [object HTMLFormElement] arguments: ' + arg + ', ' + el);
							}

							el = arg;
						} else if ((0, _metal.isObject)(arg)) {
							(0, _portlet_util.validateParameters)(arg);

							if (actionParameters !== null) {
								throw new TypeError('Too many parameters arguments');
							}

							actionParameters = arg;
						} else if (arg !== undefined) {
							var type = Object.prototype.toString.call(arg);

							throw new TypeError('Invalid argument type. Argument ' + (argCount + 1) + ' is of type ' + type);
						}
						argCount++;
					}
				} catch (err) {
					_didIteratorError7 = true;
					_iteratorError7 = err;
				} finally {
					try {
						if (!_iteratorNormalCompletion7 && _iterator7.return) {
							_iterator7.return();
						}
					} finally {
						if (_didIteratorError7) {
							throw _iteratorError7;
						}
					}
				}

				if (el) {
					(0, _portlet_util.validateForm)(el);
				}

				return this._setupAction(actionParameters, el).then(function (val) {
					Promise.resolve(val);
				}).catch(function (err) {
					Promise.reject(err);
				});
			}

			/**
    * Adds a listener function for specified event type.
    *
    * @memberof PortletInit
    * @param {string} type The type of listener
    * @param {function} handler Function called when event occurs
    * @return {Object} A handle that can be used to remove the event listener
    * @throws {TypeError} Thrown if the input parameters are invalid
    * @review
    */

		}, {
			key: 'addEventListener',
			value: function addEventListener(type, handler) {
				if (arguments.length > 2) {
					throw new TypeError('Too many arguments passed to addEventListener');
				}

				if (!(0, _metal.isString)(type) || !(0, _metal.isFunction)(handler)) {
					throw new TypeError('Invalid arguments passed to addEventListener');
				}

				var id = this._portletId;

				if (type.startsWith('portlet.')) {
					if (type !== 'portlet.onStateChange' && type !== 'portlet.onError') {
						throw new TypeError('The system event type is invalid: ' + type);
					}
				}

				var handle = (0, _v2.default)();

				var listener = {
					handle: handle,
					handler: handler,
					id: id,
					type: type
				};

				eventListeners[handle] = listener;

				if (type === 'portlet.onStateChange') {
					this._updateStateForPortlet(this._portletId);
				}

				return handle;
			}

			/**
    * Returns a promise for a resource URL with parameters set appropriately
    * for the page state according to the resource parameters, cacheability
    * option, and resource ID provided.
    * @memberof PortletInit
    * @param {Object} parameters Resource parameters to be added to the URL
    * @param {string} cache Cacheability option. The strings defined under
    * {@link PortletConstants} should be used to specifiy cacheability.
    * @param {string} resourceId Resource ID.
    * @return {Promise} A Promise object. Returns a string representing the
    * resource URL on successful resolution. Returns an Error object containing
    * a descriptive message on failure.
    * @throws {TypeError} Thrown if the input parameters are invalid
    * @review
    */

		}, {
			key: 'createResourceUrl',
			value: function createResourceUrl(parameters, cache, resourceId) {
				if (arguments.length > 3) {
					throw new TypeError('Too many arguments. 3 arguments are allowed.');
				}

				if (parameters) {
					if ((0, _metal.isObject)(parameters)) {
						(0, _portlet_util.validateParameters)(parameters);
					} else {
						throw new TypeError('Invalid argument type. Resource parameters must be a parameters object.');
					}
				}

				var cacheability = null;

				if (cache) {
					if ((0, _metal.isString)(cache)) {
						if (cache === 'cacheLevelPage' || cache === 'cacheLevelPortlet' || cache === 'cacheLevelFull') {
							cacheability = cache;
						} else {
							throw new TypeError('Invalid cacheability argument: ' + cache);
						}
					} else {
						throw new TypeError('Invalid argument type. Cacheability argument must be a string.');
					}
				}

				if (!cacheability) {
					cacheability = 'cacheLevelPage';
				}

				if (resourceId && !(0, _metal.isString)(resourceId)) {
					throw new TypeError('Invalid argument type. Resource ID argument must be a string.');
				}

				return (0, _portlet_util.getUrl)(pageRenderState, 'RESOURCE', this._portletId, parameters, cacheability, resourceId);
			}

			/**
    * Dispatches a client event.
    * @memberof PortletInit
    * @param {string} type The type of listener.
    * @param {any} payload The payload to be delivered.
    * @return {number} The number of events queued for delivery.
    * @throws {TypeError} Thrown if the type is a system event type.
    * @review
    */

		}, {
			key: 'dispatchClientEvent',
			value: function dispatchClientEvent(type, payload) {
				(0, _portlet_util.validateArguments)(arguments, 2, 2, ['string']);

				if (type.match(new RegExp(portletRegex))) {
					throw new TypeError('The event type is invalid: ' + type);
				}

				return Object.keys(eventListeners).reduce(function (amount, key) {
					var listener = eventListeners[key];

					if (type.match(listener.type)) {
						listener.handler(type, payload);
						amount++;
					}
					return amount;
				}, 0);
			}

			/**
    * Tests whether a blocking operation is in progress.
    * @memberof PortletInit
    * @return {boolean}
    * @review
    */

		}, {
			key: 'isInProgress',
			value: function isInProgress() {
				return busy;
			}

			/**
    * Creates and returns a new PortletParameters object.
    * @memberof PortletInit
    * @param {?Object} optParameters The optional parameters to be copied.
    * @return {Object} The new parameters object.
    * @review
    */

		}, {
			key: 'newParameters',
			value: function newParameters() {
				var optParameters = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};

				var newParameters = {};

				Object.keys(optParameters).forEach(function (key) {
					if (Array.isArray(optParameters[key])) {
						newParameters[key] = [].concat(_toConsumableArray(optParameters[key]));
					}
				});
				return newParameters;
			}

			/**
    * Creates and returns a new RenderState object.
    * @memberof PortletInit
    * @param {?RenderState} optState An optional RenderState object to be copied.
    * @return {RenderState} The new RenderState object.
    * @review
    */

		}, {
			key: 'newState',
			value: function newState(optState) {
				return new _RenderState2.default(optState);
			}

			/**
    * Removes a previously added listener function designated by the handle.
    * The handle must be the same object previously returned by the
    * addEventListener function.
    * @memberof PortletInit
    * @param {Object} handle The handle of the listener to be removed.
    * @throws {TypeError} Thrown if the input parameters are invalid.
    * @throws {AccessDeniedException} Thrown if the event listener associated
    * with this handle was registered by a different portlet.
    * @review
    */

		}, {
			key: 'removeEventListener',
			value: function removeEventListener(handle) {
				if (arguments.length > 1) {
					throw new TypeError('Too many arguments passed to removeEventListener');
				}

				if (!(0, _metal.isDefAndNotNull)(handle)) {
					throw new TypeError('The event handle provided is ' + (typeof handle === 'undefined' ? 'undefined' : _typeof(handle)));
				}

				var found = false;

				if ((0, _metal.isObject)(eventListeners[handle])) {
					if (eventListeners[handle].id === this._portletId) {
						delete eventListeners[handle];

						var l = eventListenersQueue.length;

						for (var i = 0; i < l; i++) {
							var eventData = eventListenersQueue[i];

							if (eventData && eventData.handle === handle) {
								eventListenersQueue.splice(i, 1);
							}
						}

						found = true;
					}
				}

				if (!found) {
					throw new TypeError('The event listener handle doesn\'t match any listeners.');
				}
			}

			/**
    * Sets the render state, which consists of the public and private render
    * parameters, the portlet mode, and the window state.
    * @memberof PortletInit
    * @param {RenderState} state The new state to be set.
    * @throws {TypeError} Thrown if the input parameters are invalid.
    * @throws {AccessDeniedException} Thrown if a blocking operation is already in progress.
    * @throws {NotInitializedException} Thrown if a portlet ID is provided, but no onStateChange
    * listener has been registered.
    * @review
    */

		}, {
			key: 'setRenderState',
			value: function setRenderState(state) {
				(0, _portlet_util.validateArguments)(arguments, 1, 1, ['object']);

				if (pageRenderState.portlets && pageRenderState.portlets[this._portletId]) {
					var portletData = pageRenderState.portlets[this._portletId];

					(0, _portlet_util.validateState)(state, portletData);
					this._updateState(state);
				}
			}

			/**
    * Starts partial action processing and returns a {@link PartialActionInit} object to the caller.
    * @memberof PortletInit
    * @param {PortletParameters} actionParameters Action parameters to be added to the URL.
    * @return {Promise} A Promise. Returns a {@link PortletActionInit} object
    * containing a partial action URL and the _setPageState callback function
    * on successful resolution. Returns an Error object containing a
    * descriptive message on failure.
    * @throws {TypeError} Thrown if the input parameters are invalid.
    * @throws {AccessDeniedException} Thrown if a blocking operation is already in progress.
    * @throws {NotInitializedException} Thrown if a portlet ID is provided, but
    * no onStateChange listener has been registered.
    * @review
    */

		}, {
			key: 'startPartialAction',
			value: function startPartialAction(actionParameters) {
				var instance = this;

				var parameters = null;

				if (arguments.length > 1) {
					throw new TypeError('Too many arguments. 1 arguments are allowed');
				} else if (actionParameters !== undefined) {
					if ((0, _metal.isObject)(actionParameters)) {
						(0, _portlet_util.validateParameters)(actionParameters);

						parameters = actionParameters;
					} else {
						throw new TypeError('Invalid argument type. Argument is of type ' + (typeof actionParameters === 'undefined' ? 'undefined' : _typeof(actionParameters)));
					}
				}

				if (busy === true) {
					throw {
						message: 'Operation in progress',
						name: 'AccessDeniedException'
					};
				} else if (!this._hasListener(this._portletId)) {
					throw {
						message: 'No onStateChange listener registered for portlet: ' + this._portletId,
						name: 'NotInitializedException'
					};
				}

				busy = true;

				var partialActionInitObject = {
					setPageState: function setPageState(updateString) {
						instance._setPageState(instance._portletId, updateString);
					},

					url: ''
				};

				return (0, _portlet_util.getUrl)(pageRenderState, 'PARTIAL_ACTION', this._portletId, parameters).then(function (url) {
					partialActionInitObject.url = url;
					return partialActionInitObject;
				});
			}
		}]);

		return PortletInit;
	}();

	exports.PortletInit = PortletInit;
	exports.default = PortletInit;
});
//# sourceMappingURL=PortletInit.es.js.map