'use strict';

Liferay.Loader.define("frontend-js-web@2.0.31/liferay/compat/treeview/Treeview.es", ['module', 'exports', 'require', 'frontend-js-metal-web$metal', './Treeview.soy', 'frontend-js-metal-web$metal-component', 'frontend-js-metal-web$metal-keyboard-focus', 'frontend-js-metal-web$metal-soy'], function (module, exports, require) {
	var define = undefined;
	Object.defineProperty(exports, "__esModule", {
		value: true
	});
	exports.Treeview = undefined;

	var _createClass = function () {
		function defineProperties(target, props) {
			for (var i = 0; i < props.length; i++) {
				var descriptor = props[i];descriptor.enumerable = descriptor.enumerable || false;descriptor.configurable = true;if ("value" in descriptor) descriptor.writable = true;Object.defineProperty(target, descriptor.key, descriptor);
			}
		}return function (Constructor, protoProps, staticProps) {
			if (protoProps) defineProperties(Constructor.prototype, protoProps);if (staticProps) defineProperties(Constructor, staticProps);return Constructor;
		};
	}();

	var _metal = require("frontend-js-metal-web$metal");

	var _metal2 = _interopRequireDefault(_metal);

	var _Treeview = require('./Treeview.soy');

	var _Treeview2 = _interopRequireDefault(_Treeview);

	var _metalComponent = require("frontend-js-metal-web$metal-component");

	var _metalComponent2 = _interopRequireDefault(_metalComponent);

	var _metalKeyboardFocus = require("frontend-js-metal-web$metal-keyboard-focus");

	var _metalKeyboardFocus2 = _interopRequireDefault(_metalKeyboardFocus);

	var _metalSoy = require("frontend-js-metal-web$metal-soy");

	var _metalSoy2 = _interopRequireDefault(_metalSoy);

	function _interopRequireDefault(obj) {
		return obj && obj.__esModule ? obj : { default: obj };
	}

	function _classCallCheck(instance, Constructor) {
		if (!(instance instanceof Constructor)) {
			throw new TypeError("Cannot call a class as a function");
		}
	}

	function _possibleConstructorReturn(self, call) {
		if (!self) {
			throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
		}return call && (typeof call === "object" || typeof call === "function") ? call : self;
	}

	function _inherits(subClass, superClass) {
		if (typeof superClass !== "function" && superClass !== null) {
			throw new TypeError("Super expression must either be null or a function, not " + typeof superClass);
		}subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } });if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass;
	}

	/**
  * Treeview component.
  */

	var Treeview = function (_Component) {
		_inherits(Treeview, _Component);

		function Treeview() {
			_classCallCheck(this, Treeview);

			return _possibleConstructorReturn(this, (Treeview.__proto__ || Object.getPrototypeOf(Treeview)).apply(this, arguments));
		}

		_createClass(Treeview, [{
			key: 'attached',

			/**
    * @inheritDoc
    */

			value: function attached() {
				this.keyboardFocusManager_ = new _metalKeyboardFocus2.default(this, 'li').setFocusHandler(this.handleNextFocus_.bind(this)).start();
				this.keyboardFocusManager_.on(_metalKeyboardFocus2.default.EVENT_FOCUSED, this.handleKeyboardFocused_.bind(this));
			}

			/**
    * @inheritDoc
    */

		}, {
			key: 'disposed',
			value: function disposed() {
				this.keyboardFocusManager_.dispose();
				this.keyboardFocusManager_ = null;
			}

			/**
    * Gets the node object from the `nodes` state that is located at the given
    * index path.
    * @param {!Array<number>} path An array of indexes indicating where the
    *   searched node is located inside the `nodes` state.
    * @return {!Object}
    */

		}, {
			key: 'getNodeObj',
			value: function getNodeObj(path) {
				var obj = this.nodes[path[0]];
				for (var i = 1; i < path.length; i++) {
					obj = obj.children[path[i]];
				}
				return obj;
			}

			/**
    * Gets the treeview path for a given node.
    * @param {!Element} node
    * @return {!Array<string>}
    * @protected
    */

		}, {
			key: 'getPath_',
			value: function getPath_(node) {
				return node.getAttribute('data-treeview-path').split('-');
			}

			/**
    * Handles the `focused` event from `KeyboardFocusManager`. Stores the ref
    * of the last focused tree item so that we can retain it in the tab order
    * when the user leaves the tree.
    * @param {!Object} data
    * @protected
    */

		}, {
			key: 'handleKeyboardFocused_',
			value: function handleKeyboardFocused_(data) {
				this.lastFocusedRef_ = data.ref;
			}

			/**
    * Handles the left arrow being pressed. If the node is expanded, it will be
    * closed. If it's closed, its parent's ref will be returned so it can be
    * focused by `KeyboardFocusManager`.
    * @param {!Array<string>} path
    * @param {!Object} obj
    * @return {?string}
    * @protected
    */

		}, {
			key: 'handleLeftArrow_',
			value: function handleLeftArrow_(path, obj) {
				if (obj.expanded) {
					obj.expanded = false;
					this.nodes = this.nodes;
				} else if (path.length > 1) {
					path.pop();
					return Treeview.NODE_REF_PREFIX + path.join('-');
				}
			}

			/**
    * Handles focus through keyboard.
    * @param {!Event} event
    * @return {boolean|string|Element}
    * @protected
    */

		}, {
			key: 'handleNextFocus_',
			value: function handleNextFocus_(event) {
				event.stopPropagation();

				var path = this.getPath_(event.delegateTarget);
				var obj = this.getNodeObj(path);
				switch (event.keyCode) {
					case 37:
						return this.handleLeftArrow_(path, obj);
					case 39:
						return this.handleRightArrow_(path, obj);
					default:

						// Use default behavior for other keys (like up/down arrows).

						return true;
				}
			}

			/**
    * This is called when one of this tree view's nodes is clicked.
    * @param {!Event} event
    * @protected
    */

		}, {
			key: 'handleNodeClicked_',
			value: function handleNodeClicked_(event) {
				this.toggleExpandedState_(event.delegateTarget.parentNode.parentNode);
			}

			/**
    * This is called when one of this tree view's nodes receives a keypress.
    * If the pressed key is ENTER or SPACE, the node's expanded state will be toggled.
    * @param {!Event} event
    * @protected
    */

		}, {
			key: 'handleNodeKeyUp_',
			value: function handleNodeKeyUp_(event) {
				if (event.keyCode === 13 || event.keyCode === 32) {
					this.toggleExpandedState_(event.delegateTarget);
					event.stopPropagation();
				}
			}

			/**
    * Handles the right arrow being pressed. If the node is closed, it will be
    * expanded. If it's already expanded, the ref of its first child will be
    * returned so it can be focused by `KeyboardFocusManager`.
    * @param {!Array<string>} path
    * @param {!Object} obj
    * @return {?string}
    * @protected
    */

		}, {
			key: 'handleRightArrow_',
			value: function handleRightArrow_(path, obj) {
				if (obj.expanded) {
					path.push(0);
					return Treeview.NODE_REF_PREFIX + path.join('-');
				} else if (obj.children) {
					obj.expanded = true;
					this.nodes = this.nodes;
				}
			}

			/**
    * Toggles the expanded state for the given tree node.
    * @param {!Element} node
    * @protected
    */

		}, {
			key: 'toggleExpandedState_',
			value: function toggleExpandedState_(node) {
				var nodeObj = this.getNodeObj(this.getPath_(node));
				nodeObj.expanded = !nodeObj.expanded;
				this.nodes = this.nodes;
			}
		}]);

		return Treeview;
	}(_metalComponent2.default);

	_metalSoy2.default.register(Treeview, _Treeview2.default);

	// The prefix used for tree item nodes' refs.

	Treeview.NODE_REF_PREFIX = 'node-';

	/**
  * Treeview state definition.
  * @type {!Object}
  * @static
  */

	Treeview.STATE = {

		/**
   * The ref of the last item that has been focused, so that we can retain only
   * that node in the tab order.
   * @type {string}
   */

		lastFocusedRef_: {
			internal: true,
			validator: _metal2.default.isString
		},

		/**
   * This tree view's nodes. Each node should have a name, and can optionally
   * have nested children nodes. It should also indicate if its children are
   * expanded or not.
   * @type {Array<!{children: Array, expanded: boolean?, name: string}>}
   * @default []
   */

		nodes: {
			validator: Array.isArray,
			valueFn: function valueFn() {
				return [];
			}
		}
	};

	exports.Treeview = Treeview;
	exports.default = Treeview;
});
//# sourceMappingURL=Treeview.es.js.map