'use strict';

Liferay.Loader.define("frontend-js-web@2.0.31/liferay/compat/dropdown/Dropdown.es", ['module', 'exports', 'require', 'frontend-js-metal-web$metal-component', 'frontend-js-metal-web$metal-soy', 'frontend-js-metal-web$metal-dom', 'frontend-js-metal-web$metal-position', 'frontend-js-metal-web$metal-events', 'frontend-js-metal-web$metal', './Dropdown.soy'], function (module, exports, require) {
	var define = undefined;
	Object.defineProperty(exports, "__esModule", {
		value: true
	});
	exports.Dropdown = undefined;

	var _createClass = function () {
		function defineProperties(target, props) {
			for (var i = 0; i < props.length; i++) {
				var descriptor = props[i];descriptor.enumerable = descriptor.enumerable || false;descriptor.configurable = true;if ("value" in descriptor) descriptor.writable = true;Object.defineProperty(target, descriptor.key, descriptor);
			}
		}return function (Constructor, protoProps, staticProps) {
			if (protoProps) defineProperties(Constructor.prototype, protoProps);if (staticProps) defineProperties(Constructor, staticProps);return Constructor;
		};
	}();

	var _get = function get(object, property, receiver) {
		if (object === null) object = Function.prototype;var desc = Object.getOwnPropertyDescriptor(object, property);if (desc === undefined) {
			var parent = Object.getPrototypeOf(object);if (parent === null) {
				return undefined;
			} else {
				return get(parent, property, receiver);
			}
		} else if ("value" in desc) {
			return desc.value;
		} else {
			var getter = desc.get;if (getter === undefined) {
				return undefined;
			}return getter.call(receiver);
		}
	};

	var _metalComponent = require("frontend-js-metal-web$metal-component");

	var _metalComponent2 = _interopRequireDefault(_metalComponent);

	var _metalSoy = require("frontend-js-metal-web$metal-soy");

	var _metalSoy2 = _interopRequireDefault(_metalSoy);

	var _metalDom = require("frontend-js-metal-web$metal-dom");

	var _metalDom2 = _interopRequireDefault(_metalDom);

	var _metalPosition = require("frontend-js-metal-web$metal-position");

	var _metalEvents = require("frontend-js-metal-web$metal-events");

	var _metal = require("frontend-js-metal-web$metal");

	var _Dropdown = require('./Dropdown.soy');

	var _Dropdown2 = _interopRequireDefault(_Dropdown);

	function _interopRequireDefault(obj) {
		return obj && obj.__esModule ? obj : { default: obj };
	}

	function _defineProperty(obj, key, value) {
		if (key in obj) {
			Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true });
		} else {
			obj[key] = value;
		}return obj;
	}

	function _classCallCheck(instance, Constructor) {
		if (!(instance instanceof Constructor)) {
			throw new TypeError("Cannot call a class as a function");
		}
	}

	function _possibleConstructorReturn(self, call) {
		if (!self) {
			throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
		}return call && (typeof call === "object" || typeof call === "function") ? call : self;
	}

	function _inherits(subClass, superClass) {
		if (typeof superClass !== "function" && superClass !== null) {
			throw new TypeError("Super expression must either be null or a function, not " + typeof superClass);
		}subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } });if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass;
	}

	/**
  * Dropdown component.
  */

	var Dropdown = function (_Component) {
		_inherits(Dropdown, _Component);

		function Dropdown() {
			_classCallCheck(this, Dropdown);

			return _possibleConstructorReturn(this, (Dropdown.__proto__ || Object.getPrototypeOf(Dropdown)).apply(this, arguments));
		}

		_createClass(Dropdown, [{
			key: 'attached',

			/**
    * @inheritDoc
    */

			value: function attached() {
				_get(Dropdown.prototype.__proto__ || Object.getPrototypeOf(Dropdown.prototype), 'attached', this).call(this);
				this.eventHandler_.add(_metalDom2.default.on(document, 'click', this.handleDocClick_.bind(this)));
			}

			/**
    * @inheritDoc
    */

		}, {
			key: 'created',
			value: function created() {
				this.eventHandler_ = new _metalEvents.EventHandler();
			}

			/**
    * @inheritDoc
    */

		}, {
			key: 'detached',
			value: function detached() {
				_get(Dropdown.prototype.__proto__ || Object.getPrototypeOf(Dropdown.prototype), 'detached', this).call(this);
				this.eventHandler_.removeAllListeners();
			}

			/**
    * Closes the dropdown.
    */

		}, {
			key: 'close',
			value: function close() {
				this.expanded = false;
			}

			/**
    * Checks if the dropdown is currently open.
    * @return {boolean}
    */

		}, {
			key: 'isOpen',
			value: function isOpen() {
				return this.expanded;
			}

			/**
    * Handles document click in order to hide menu.
    * @param {!Event} event
    * @protected
    */

		}, {
			key: 'handleDocClick_',
			value: function handleDocClick_(event) {
				if (this.element.contains(event.target)) {
					return;
				}
				this.close();
			}

			/**
    * Opens the dropdown.
    */

		}, {
			key: 'open',
			value: function open() {
				this.expanded = true;
			}

			/**
    * The setter function for the `classMap` staet.
    * @param {Object} val
    * @return {!Object}
    * @protected
    */

		}, {
			key: 'setterClassMapFn_',
			value: function setterClassMapFn_(val) {
				return _metal.object.mixin(this.valueClassMapFn_(), val);
			}

			/**
    * The setter function for the `position` state. Converts the supported
    * string positions into the appropriate `Align` position constants.
    * @param {string|number} val
    * @return {number}
    * @protected
    */

		}, {
			key: 'setterPositionFn_',
			value: function setterPositionFn_(val) {
				if (_metal.core.isNumber(val)) {
					return val;
				}

				return val.toLowerCase() === 'up' ? _metalPosition.Align.TopLeft : _metalPosition.Align.BottomLeft;
			}

			/**
    * Synchronization logic for `expanded` state.
    * @param {boolean} expanded
    */

		}, {
			key: 'syncExpanded',
			value: function syncExpanded(expanded) {
				if (expanded && this.alignElementSelector) {
					var alignElement = this.element.querySelector(this.alignElementSelector);

					if (alignElement) {
						var bodyElement = this.element.querySelector('.dropdown-menu');

						this.alignedPosition = _metalPosition.Align.align(bodyElement, alignElement, this.position);
					}
				}
			}

			/**
    * Toggles the dropdown, closing it when open or opening it when closed.
    */

		}, {
			key: 'toggle',
			value: function toggle() {
				this.expanded = !this.expanded;
			}

			/**
    * Validator for the `position` state.
    * @param {string|number} position
    * @return {boolean}
    * @protected
    */

		}, {
			key: 'validatePosition_',
			value: function validatePosition_(position) {
				if (_metalPosition.Align.isValidPosition(position)) {
					return true;
				}
				switch (position.toLowerCase()) {
					case 'up':
					case 'down':
						return true;
					default:
						return false;
				}
			}

			/**
    * Gets the default value for the `body` state. Retrieves existing
    * html for the body from the element, if there is any.
    * @return {?string}
    * @protected
    */

		}, {
			key: 'valueBodyFn_',
			value: function valueBodyFn_() {
				var dropdownMenu = this.element && this.element.querySelector('.dropdown-menu');

				return dropdownMenu ? dropdownMenu.innerHTML : '';
			}

			/**
    * Gets the default value for the `classMap` state.
    * @return {!Object}
    * @protected
    */

		}, {
			key: 'valueClassMapFn_',
			value: function valueClassMapFn_() {
				var _ref;

				return _ref = {}, _defineProperty(_ref, _metalPosition.Align.TopLeft, 'dropup'), _defineProperty(_ref, _metalPosition.Align.TopCenter, 'dropup'), _defineProperty(_ref, _metalPosition.Align.TopRight, 'dropup'), _defineProperty(_ref, _metalPosition.Align.BottomLeft, 'dropdown'), _defineProperty(_ref, _metalPosition.Align.BottomCenter, 'dropdown'), _defineProperty(_ref, _metalPosition.Align.BottomRight, 'dropdown'), _defineProperty(_ref, _metalPosition.Align.RightCenter, 'dropright'), _defineProperty(_ref, _metalPosition.Align.LeftCenter, 'dropleft'), _ref;
			}

			/**
    * Gets the default value for the `header` state. Retrieves existing
    * html for the header from the element, if there is any.
    * @return {?string}
    * @protected
    */

		}, {
			key: 'valueHeaderFn_',
			value: function valueHeaderFn_() {
				if (this.element) {
					var wrapper = document.createElement('div');

					for (var i = 0; i < this.element.childNodes.length; i++) {
						if (_metalDom2.default.hasClass(this.element.childNodes[i], 'dropdown-menu')) {
							break;
						}
						wrapper.appendChild(this.element.childNodes[i].cloneNode(true));
					}

					return wrapper.innerHTML;
				}

				return '';
			}
		}]);

		return Dropdown;
	}(_metalComponent2.default);

	_metalSoy2.default.register(Dropdown, _Dropdown2.default);

	/**
  * State definition.
  * @type {!Object}
  * @static
  */

	Dropdown.STATE = {

		/**
   * The current position of the tooltip after being aligned via `Align.align`.
   * @type {number}
   */

		alignedPosition: {
			validator: _metalPosition.Align.isValidPosition
		},

		/**
   * Optional selector for finding the element that the dropdown should be
   * aligned to. If given, the dropdown will automatically find the best position
   * to align, when the specified position doesn't work. Otherwise it will
   * always just follow the given position, even if it's not ideal.
   * @type {string}
   */

		alignElementSelector: {
			validator: _metal.core.isString
		},

		/**
   * The dropdown's body content.
   * @type {string}
   */

		body: {
			isHtml: true,
			valueFn: 'valueBodyFn_'
		},

		/**
   * A map from `Align` position constants to the CSS class that should be
   * added to the dropdown when it's aligned in that position.
   * @type {!Object}
   */

		classMap: {
			setter: 'setterClassMapFn_',
			validator: _metal.core.isObject,
			valueFn: 'valueClassMapFn_'
		},

		/**
   * The dropdown's header content.
   * @type {string}
   */

		header: {
			isHtml: true,
			valueFn: 'valueHeaderFn_'
		},

		/**
   * Flag indicating if the dropdown is expanded (open) or not.
   * @type {boolean}
   * @default false
   */

		expanded: {
			value: false,
			internal: true
		},

		/**
   * The position of the dropdown (either 'up', 'down' or any of the position
   * constants available in `Align`).
   * @type {string|number}
   * @default Align.BottomLeft
   */

		position: {
			setter: 'setterPositionFn_',
			value: _metalPosition.Align.BottomLeft,
			validator: 'validatePosition_'
		},

		/**
   * Flag indicating if the position class (specified by `classMap` state)
   * should be added on the "dropdown-menu" element, instead of the main element.
   * @type {boolean}
   */

		positionClassOnMenu: {
			value: false
		}
	};

	exports.Dropdown = Dropdown;
	exports.default = Dropdown;
});
//# sourceMappingURL=Dropdown.es.js.map