'use strict';

Liferay.Loader.define("frontend-js-web@2.0.31/liferay/compat/alert/Alert.es", ['module', 'exports', 'require', 'frontend-js-metal-web$metal', 'frontend-js-metal-web$metal-dom', 'frontend-js-metal-web$metal-anim', 'frontend-js-metal-web$metal-component', 'frontend-js-metal-web$metal-events', 'frontend-js-metal-web$metal-soy', './Alert.soy'], function (module, exports, require) {
	var define = undefined;
	Object.defineProperty(exports, "__esModule", {
		value: true
	});
	exports.Alert = undefined;

	var _createClass = function () {
		function defineProperties(target, props) {
			for (var i = 0; i < props.length; i++) {
				var descriptor = props[i];descriptor.enumerable = descriptor.enumerable || false;descriptor.configurable = true;if ("value" in descriptor) descriptor.writable = true;Object.defineProperty(target, descriptor.key, descriptor);
			}
		}return function (Constructor, protoProps, staticProps) {
			if (protoProps) defineProperties(Constructor.prototype, protoProps);if (staticProps) defineProperties(Constructor, staticProps);return Constructor;
		};
	}();

	var _get = function get(object, property, receiver) {
		if (object === null) object = Function.prototype;var desc = Object.getOwnPropertyDescriptor(object, property);if (desc === undefined) {
			var parent = Object.getPrototypeOf(object);if (parent === null) {
				return undefined;
			} else {
				return get(parent, property, receiver);
			}
		} else if ("value" in desc) {
			return desc.value;
		} else {
			var getter = desc.get;if (getter === undefined) {
				return undefined;
			}return getter.call(receiver);
		}
	};

	var _metal = require("frontend-js-metal-web$metal");

	var _metalDom = require("frontend-js-metal-web$metal-dom");

	var _metalDom2 = _interopRequireDefault(_metalDom);

	var _metalAnim = require("frontend-js-metal-web$metal-anim");

	var _metalAnim2 = _interopRequireDefault(_metalAnim);

	var _metalComponent = require("frontend-js-metal-web$metal-component");

	var _metalComponent2 = _interopRequireDefault(_metalComponent);

	var _metalEvents = require("frontend-js-metal-web$metal-events");

	var _metalSoy = require("frontend-js-metal-web$metal-soy");

	var _metalSoy2 = _interopRequireDefault(_metalSoy);

	var _Alert = require('./Alert.soy');

	var _Alert2 = _interopRequireDefault(_Alert);

	function _interopRequireDefault(obj) {
		return obj && obj.__esModule ? obj : { default: obj };
	}

	function _classCallCheck(instance, Constructor) {
		if (!(instance instanceof Constructor)) {
			throw new TypeError("Cannot call a class as a function");
		}
	}

	function _possibleConstructorReturn(self, call) {
		if (!self) {
			throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
		}return call && (typeof call === "object" || typeof call === "function") ? call : self;
	}

	function _inherits(subClass, superClass) {
		if (typeof superClass !== "function" && superClass !== null) {
			throw new TypeError("Super expression must either be null or a function, not " + typeof superClass);
		}subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } });if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass;
	}

	/**
  * Alert component.
  */

	var Alert = function (_Component) {
		_inherits(Alert, _Component);

		function Alert() {
			_classCallCheck(this, Alert);

			return _possibleConstructorReturn(this, (Alert.__proto__ || Object.getPrototypeOf(Alert)).apply(this, arguments));
		}

		_createClass(Alert, [{
			key: 'created',

			/**
    * @inheritDoc
    */

			value: function created() {
				this.eventHandler_ = new _metalEvents.EventHandler();
			}

			/**
    * @inheritDoc
    */

		}, {
			key: 'detached',
			value: function detached() {
				_get(Alert.prototype.__proto__ || Object.getPrototypeOf(Alert.prototype), 'detached', this).call(this);
				this.eventHandler_.removeAllListeners();
				clearTimeout(this.delay_);
			}

			/**
    * Closes the alert, disposing it once the animation ends.
    */

		}, {
			key: 'close',
			value: function close() {
				_metalDom2.default.once(this.element, 'animationend', this.dispose.bind(this));
				_metalDom2.default.once(this.element, 'transitionend', this.dispose.bind(this));
				this.eventHandler_.removeAllListeners();
				this.syncVisible(false);
			}

			/**
    * Handles document click in order to hide the alert.
    * @param {!Event} event
    * @protected
    */

		}, {
			key: 'handleDocClick_',
			value: function handleDocClick_(event) {
				if (!this.element.contains(event.target)) {
					this.hide();
				}
			}

			/**
    * Hide the alert.
    */

		}, {
			key: 'hide',
			value: function hide() {
				this.visible = false;
			}

			/**
    * Hides the alert completely (with display "none"). This is called after the
    * hiding animation is done.
    * @protected
    */

		}, {
			key: 'hideCompletely_',
			value: function hideCompletely_() {
				if (!this.isDisposed() && !this.visible) {
					_get(Alert.prototype.__proto__ || Object.getPrototypeOf(Alert.prototype), 'syncVisible', this).call(this, false);
				}
			}

			/**
    * Toggles the visibility of the alert.
    */

		}, {
			key: 'toggle',
			value: function toggle() {
				this.visible = !this.visible;
			}

			/**
    * Show the alert.
    */

		}, {
			key: 'show',
			value: function show() {
				this.visible = true;
			}

			/**
    * Synchronization logic for `dismissible` state. If the alert is dismissible,
    * a click event handler will be attached.
    * @param {boolean} dismissible
    */

		}, {
			key: 'syncDismissible',
			value: function syncDismissible(dismissible) {
				if (dismissible) {
					this.eventHandler_.add(_metalDom2.default.on(document, 'click', this.handleDocClick_.bind(this)));
				} else {
					this.eventHandler_.removeAllListeners();
				}
			}

			/**
    * Synchronization logic for `hideDelay` state. When hideDelay has a valid value,
    * the alert will hide in the time (ms) defined.
    * @param {?number} hideDelay
    */

		}, {
			key: 'syncHideDelay',
			value: function syncHideDelay(hideDelay) {
				if (_metal.core.isNumber(hideDelay) && this.visible) {
					clearTimeout(this.delay_);
					this.delay_ = setTimeout(this.hide.bind(this), hideDelay);
				}
			}

			/**
    * Synchronization logic for `visible` state. Adds and removes show/hide classes
    * based on the visibility of the alert.
    * @param {boolean} visible
    */

		}, {
			key: 'syncVisible',
			value: function syncVisible(visible, prevVisible) {
				var _this2 = this;

				var shouldAsync = false;
				if (!visible) {
					_metalDom2.default.once(this.element, 'animationend', this.hideCompletely_.bind(this));
					_metalDom2.default.once(this.element, 'transitionend', this.hideCompletely_.bind(this));
				} else if (_metal.core.isDef(prevVisible)) {
					shouldAsync = true;
					_get(Alert.prototype.__proto__ || Object.getPrototypeOf(Alert.prototype), 'syncVisible', this).call(this, true);
				}

				var showOrHide = function showOrHide() {
					if (_this2.isDisposed()) {
						return;
					}

					_metalDom2.default.removeClasses(_this2.element, _this2.animClasses[visible ? 'hide' : 'show']);
					_metalDom2.default.addClasses(_this2.element, _this2.animClasses[visible ? 'show' : 'hide']);

					// Some browsers do not fire transitionend events when running in background
					// tab, see https://bugzilla.mozilla.org/show_bug.cgi?id=683696.

					_metalAnim2.default.emulateEnd(_this2.element);

					if (visible && _metal.core.isNumber(_this2.hideDelay)) {
						_this2.syncHideDelay(_this2.hideDelay);
					}
				};

				if (shouldAsync) {

					// We need to start the animation asynchronously because of the possible
					// previous call to `super.syncVisible`, which doesn't allow the show
					// animation to work as expected.

					setTimeout(showOrHide, 0);
				} else {
					showOrHide();
				}
			}
		}]);

		return Alert;
	}(_metalComponent2.default);

	_metalSoy2.default.register(Alert, _Alert2.default);

	/**
  * Alert state definition.
  * @type {!Object}
  * @static
  */

	Alert.STATE = {

		/**
   * The CSS classes that should be added to the alert when being shown/hidden.
   * @type {!Object}
   */

		animClasses: {
			validator: _metal.core.isObject,
			value: {
				show: 'fade in',
				hide: 'fade'
			}
		},

		/**
   * The body content of the alert.
   * @type {html|string}
   */

		body: {},

		/**
   * The content of close button of the alert.
   * @type {html|string}
   */

		closeButtonHtml: {},

		/**
   * Flag indicating if the alert should be dismissable (closeable).
   * @type {boolean}
   * @default true
   */

		dismissible: {
			validator: _metal.core.isBoolean,
			value: true
		},

		/**
   * The CSS classes that should be added to the alert.
   * @type {string}
   * @default 'alert-success'
   */

		elementClasses: {
			value: 'alert-success'
		},

		/**
   * Delay hiding the alert (ms).
   * @type {?number}
   */

		hideDelay: {
			validator: _metal.core.isNumber
		},

		/**
   * Flag indicating if the alert is visible or not.
   * @type {boolean}
   * @default false
   */

		visible: {
			validator: _metal.core.isBoolean,
			value: false
		}
	};

	exports.Alert = Alert;
	exports.default = Alert;
});
//# sourceMappingURL=Alert.es.js.map