'use strict';

Liferay.Loader.define("frontend-js-web@2.0.31/liferay/PortletBase.es", ['module', 'exports', 'require', 'frontend-js-metal-web$metal', 'frontend-js-metal-web$metal-dom', 'frontend-js-metal-web$metal-component', './util/object_to_form_data.es'], function (module, exports, require) {
	var define = undefined;
	Object.defineProperty(exports, "__esModule", {
		value: true
	});

	var _typeof = typeof Symbol === "function" && typeof Symbol.iterator === "symbol" ? function (obj) {
		return typeof obj;
	} : function (obj) {
		return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj;
	};

	var _createClass = function () {
		function defineProperties(target, props) {
			for (var i = 0; i < props.length; i++) {
				var descriptor = props[i];descriptor.enumerable = descriptor.enumerable || false;descriptor.configurable = true;if ("value" in descriptor) descriptor.writable = true;Object.defineProperty(target, descriptor.key, descriptor);
			}
		}return function (Constructor, protoProps, staticProps) {
			if (protoProps) defineProperties(Constructor.prototype, protoProps);if (staticProps) defineProperties(Constructor, staticProps);return Constructor;
		};
	}();

	var _metal = require("frontend-js-metal-web$metal");

	var _metal2 = _interopRequireDefault(_metal);

	var _metalDom = require("frontend-js-metal-web$metal-dom");

	var _metalDom2 = _interopRequireDefault(_metalDom);

	var _metalComponent = require("frontend-js-metal-web$metal-component");

	var _metalComponent2 = _interopRequireDefault(_metalComponent);

	var _object_to_form_data = require('./util/object_to_form_data.es');

	var _object_to_form_data2 = _interopRequireDefault(_object_to_form_data);

	function _interopRequireDefault(obj) {
		return obj && obj.__esModule ? obj : { default: obj };
	}

	function _classCallCheck(instance, Constructor) {
		if (!(instance instanceof Constructor)) {
			throw new TypeError("Cannot call a class as a function");
		}
	}

	function _possibleConstructorReturn(self, call) {
		if (!self) {
			throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
		}return call && (typeof call === "object" || typeof call === "function") ? call : self;
	}

	function _inherits(subClass, superClass) {
		if (typeof superClass !== "function" && superClass !== null) {
			throw new TypeError("Super expression must either be null or a function, not " + typeof superClass);
		}subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } });if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass;
	}

	/**
  * PortletBase provides some helper functions that simplify querying the DOM
  * for elements related to a specific portlet.
  * @abstract
  * @extends {Component}
  * @review
  */

	var PortletBase = function (_Component) {
		_inherits(PortletBase, _Component);

		function PortletBase() {
			_classCallCheck(this, PortletBase);

			return _possibleConstructorReturn(this, (PortletBase.__proto__ || Object.getPrototypeOf(PortletBase)).apply(this, arguments));
		}

		_createClass(PortletBase, [{
			key: 'all',

			/**
    * Returns a NodeList containing all of the matching Element nodes within
    * the subtrees of the root object, in tree order. If there are no matching
    * nodes, the method returns an empty NodeList.
    * @param {string} selectors List of one or more CSS relative selectors
    * @param {(string|Element|Document)=} root Root node of the search. If not
    * specified, the element search will start in the portlet's root node or in
    * the document
    * @return {NodeList<Element>} List of Elements matching the selectors in
    * tree order
    * @review
    */

			value: function all(selectors, root) {
				root = _metalDom2.default.toElement(root) || this.rootNode || document;

				return root.querySelectorAll(this.namespaceSelectors_(this.portletNamespace || this.namespace, selectors));
			}

			/**
    * Performs an HTTP POST request to the given url with the given body.
    * @param {!string} url Where to send the post request
    * @param {!Object|!FormData} body Request body
    * @return {Promise}
    * @review
    */

		}, {
			key: 'fetch',
			value: function (_fetch) {
				function fetch(_x, _x2) {
					return _fetch.apply(this, arguments);
				}

				fetch.toString = function () {
					return _fetch.toString();
				};

				return fetch;
			}(function (url, body) {
				var requestBody = this.getRequestBody_(body);

				return fetch(url, {
					body: requestBody,
					credentials: 'include',
					method: 'POST'
				});
			})

			/**
    * Transform the given body into a valid FormData element.
    * @param {!FormData|!HTMLFormElement|!Object} body Original data
    * @return {FormData} Transformed FormData
    * @review
    */

		}, {
			key: 'getRequestBody_',
			value: function getRequestBody_(body) {
				var requestBody = void 0;

				if (body instanceof FormData) {
					requestBody = body;
				} else if (body instanceof HTMLFormElement) {
					requestBody = new FormData(body);
				} else if ((typeof body === 'undefined' ? 'undefined' : _typeof(body)) === 'object') {
					requestBody = (0, _object_to_form_data2.default)(this.ns(body));
				} else {
					requestBody = body;
				}

				return requestBody;
			}

			/**
    * Namespaces the list of selectors appending the portlet namespace to the
    * selectors of type id. Selectors of other types remain unaltered.
    * @param {string} namespace The portlet's namespace
    * @param {string} selectors List of one or more CSS relative selectors
    * @protected
    * @return {string} Namespaced id selectors
    * @review
    */

		}, {
			key: 'namespaceSelectors_',
			value: function namespaceSelectors_(namespace, selectors) {
				return selectors.replace(new RegExp('(#|\\[id=(\\"|\\\'))(?!' + namespace + ')', 'g'), '$1' + namespace);
			}

			/**
    * Appends the portlet's namespace to the given string or object properties.
    * @param {!Object|string} obj The object or string to be namespaced
    * @return {Object|string} An object with its properties namespaced using
    * the portlet namespace or a namespaced string
    * @review
    */

		}, {
			key: 'ns',
			value: function ns(obj) {
				return Liferay.Util.ns(this.portletNamespace || this.namespace, obj);
			}

			/**
    * Returns the first matching Element node within the subtrees of the
    * root object. If there is no matching Element, the method returns null.
    * @param {string} selectors List of one or more CSS relative selectors
    * @param {(string|Element|Document)=} root Root node of the search. If not
    * specified, the element search will start in the portlet's root node or in
    * the document
    * @return {Element|null} List of First Element matching the selectors or null
    * @review
    */

		}, {
			key: 'one',
			value: function one(selectors, root) {
				root = _metalDom2.default.toElement(root) || this.rootNode || document;

				return root.querySelector(this.namespaceSelectors_(this.portletNamespace || this.namespace, selectors));
			}

			/**
    * Returns the default portlet root node element. By default, this is the
    * element with id "p_p_id{portletNamespace}".
    * @protected
    * @return {Element} The portlet's default root node element
    * @review
    */

		}, {
			key: 'rootNodeValueFn_',
			value: function rootNodeValueFn_() {
				return _metalDom2.default.toElement('#p_p_id' + (this.portletNamespace || this.namespace));
			}
		}]);

		return PortletBase;
	}(_metalComponent2.default);

	/**
  * State definition.
  * @ignore
  * @review
  * @static
  * @type {!Object}
  */

	PortletBase.STATE = {

		/**
   * Portlet's namespace
   * @deprecated since 7.1
   * @instance
   * @memberof PortletBase
   * @review
   * @type {string}
   */

		namespace: {
			validator: _metal2.default.isString
		},

		/**
   * Portlet's namespace
   * @instance
   * @memberof PortletBase
   * @review
   * @type {string}
   */

		portletNamespace: {
			validator: _metal2.default.isString
		},

		/**
   * Portlet's root node element
   * @instance
   * @memberof PortletBase
   * @review
   * @type {Element}
   */

		rootNode: {
			setter: _metalDom2.default.toElement,
			valueFn: 'rootNodeValueFn_'
		}
	};

	exports.default = PortletBase;
});
//# sourceMappingURL=PortletBase.es.js.map