'use strict';

Liferay.Loader.define("frontend-js-web@2.0.31/liferay/DynamicInlineScroll.es", ['module', 'exports', 'require', 'frontend-js-metal-web$metal', 'frontend-js-metal-web$metal-dom', 'frontend-js-metal-web$metal-events', './PortletBase.es'], function (module, exports, require) {
	var define = undefined;
	Object.defineProperty(exports, "__esModule", {
		value: true
	});

	var _createClass = function () {
		function defineProperties(target, props) {
			for (var i = 0; i < props.length; i++) {
				var descriptor = props[i];descriptor.enumerable = descriptor.enumerable || false;descriptor.configurable = true;if ("value" in descriptor) descriptor.writable = true;Object.defineProperty(target, descriptor.key, descriptor);
			}
		}return function (Constructor, protoProps, staticProps) {
			if (protoProps) defineProperties(Constructor.prototype, protoProps);if (staticProps) defineProperties(Constructor, staticProps);return Constructor;
		};
	}();

	var _get = function get(object, property, receiver) {
		if (object === null) object = Function.prototype;var desc = Object.getOwnPropertyDescriptor(object, property);if (desc === undefined) {
			var parent = Object.getPrototypeOf(object);if (parent === null) {
				return undefined;
			} else {
				return get(parent, property, receiver);
			}
		} else if ("value" in desc) {
			return desc.value;
		} else {
			var getter = desc.get;if (getter === undefined) {
				return undefined;
			}return getter.call(receiver);
		}
	};

	var _metal = require("frontend-js-metal-web$metal");

	var _metal2 = _interopRequireDefault(_metal);

	var _metalDom = require("frontend-js-metal-web$metal-dom");

	var _metalDom2 = _interopRequireDefault(_metalDom);

	var _metalEvents = require("frontend-js-metal-web$metal-events");

	var _PortletBase2 = require('./PortletBase.es');

	var _PortletBase3 = _interopRequireDefault(_PortletBase2);

	function _interopRequireDefault(obj) {
		return obj && obj.__esModule ? obj : { default: obj };
	}

	function _classCallCheck(instance, Constructor) {
		if (!(instance instanceof Constructor)) {
			throw new TypeError("Cannot call a class as a function");
		}
	}

	function _possibleConstructorReturn(self, call) {
		if (!self) {
			throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
		}return call && (typeof call === "object" || typeof call === "function") ? call : self;
	}

	function _inherits(subClass, superClass) {
		if (typeof superClass !== "function" && superClass !== null) {
			throw new TypeError("Super expression must either be null or a function, not " + typeof superClass);
		}subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } });if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass;
	}

	/**
  * DynamicInlineScroll appends list item elements to dropdown menus with inline-scrollers
  * on scroll events to improve page load performance.
  *
  * @extends {Component}
  * @review
  */

	var DynamicInlineScroll = function (_PortletBase) {
		_inherits(DynamicInlineScroll, _PortletBase);

		function DynamicInlineScroll() {
			_classCallCheck(this, DynamicInlineScroll);

			return _possibleConstructorReturn(this, (DynamicInlineScroll.__proto__ || Object.getPrototypeOf(DynamicInlineScroll)).apply(this, arguments));
		}

		_createClass(DynamicInlineScroll, [{
			key: 'created',

			/**
    * @inheritDoc
    * @review
    */

			value: function created() {
				this.eventHandler_ = new _metalEvents.EventHandler();
			}

			/**
    * @inheritDoc
    * @review
    */

		}, {
			key: 'attached',
			value: function attached() {
				var rootNode = this.rootNode;

				rootNode = rootNode || document;

				this.eventHandler_.add(_metalDom2.default.delegate(rootNode, 'scroll', 'ul.pagination ul.inline-scroller', this.onScroll_.bind(this)));
			}

			/**
    * @inheritDoc
    * @review
    */

		}, {
			key: 'detached',
			value: function detached() {
				_get(DynamicInlineScroll.prototype.__proto__ || Object.getPrototypeOf(DynamicInlineScroll.prototype), 'detached', this).call(this);

				this.eventHandler_.removeAllListeners();
			}

			/**
    * Dynamically adds list item elements to the dropdown menu.
    * @param {element} listElement Dom node of the list element.
    * @param {number} pageIndex Index of page with an inline-scroller.
    * @protected
    * @review
    */

		}, {
			key: 'addListItem_',
			value: function addListItem_(listElement, pageIndex) {
				var listItem = document.createElement('li');

				_metalDom2.default.append(listItem, '<a href="' + this.getHREF_(pageIndex) + '">' + pageIndex + '</a>');

				pageIndex++;

				listElement.appendChild(listItem);
				listElement.setAttribute('data-page-index', pageIndex);

				this.eventHandler_.add(_metalDom2.default.on(listItem, 'click', this.handleListItemClick_.bind(this)));
			}

			/**
    * Returns the href attribute value for each
    * @param {number} pageIndex Index of page
    * @protected
    * @return {string} String value of href
    * @review
    */

		}, {
			key: 'getHREF_',
			value: function getHREF_(pageIndex) {
				var curParam = this.curParam,
				    formName = this.formName,
				    jsCall = this.jsCall,
				    namespace = this.namespace,
				    url = this.url,
				    urlAnchor = this.urlAnchor;

				var href = 'javascript:document.' + formName + '.' + namespace + curParam + '.value = "' + pageIndex + '; ' + jsCall;

				if (this.url !== null) {
					href = '' + url + namespace + curParam + '=' + pageIndex + urlAnchor;
				}

				return href;
			}

			/**
    * Returns the value of the parameter passed in as a Number object
    * @param {string|!Object} val The string or Object to be converted to a number
    * @protected
    * @return {number} Number value of parameter
    * @review
    */

		}, {
			key: 'getNumber_',
			value: function getNumber_(val) {
				return Number(val);
			}

			/**
    * Handles click event of dynmaically added list item and submits search
    * container form.
    * @param {Event} event The click event of the dynamically added list item.
    * @protected
    * @review
    */

		}, {
			key: 'handleListItemClick_',
			value: function handleListItemClick_(event) {
				if (this.forcePost) {
					event.preventDefault();

					var curParam = this.curParam,
					    namespace = this.namespace,
					    randomNamespace = this.randomNamespace;

					var form = document.getElementById(randomNamespace + namespace + 'pageIteratorFm');

					form.elements[namespace + curParam].value = event.currentTarget.textContent;

					form.submit();
				}
			}

			/**
    * An event triggered when a dropdown menu with an inline-scroller is scrolled.
    * Dynamically adds list item elements to the dropdown menu as it is scrolled down.
    * @param {Event} event The scroll event triggered by scrolling a dropdown menu
    * with an inline-scroller
    * @protected
    * @review
    */

		}, {
			key: 'onScroll_',
			value: function onScroll_(event) {
				var cur = this.cur,
				    initialPages = this.initialPages,
				    pages = this.pages;
				var target = event.target;

				var pageIndex = this.getNumber_(target.getAttribute('data-page-index'));
				var pageIndexMax = this.getNumber_(target.getAttribute('data-max-index'));

				if (pageIndex === 0) {
					var pageIndexCurrent = this.getNumber_(target.getAttribute('data-current-index'));

					if (pageIndexCurrent === 0) {
						pageIndex = initialPages;
					} else {
						pageIndex = pageIndexCurrent + initialPages;
					}
				}

				if (pageIndexMax === 0) {
					pageIndexMax = pages;
				}

				if (cur <= pages && pageIndex < pageIndexMax && target.getAttribute('scrollTop') >= target.getAttribute('scrollHeight') - 300) {
					this.addListItem_(target, pageIndex);
				}
			}
		}]);

		return DynamicInlineScroll;
	}(_PortletBase3.default);

	/**
  * State definition.
  * @ignore
  * @review
  * @static
  * @type {!Object}
  */

	DynamicInlineScroll.STATE = {

		/**
   * Current page
   * @instance
   * @memberof DynamicInlineScroll
   * @review
   * @type {string}
   */

		cur: {
			setter: 'getNumber_',
			validator: _metal2.default.isString
		},

		/**
   * URL parameter for current page
   * @instance
   * @memberof DynamicInlineScroll
   * @review
   * @type {string}
   */

		curParam: {
			validator: _metal2.default.isString
		},

		/**
   * Forces a form post when a page on the dropdown menu is clicked
   * @instance
   * @memberof DynamicInlineScroll
   * @review
   * @type {boolean}
   */

		forcePost: {
			validator: _metal2.default.isBoolean
		},

		/**
   * Form name
   * @instance
   * @memberof DynamicInlineScroll
   * @review
   * @type {string}
   */

		formName: {
			validator: _metal2.default.isString
		},

		/**
   * Number of pages loaded to the inline-scroll dropdown menu for the first
   * page load
   * @instance
   * @memberof DynamicInlineScroll
   * @review
   * @type {string}
   */

		initialPages: {
			setter: 'getNumber_',
			validator: _metal2.default.isString
		},

		/**
   * JavaScript call
   * @instance
   * @memberof DynamicInlineScroll
   * @review
   * @type {string}
   */

		jsCall: {
			validator: _metal2.default.isString
		},

		/**
   * Namespace
   * @instance
   * @memberof DynamicInlineScroll
   * @review
   * @type {string}
   */

		namespace: {
			validator: _metal2.default.isString
		},

		/**
   * Total number of pages
   * @instance
   * @memberof DynamicInlineScroll
   * @review
   * @type {string}
   */

		pages: {
			setter: 'getNumber_',
			validator: _metal2.default.isString
		},

		/**
   * Random namespace
   * @instance
   * @memberof DynamicInlineScroll
   * @review
   * @type {string}
   */

		randomNamespace: {
			validator: _metal2.default.isString
		},

		/**
   * URL
   * @instance
   * @memberof DynamicInlineScroll
   * @review
   * @type {string}
   */

		url: {
			validator: _metal2.default.isString
		},

		/**
   * URL anchor
   * @instance
   * @memberof DynamicInlineScroll
   * @review
   * @type {string}
   */

		urlAnchor: {
			validator: _metal2.default.isString
		}
	};

	exports.default = DynamicInlineScroll;
});
//# sourceMappingURL=DynamicInlineScroll.es.js.map