Liferay.Loader.define('frontend-js-tooltip-support-web$lodash-es@4.17.15/sum', ['module', 'exports', 'require'], function (module, exports, require) {
  var define = undefined;
  var global = window;
  {
    import baseSum from './_baseSum.js';
    import identity from './identity.js';

    /**
     * Computes the sum of the values in `array`.
     *
     * @static
     * @memberOf _
     * @since 3.4.0
     * @category Math
     * @param {Array} array The array to iterate over.
     * @returns {number} Returns the sum.
     * @example
     *
     * _.sum([4, 2, 8, 6]);
     * // => 20
     */
    function sum(array) {
      return array && array.length ? baseSum(array, identity) : 0;
    }

    export default sum;
  }
});
//# sourceMappingURL=sum.js.map