Liferay.Loader.define('frontend-js-tooltip-support-web$node-fetch@1.7.3/lib/request', ['module', 'exports', 'require', 'frontend-js-node-shims$url', './headers', './body'], function (module, exports, require) {
	var define = undefined;

	/**
  * request.js
  *
  * Request class contains server only options
  */

	var parse_url = require('frontend-js-node-shims$url').parse;
	var Headers = require('./headers');
	var Body = require('./body');

	module.exports = Request;

	/**
  * Request class
  *
  * @param   Mixed   input  Url or Request instance
  * @param   Object  init   Custom options
  * @return  Void
  */
	function Request(input, init) {
		var url, url_parsed;

		// normalize input
		if (!(input instanceof Request)) {
			url = input;
			url_parsed = parse_url(url);
			input = {};
		} else {
			url = input.url;
			url_parsed = parse_url(url);
		}

		// normalize init
		init = init || {};

		// fetch spec options
		this.method = init.method || input.method || 'GET';
		this.redirect = init.redirect || input.redirect || 'follow';
		this.headers = new Headers(init.headers || input.headers || {});
		this.url = url;

		// server only options
		this.follow = init.follow !== undefined ? init.follow : input.follow !== undefined ? input.follow : 20;
		this.compress = init.compress !== undefined ? init.compress : input.compress !== undefined ? input.compress : true;
		this.counter = init.counter || input.counter || 0;
		this.agent = init.agent || input.agent;

		Body.call(this, init.body || this._clone(input), {
			timeout: init.timeout || input.timeout || 0,
			size: init.size || input.size || 0
		});

		// server request options
		this.protocol = url_parsed.protocol;
		this.hostname = url_parsed.hostname;
		this.port = url_parsed.port;
		this.path = url_parsed.path;
		this.auth = url_parsed.auth;
	}

	Request.prototype = Object.create(Body.prototype);

	/**
  * Clone this request
  *
  * @return  Request
  */
	Request.prototype.clone = function () {
		return new Request(this);
	};
});
//# sourceMappingURL=request.js.map